/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/pipeline_job.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * The runtime detail of a pipeline executor.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.PipelineTaskExecutorDetail}
 */
public final class PipelineTaskExecutorDetail extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail)
    PipelineTaskExecutorDetailOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PipelineTaskExecutorDetail.newBuilder() to construct.
  private PipelineTaskExecutorDetail(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PipelineTaskExecutorDetail() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PipelineTaskExecutorDetail();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PipelineTaskExecutorDetail(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.Builder
                  subBuilder = null;
              if (detailsCase_ == 1) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 1;
              break;
            }
          case 18:
            {
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.Builder
                  subBuilder = null;
              if (detailsCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 2;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.Pipeline
        .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.Pipeline
        .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.class,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.Builder.class);
  }

  public interface ContainerDetailOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
     * </pre>
     *
     * <code>
     * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The mainJob.
     */
    java.lang.String getMainJob();
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
     * </pre>
     *
     * <code>
     * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for mainJob.
     */
    com.google.protobuf.ByteString getMainJobBytes();

    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
     * execution. This job will be available if the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
     * the lifecycle events.
     * </pre>
     *
     * <code>
     * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The preCachingCheckJob.
     */
    java.lang.String getPreCachingCheckJob();
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
     * execution. This job will be available if the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
     * the lifecycle events.
     * </pre>
     *
     * <code>
     * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for preCachingCheckJob.
     */
    com.google.protobuf.ByteString getPreCachingCheckJobBytes();
  }
  /**
   *
   *
   * <pre>
   * The detail of a container execution. It contains the job names of the
   * lifecycle of a container execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail}
   */
  public static final class ContainerDetail extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
      ContainerDetailOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ContainerDetail.newBuilder() to construct.
    private ContainerDetail(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ContainerDetail() {
      mainJob_ = "";
      preCachingCheckJob_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ContainerDetail();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ContainerDetail(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                mainJob_ = s;
                break;
              }
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();

                preCachingCheckJob_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_ContainerDetail_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_ContainerDetail_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.class,
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.Builder
                  .class);
    }

    public static final int MAIN_JOB_FIELD_NUMBER = 1;
    private volatile java.lang.Object mainJob_;
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
     * </pre>
     *
     * <code>
     * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The mainJob.
     */
    @java.lang.Override
    public java.lang.String getMainJob() {
      java.lang.Object ref = mainJob_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mainJob_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
     * </pre>
     *
     * <code>
     * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for mainJob.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMainJobBytes() {
      java.lang.Object ref = mainJob_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mainJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRE_CACHING_CHECK_JOB_FIELD_NUMBER = 2;
    private volatile java.lang.Object preCachingCheckJob_;
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
     * execution. This job will be available if the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
     * the lifecycle events.
     * </pre>
     *
     * <code>
     * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The preCachingCheckJob.
     */
    @java.lang.Override
    public java.lang.String getPreCachingCheckJob() {
      java.lang.Object ref = preCachingCheckJob_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        preCachingCheckJob_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
     * execution. This job will be available if the
     * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
     * the lifecycle events.
     * </pre>
     *
     * <code>
     * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for preCachingCheckJob.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPreCachingCheckJobBytes() {
      java.lang.Object ref = preCachingCheckJob_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        preCachingCheckJob_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainJob_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, mainJob_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preCachingCheckJob_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, preCachingCheckJob_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mainJob_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, mainJob_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(preCachingCheckJob_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, preCachingCheckJob_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail other =
          (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail) obj;

      if (!getMainJob().equals(other.getMainJob())) return false;
      if (!getPreCachingCheckJob().equals(other.getPreCachingCheckJob())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAIN_JOB_FIELD_NUMBER;
      hash = (53 * hash) + getMainJob().hashCode();
      hash = (37 * hash) + PRE_CACHING_CHECK_JOB_FIELD_NUMBER;
      hash = (53 * hash) + getPreCachingCheckJob().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The detail of a container execution. It contains the job names of the
     * lifecycle of a container execution.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetailOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_ContainerDetail_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_ContainerDetail_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.class,
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        mainJob_ = "";

        preCachingCheckJob_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_ContainerDetail_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail build() {
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
          buildPartial() {
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail result =
            new com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail(this);
        result.mainJob_ = mainJob_;
        result.preCachingCheckJob_ = preCachingCheckJob_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail other) {
        if (other
            == com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
                .getDefaultInstance()) return this;
        if (!other.getMainJob().isEmpty()) {
          mainJob_ = other.mainJob_;
          onChanged();
        }
        if (!other.getPreCachingCheckJob().isEmpty()) {
          preCachingCheckJob_ = other.preCachingCheckJob_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object mainJob_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
       * </pre>
       *
       * <code>
       * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The mainJob.
       */
      public java.lang.String getMainJob() {
        java.lang.Object ref = mainJob_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          mainJob_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
       * </pre>
       *
       * <code>
       * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for mainJob.
       */
      public com.google.protobuf.ByteString getMainJobBytes() {
        java.lang.Object ref = mainJob_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          mainJob_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
       * </pre>
       *
       * <code>
       * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The mainJob to set.
       * @return This builder for chaining.
       */
      public Builder setMainJob(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        mainJob_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
       * </pre>
       *
       * <code>
       * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMainJob() {

        mainJob_ = getDefaultInstance().getMainJob();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the main container execution.
       * </pre>
       *
       * <code>
       * string main_job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for mainJob to set.
       * @return This builder for chaining.
       */
      public Builder setMainJobBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        mainJob_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object preCachingCheckJob_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
       * execution. This job will be available if the
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
       * the lifecycle events.
       * </pre>
       *
       * <code>
       * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The preCachingCheckJob.
       */
      public java.lang.String getPreCachingCheckJob() {
        java.lang.Object ref = preCachingCheckJob_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          preCachingCheckJob_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
       * execution. This job will be available if the
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
       * the lifecycle events.
       * </pre>
       *
       * <code>
       * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for preCachingCheckJob.
       */
      public com.google.protobuf.ByteString getPreCachingCheckJobBytes() {
        java.lang.Object ref = preCachingCheckJob_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          preCachingCheckJob_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
       * execution. This job will be available if the
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
       * the lifecycle events.
       * </pre>
       *
       * <code>
       * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The preCachingCheckJob to set.
       * @return This builder for chaining.
       */
      public Builder setPreCachingCheckJob(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        preCachingCheckJob_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
       * execution. This job will be available if the
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
       * the lifecycle events.
       * </pre>
       *
       * <code>
       * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPreCachingCheckJob() {

        preCachingCheckJob_ = getDefaultInstance().getPreCachingCheckJob();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob] for the pre-caching-check container
       * execution. This job will be available if the
       * [PipelineJob.pipeline_spec][google.cloud.aiplatform.v1.PipelineJob.pipeline_spec] specifies the `pre_caching_check` hook in
       * the lifecycle events.
       * </pre>
       *
       * <code>
       * string pre_caching_check_job = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for preCachingCheckJob to set.
       * @return This builder for chaining.
       */
      public Builder setPreCachingCheckJobBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        preCachingCheckJob_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
    private static final com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail();
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ContainerDetail> PARSER =
        new com.google.protobuf.AbstractParser<ContainerDetail>() {
          @java.lang.Override
          public ContainerDetail parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ContainerDetail(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ContainerDetail> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ContainerDetail> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  @java.lang.Deprecated
  public interface CustomJobDetailOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
     * </pre>
     *
     * <code>
     * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The job.
     */
    java.lang.String getJob();
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
     * </pre>
     *
     * <code>
     * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for job.
     */
    com.google.protobuf.ByteString getJobBytes();
  }
  /**
   *
   *
   * <pre>
   * The detailed info for a custom job executor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail}
   */
  @java.lang.Deprecated
  public static final class CustomJobDetail extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
      CustomJobDetailOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CustomJobDetail.newBuilder() to construct.
    private CustomJobDetail(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomJobDetail() {
      job_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomJobDetail();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private CustomJobDetail(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                job_ = s;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_CustomJobDetail_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_CustomJobDetail_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.class,
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.Builder
                  .class);
    }

    public static final int JOB_FIELD_NUMBER = 1;
    private volatile java.lang.Object job_;
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
     * </pre>
     *
     * <code>
     * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The job.
     */
    @java.lang.Override
    public java.lang.String getJob() {
      java.lang.Object ref = job_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        job_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
     * </pre>
     *
     * <code>
     * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for job.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobBytes() {
      java.lang.Object ref = job_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        job_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(job_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, job_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(job_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, job_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail other =
          (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail) obj;

      if (!getJob().equals(other.getJob())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + JOB_FIELD_NUMBER;
      hash = (53 * hash) + getJob().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The detailed info for a custom job executor.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetailOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_CustomJobDetail_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_CustomJobDetail_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.class,
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        job_ = "";

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.Pipeline
            .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_CustomJobDetail_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail build() {
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
          buildPartial() {
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail result =
            new com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail(this);
        result.job_ = job_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail other) {
        if (other
            == com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
                .getDefaultInstance()) return this;
        if (!other.getJob().isEmpty()) {
          job_ = other.job_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object job_ = "";
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
       * </pre>
       *
       * <code>
       * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The job.
       */
      public java.lang.String getJob() {
        java.lang.Object ref = job_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          job_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
       * </pre>
       *
       * <code>
       * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for job.
       */
      public com.google.protobuf.ByteString getJobBytes() {
        java.lang.Object ref = job_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          job_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
       * </pre>
       *
       * <code>
       * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The job to set.
       * @return This builder for chaining.
       */
      public Builder setJob(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        job_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
       * </pre>
       *
       * <code>
       * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJob() {

        job_ = getDefaultInstance().getJob();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Output only. The name of the [CustomJob][google.cloud.aiplatform.v1.CustomJob].
       * </pre>
       *
       * <code>
       * string job = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for job to set.
       * @return This builder for chaining.
       */
      public Builder setJobBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        job_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
    private static final com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail();
    }

    public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomJobDetail> PARSER =
        new com.google.protobuf.AbstractParser<CustomJobDetail>() {
          @java.lang.Override
          public CustomJobDetail parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new CustomJobDetail(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<CustomJobDetail> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomJobDetail> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int detailsCase_ = 0;
  private java.lang.Object details_;

  public enum DetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CONTAINER_DETAIL(1),
    @java.lang.Deprecated
    CUSTOM_JOB_DETAIL(2),
    DETAILS_NOT_SET(0);
    private final int value;

    private DetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailsCase forNumber(int value) {
      switch (value) {
        case 1:
          return CONTAINER_DETAIL;
        case 2:
          return CUSTOM_JOB_DETAIL;
        case 0:
          return DETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailsCase getDetailsCase() {
    return DetailsCase.forNumber(detailsCase_);
  }

  public static final int CONTAINER_DETAIL_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Output only. The detailed info for a container executor.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the containerDetail field is set.
   */
  @java.lang.Override
  public boolean hasContainerDetail() {
    return detailsCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed info for a container executor.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The containerDetail.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
      getContainerDetail() {
    if (detailsCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail) details_;
    }
    return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed info for a container executor.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetailOrBuilder
      getContainerDetailOrBuilder() {
    if (detailsCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail) details_;
    }
    return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        .getDefaultInstance();
  }

  public static final int CUSTOM_JOB_DETAIL_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Output only. The detailed info for a custom job executor.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.custom_job_detail is
   *     deprecated. See google/cloud/aiplatform/v1/pipeline_job.proto;l=343
   * @return Whether the customJobDetail field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasCustomJobDetail() {
    return detailsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed info for a custom job executor.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @deprecated google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.custom_job_detail is
   *     deprecated. See google/cloud/aiplatform/v1/pipeline_job.proto;l=343
   * @return The customJobDetail.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
      getCustomJobDetail() {
    if (detailsCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail) details_;
    }
    return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. The detailed info for a custom job executor.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetailOrBuilder
      getCustomJobDetailOrBuilder() {
    if (detailsCase_ == 2) {
      return (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail) details_;
    }
    return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (detailsCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail) details_);
    }
    if (detailsCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail) details_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (detailsCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail) details_);
    }
    if (detailsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail) details_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail other =
        (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail) obj;

    if (!getDetailsCase().equals(other.getDetailsCase())) return false;
    switch (detailsCase_) {
      case 1:
        if (!getContainerDetail().equals(other.getContainerDetail())) return false;
        break;
      case 2:
        if (!getCustomJobDetail().equals(other.getCustomJobDetail())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (detailsCase_) {
      case 1:
        hash = (37 * hash) + CONTAINER_DETAIL_FIELD_NUMBER;
        hash = (53 * hash) + getContainerDetail().hashCode();
        break;
      case 2:
        hash = (37 * hash) + CUSTOM_JOB_DETAIL_FIELD_NUMBER;
        hash = (53 * hash) + getCustomJobDetail().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The runtime detail of a pipeline executor.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.PipelineTaskExecutorDetail}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail)
      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetailOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.class,
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      detailsCase_ = 0;
      details_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.Pipeline
          .internal_static_google_cloud_aiplatform_v1_PipelineTaskExecutorDetail_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail build() {
      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail buildPartial() {
      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail result =
          new com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail(this);
      if (detailsCase_ == 1) {
        if (containerDetailBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = containerDetailBuilder_.build();
        }
      }
      if (detailsCase_ == 2) {
        if (customJobDetailBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = customJobDetailBuilder_.build();
        }
      }
      result.detailsCase_ = detailsCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail) {
        return mergeFrom((com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail other) {
      if (other == com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.getDefaultInstance())
        return this;
      switch (other.getDetailsCase()) {
        case CONTAINER_DETAIL:
          {
            mergeContainerDetail(other.getContainerDetail());
            break;
          }
        case CUSTOM_JOB_DETAIL:
          {
            mergeCustomJobDetail(other.getCustomJobDetail());
            break;
          }
        case DETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int detailsCase_ = 0;
    private java.lang.Object details_;

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public Builder clearDetails() {
      detailsCase_ = 0;
      details_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.Builder,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetailOrBuilder>
        containerDetailBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the containerDetail field is set.
     */
    @java.lang.Override
    public boolean hasContainerDetail() {
      return detailsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The containerDetail.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
        getContainerDetail() {
      if (containerDetailBuilder_ == null) {
        if (detailsCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
              details_;
        }
        return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 1) {
          return containerDetailBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setContainerDetail(
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail value) {
      if (containerDetailBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        containerDetailBuilder_.setMessage(value);
      }
      detailsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setContainerDetail(
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.Builder
            builderForValue) {
      if (containerDetailBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        containerDetailBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeContainerDetail(
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail value) {
      if (containerDetailBuilder_ == null) {
        if (detailsCase_ == 1
            && details_
                != com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.newBuilder(
                      (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 1) {
          containerDetailBuilder_.mergeFrom(value);
        } else {
          containerDetailBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearContainerDetail() {
      if (containerDetailBuilder_ == null) {
        if (detailsCase_ == 1) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 1) {
          detailsCase_ = 0;
          details_ = null;
        }
        containerDetailBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.Builder
        getContainerDetailBuilder() {
      return getContainerDetailFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetailOrBuilder
        getContainerDetailOrBuilder() {
      if ((detailsCase_ == 1) && (containerDetailBuilder_ != null)) {
        return containerDetailBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
              details_;
        }
        return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a container executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail container_detail = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.Builder,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetailOrBuilder>
        getContainerDetailFieldBuilder() {
      if (containerDetailBuilder_ == null) {
        if (!(detailsCase_ == 1)) {
          details_ =
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail
                  .getDefaultInstance();
        }
        containerDetailBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail,
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail.Builder,
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetailOrBuilder>(
                (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.ContainerDetail)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 1;
      onChanged();
      ;
      return containerDetailBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.Builder,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetailOrBuilder>
        customJobDetailBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.custom_job_detail is
     *     deprecated. See google/cloud/aiplatform/v1/pipeline_job.proto;l=343
     * @return Whether the customJobDetail field is set.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean hasCustomJobDetail() {
      return detailsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @deprecated google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.custom_job_detail is
     *     deprecated. See google/cloud/aiplatform/v1/pipeline_job.proto;l=343
     * @return The customJobDetail.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
        getCustomJobDetail() {
      if (customJobDetailBuilder_ == null) {
        if (detailsCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
              details_;
        }
        return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 2) {
          return customJobDetailBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setCustomJobDetail(
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail value) {
      if (customJobDetailBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        customJobDetailBuilder_.setMessage(value);
      }
      detailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setCustomJobDetail(
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.Builder
            builderForValue) {
      if (customJobDetailBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        customJobDetailBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeCustomJobDetail(
        com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail value) {
      if (customJobDetailBuilder_ == null) {
        if (detailsCase_ == 2
            && details_
                != com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.newBuilder(
                      (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 2) {
          customJobDetailBuilder_.mergeFrom(value);
        } else {
          customJobDetailBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearCustomJobDetail() {
      if (customJobDetailBuilder_ == null) {
        if (detailsCase_ == 2) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 2) {
          detailsCase_ = 0;
          details_ = null;
        }
        customJobDetailBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.Builder
        getCustomJobDetailBuilder() {
      return getCustomJobDetailFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetailOrBuilder
        getCustomJobDetailOrBuilder() {
      if ((detailsCase_ == 2) && (customJobDetailBuilder_ != null)) {
        return customJobDetailBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
              details_;
        }
        return com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The detailed info for a custom job executor.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail custom_job_detail = 2 [deprecated = true, (.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.Builder,
            com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetailOrBuilder>
        getCustomJobDetailFieldBuilder() {
      if (customJobDetailBuilder_ == null) {
        if (!(detailsCase_ == 2)) {
          details_ =
              com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail
                  .getDefaultInstance();
        }
        customJobDetailBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail,
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail.Builder,
                com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetailOrBuilder>(
                (com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail.CustomJobDetail)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 2;
      onChanged();
      ;
      return customJobDetailBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.PipelineTaskExecutorDetail)
  private static final com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail();
  }

  public static com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PipelineTaskExecutorDetail> PARSER =
      new com.google.protobuf.AbstractParser<PipelineTaskExecutorDetail>() {
        @java.lang.Override
        public PipelineTaskExecutorDetail parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PipelineTaskExecutorDetail(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PipelineTaskExecutorDetail> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PipelineTaskExecutorDetail> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.PipelineTaskExecutorDetail getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
