/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CUSTOM_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/customJobs/{custom_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String customJob;

    @Deprecated
    protected CustomJobName() {
        this.project = null;
        this.location = null;
        this.customJob = null;
    }

    private CustomJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.customJob = (String)Preconditions.checkNotNull((Object)builder.getCustomJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCustomJob() {
        return this.customJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomJobName of(String project, String location, String customJob) {
        return CustomJobName.newBuilder().setProject(project).setLocation(location).setCustomJob(customJob).build();
    }

    public static String format(String project, String location, String customJob) {
        return CustomJobName.newBuilder().setProject(project).setLocation(location).setCustomJob(customJob).build().toString();
    }

    public static CustomJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CUSTOM_JOB.validatedMatch(formattedString, "CustomJobName.parse: formattedString not in valid format");
        return CustomJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("custom_job"));
    }

    public static List<CustomJobName> parseList(List<String> formattedStrings) {
        ArrayList<CustomJobName> list = new ArrayList<CustomJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CUSTOM_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomJobName customJobName = this;
            synchronized (customJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.customJob != null) {
                        fieldMapBuilder.put((Object)"custom_job", (Object)this.customJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CUSTOM_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "custom_job", this.customJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomJobName that = (CustomJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.customJob, that.customJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String customJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCustomJob() {
            return this.customJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCustomJob(String customJob) {
            this.customJob = customJob;
            return this;
        }

        private Builder(CustomJobName customJobName) {
            this.project = customJobName.project;
            this.location = customJobName.location;
            this.customJob = customJobName.customJob;
        }

        public CustomJobName build() {
            return new CustomJobName(this);
        }
    }
}

