/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TensorboardTimeSeriesName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TENSORBOARD_EXPERIMENT_RUN_TIME_SERIES = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tensorboard;
    private final String experiment;
    private final String run;
    private final String timeSeries;

    @Deprecated
    protected TensorboardTimeSeriesName() {
        this.project = null;
        this.location = null;
        this.tensorboard = null;
        this.experiment = null;
        this.run = null;
        this.timeSeries = null;
    }

    private TensorboardTimeSeriesName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tensorboard = (String)Preconditions.checkNotNull((Object)builder.getTensorboard());
        this.experiment = (String)Preconditions.checkNotNull((Object)builder.getExperiment());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
        this.timeSeries = (String)Preconditions.checkNotNull((Object)builder.getTimeSeries());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTensorboard() {
        return this.tensorboard;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public String getRun() {
        return this.run;
    }

    public String getTimeSeries() {
        return this.timeSeries;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TensorboardTimeSeriesName of(String project, String location, String tensorboard, String experiment, String run, String timeSeries) {
        return TensorboardTimeSeriesName.newBuilder().setProject(project).setLocation(location).setTensorboard(tensorboard).setExperiment(experiment).setRun(run).setTimeSeries(timeSeries).build();
    }

    public static String format(String project, String location, String tensorboard, String experiment, String run, String timeSeries) {
        return TensorboardTimeSeriesName.newBuilder().setProject(project).setLocation(location).setTensorboard(tensorboard).setExperiment(experiment).setRun(run).setTimeSeries(timeSeries).build().toString();
    }

    public static TensorboardTimeSeriesName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TENSORBOARD_EXPERIMENT_RUN_TIME_SERIES.validatedMatch(formattedString, "TensorboardTimeSeriesName.parse: formattedString not in valid format");
        return TensorboardTimeSeriesName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tensorboard"), (String)matchMap.get("experiment"), (String)matchMap.get("run"), (String)matchMap.get("time_series"));
    }

    public static List<TensorboardTimeSeriesName> parseList(List<String> formattedStrings) {
        ArrayList<TensorboardTimeSeriesName> list = new ArrayList<TensorboardTimeSeriesName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TensorboardTimeSeriesName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TensorboardTimeSeriesName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TensorboardTimeSeriesName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TENSORBOARD_EXPERIMENT_RUN_TIME_SERIES.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TensorboardTimeSeriesName tensorboardTimeSeriesName = this;
            synchronized (tensorboardTimeSeriesName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tensorboard != null) {
                        fieldMapBuilder.put((Object)"tensorboard", (Object)this.tensorboard);
                    }
                    if (this.experiment != null) {
                        fieldMapBuilder.put((Object)"experiment", (Object)this.experiment);
                    }
                    if (this.run != null) {
                        fieldMapBuilder.put((Object)"run", (Object)this.run);
                    }
                    if (this.timeSeries != null) {
                        fieldMapBuilder.put((Object)"time_series", (Object)this.timeSeries);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TENSORBOARD_EXPERIMENT_RUN_TIME_SERIES.instantiate(new String[]{"project", this.project, "location", this.location, "tensorboard", this.tensorboard, "experiment", this.experiment, "run", this.run, "time_series", this.timeSeries});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TensorboardTimeSeriesName that = (TensorboardTimeSeriesName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tensorboard, that.tensorboard) && Objects.equals(this.experiment, that.experiment) && Objects.equals(this.run, that.run) && Objects.equals(this.timeSeries, that.timeSeries);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.tensorboard);
        h *= 1000003;
        h ^= Objects.hashCode(this.experiment);
        h *= 1000003;
        h ^= Objects.hashCode(this.run);
        h *= 1000003;
        return h ^= Objects.hashCode(this.timeSeries);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tensorboard;
        private String experiment;
        private String run;
        private String timeSeries;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTensorboard() {
            return this.tensorboard;
        }

        public String getExperiment() {
            return this.experiment;
        }

        public String getRun() {
            return this.run;
        }

        public String getTimeSeries() {
            return this.timeSeries;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTensorboard(String tensorboard) {
            this.tensorboard = tensorboard;
            return this;
        }

        public Builder setExperiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        public Builder setRun(String run) {
            this.run = run;
            return this;
        }

        public Builder setTimeSeries(String timeSeries) {
            this.timeSeries = timeSeries;
            return this;
        }

        private Builder(TensorboardTimeSeriesName tensorboardTimeSeriesName) {
            this.project = tensorboardTimeSeriesName.project;
            this.location = tensorboardTimeSeriesName.location;
            this.tensorboard = tensorboardTimeSeriesName.tensorboard;
            this.experiment = tensorboardTimeSeriesName.experiment;
            this.run = tensorboardTimeSeriesName.run;
            this.timeSeries = tensorboardTimeSeriesName.timeSeries;
        }

        public TensorboardTimeSeriesName build() {
            return new TensorboardTimeSeriesName(this);
        }
    }
}

