/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.advisorynotifications.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettingsName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/settings");
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/settings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String organization;
    private final String location;
    private final String project;

    @Deprecated
    protected SettingsName() {
        this.organization = null;
        this.location = null;
        this.project = null;
    }

    private SettingsName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.project = null;
        this.pathTemplate = ORGANIZATION_LOCATION;
    }

    private SettingsName(ProjectLocationBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newOrganizationLocationBuilder() {
        return new Builder();
    }

    public static ProjectLocationBuilder newProjectLocationBuilder() {
        return new ProjectLocationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SettingsName of(String organization, String location) {
        return SettingsName.newBuilder().setOrganization(organization).setLocation(location).build();
    }

    public static SettingsName ofOrganizationLocationName(String organization, String location) {
        return SettingsName.newBuilder().setOrganization(organization).setLocation(location).build();
    }

    public static SettingsName ofProjectLocationName(String project, String location) {
        return SettingsName.newProjectLocationBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String organization, String location) {
        return SettingsName.newBuilder().setOrganization(organization).setLocation(location).build().toString();
    }

    public static String formatOrganizationLocationName(String organization, String location) {
        return SettingsName.newBuilder().setOrganization(organization).setLocation(location).build().toString();
    }

    public static String formatProjectLocationName(String project, String location) {
        return SettingsName.newProjectLocationBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static SettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (ORGANIZATION_LOCATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION.match(formattedString);
            return SettingsName.ofOrganizationLocationName((String)matchMap.get("organization"), (String)matchMap.get("location"));
        }
        if (PROJECT_LOCATION.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION.match(formattedString);
            return SettingsName.ofProjectLocationName((String)matchMap.get("project"), (String)matchMap.get("location"));
        }
        throw new ValidationException("SettingsName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<SettingsName> parseList(List<String> formattedStrings) {
        ArrayList<SettingsName> list = new ArrayList<SettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION.matches(formattedString) || PROJECT_LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SettingsName settingsName = this;
            synchronized (settingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SettingsName that = (SettingsName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class ProjectLocationBuilder {
        private String project;
        private String location;

        protected ProjectLocationBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public ProjectLocationBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }

    public static class Builder {
        private String organization;
        private String location;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(SettingsName settingsName) {
            Preconditions.checkArgument((boolean)Objects.equals(settingsName.pathTemplate, ORGANIZATION_LOCATION), (Object)"toBuilder is only supported when SettingsName has the pattern of organizations/{organization}/locations/{location}/settings");
            this.organization = settingsName.organization;
            this.location = settingsName.location;
        }

        public SettingsName build() {
            return new SettingsName(this);
        }
    }
}

