/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.accessapproval.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccessApprovalSettingsName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/accessApprovalSettings");
    private static final PathTemplate FOLDER = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/accessApprovalSettings");
    private static final PathTemplate ORGANIZATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/accessApprovalSettings");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String folder;
    private final String organization;

    @Deprecated
    protected AccessApprovalSettingsName() {
        this.project = null;
        this.folder = null;
        this.organization = null;
    }

    private AccessApprovalSettingsName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT;
    }

    private AccessApprovalSettingsName(FolderBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER;
    }

    private AccessApprovalSettingsName(OrganizationBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectBuilder() {
        return new Builder();
    }

    public static FolderBuilder newFolderBuilder() {
        return new FolderBuilder();
    }

    public static OrganizationBuilder newOrganizationBuilder() {
        return new OrganizationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccessApprovalSettingsName of(String project) {
        return AccessApprovalSettingsName.newBuilder().setProject(project).build();
    }

    public static AccessApprovalSettingsName ofProjectName(String project) {
        return AccessApprovalSettingsName.newBuilder().setProject(project).build();
    }

    public static AccessApprovalSettingsName ofFolderName(String folder) {
        return AccessApprovalSettingsName.newFolderBuilder().setFolder(folder).build();
    }

    public static AccessApprovalSettingsName ofOrganizationName(String organization) {
        return AccessApprovalSettingsName.newOrganizationBuilder().setOrganization(organization).build();
    }

    public static String format(String project) {
        return AccessApprovalSettingsName.newBuilder().setProject(project).build().toString();
    }

    public static String formatProjectName(String project) {
        return AccessApprovalSettingsName.newBuilder().setProject(project).build().toString();
    }

    public static String formatFolderName(String folder) {
        return AccessApprovalSettingsName.newFolderBuilder().setFolder(folder).build().toString();
    }

    public static String formatOrganizationName(String organization) {
        return AccessApprovalSettingsName.newOrganizationBuilder().setOrganization(organization).build().toString();
    }

    public static AccessApprovalSettingsName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT.matches(formattedString)) {
            Map matchMap = PROJECT.match(formattedString);
            return AccessApprovalSettingsName.ofProjectName((String)matchMap.get("project"));
        }
        if (FOLDER.matches(formattedString)) {
            Map matchMap = FOLDER.match(formattedString);
            return AccessApprovalSettingsName.ofFolderName((String)matchMap.get("folder"));
        }
        if (ORGANIZATION.matches(formattedString)) {
            Map matchMap = ORGANIZATION.match(formattedString);
            return AccessApprovalSettingsName.ofOrganizationName((String)matchMap.get("organization"));
        }
        throw new ValidationException("AccessApprovalSettingsName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AccessApprovalSettingsName> parseList(List<String> formattedStrings) {
        ArrayList<AccessApprovalSettingsName> list = new ArrayList<AccessApprovalSettingsName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccessApprovalSettingsName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccessApprovalSettingsName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccessApprovalSettingsName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString) || FOLDER.matches(formattedString) || ORGANIZATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccessApprovalSettingsName accessApprovalSettingsName = this;
            synchronized (accessApprovalSettingsName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AccessApprovalSettingsName that = (AccessApprovalSettingsName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationBuilder {
        private String organization;

        protected OrganizationBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public OrganizationBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public AccessApprovalSettingsName build() {
            return new AccessApprovalSettingsName(this);
        }
    }

    public static class FolderBuilder {
        private String folder;

        protected FolderBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public FolderBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public AccessApprovalSettingsName build() {
            return new AccessApprovalSettingsName(this);
        }
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(AccessApprovalSettingsName accessApprovalSettingsName) {
            Preconditions.checkArgument((boolean)Objects.equals(accessApprovalSettingsName.pathTemplate, PROJECT), (Object)"toBuilder is only supported when AccessApprovalSettingsName has the pattern of projects/{project}/accessApprovalSettings");
            this.project = accessApprovalSettingsName.project;
        }

        public AccessApprovalSettingsName build() {
            return new AccessApprovalSettingsName(this);
        }
    }
}

