/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1beta/analytics_data_api.proto

// Protobuf Java Version: 3.25.8
package com.google.analytics.data.v1beta;

/**
 *
 *
 * <pre>
 * The batch request containing multiple pivot report requests.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1beta.BatchRunPivotReportsRequest}
 */
public final class BatchRunPivotReportsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1beta.BatchRunPivotReportsRequest)
    BatchRunPivotReportsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use BatchRunPivotReportsRequest.newBuilder() to construct.
  private BatchRunPivotReportsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchRunPivotReportsRequest() {
    property_ = "";
    requests_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchRunPivotReportsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_BatchRunPivotReportsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1beta.AnalyticsDataApiProto
        .internal_static_google_analytics_data_v1beta_BatchRunPivotReportsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1beta.BatchRunPivotReportsRequest.class,
            com.google.analytics.data.v1beta.BatchRunPivotReportsRequest.Builder.class);
  }

  public static final int PROPERTY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object property_ = "";

  /**
   *
   *
   * <pre>
   * A Google Analytics property identifier whose events are tracked.
   * Specified in the URL path and not the body. To learn more, see [where to
   * find your Property
   * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
   * This property must be specified for the batch. The property within
   * RunPivotReportRequest may either be unspecified or consistent with this
   * property.
   *
   * Example: properties/1234
   * </pre>
   *
   * <code>string property = 1;</code>
   *
   * @return The property.
   */
  @java.lang.Override
  public java.lang.String getProperty() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      property_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A Google Analytics property identifier whose events are tracked.
   * Specified in the URL path and not the body. To learn more, see [where to
   * find your Property
   * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
   * This property must be specified for the batch. The property within
   * RunPivotReportRequest may either be unspecified or consistent with this
   * property.
   *
   * Example: properties/1234
   * </pre>
   *
   * <code>string property = 1;</code>
   *
   * @return The bytes for property.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPropertyBytes() {
    java.lang.Object ref = property_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      property_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUESTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.analytics.data.v1beta.RunPivotReportRequest> requests_;

  /**
   *
   *
   * <pre>
   * Individual requests. Each request has a separate pivot report response.
   * Each batch request is allowed up to 5 requests.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.analytics.data.v1beta.RunPivotReportRequest> getRequestsList() {
    return requests_;
  }

  /**
   *
   *
   * <pre>
   * Individual requests. Each request has a separate pivot report response.
   * Each batch request is allowed up to 5 requests.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.analytics.data.v1beta.RunPivotReportRequestOrBuilder>
      getRequestsOrBuilderList() {
    return requests_;
  }

  /**
   *
   *
   * <pre>
   * Individual requests. Each request has a separate pivot report response.
   * Each batch request is allowed up to 5 requests.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
   */
  @java.lang.Override
  public int getRequestsCount() {
    return requests_.size();
  }

  /**
   *
   *
   * <pre>
   * Individual requests. Each request has a separate pivot report response.
   * Each batch request is allowed up to 5 requests.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.RunPivotReportRequest getRequests(int index) {
    return requests_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Individual requests. Each request has a separate pivot report response.
   * Each batch request is allowed up to 5 requests.
   * </pre>
   *
   * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1beta.RunPivotReportRequestOrBuilder getRequestsOrBuilder(
      int index) {
    return requests_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, property_);
    }
    for (int i = 0; i < requests_.size(); i++) {
      output.writeMessage(2, requests_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(property_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, property_);
    }
    for (int i = 0; i < requests_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, requests_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1beta.BatchRunPivotReportsRequest)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1beta.BatchRunPivotReportsRequest other =
        (com.google.analytics.data.v1beta.BatchRunPivotReportsRequest) obj;

    if (!getProperty().equals(other.getProperty())) return false;
    if (!getRequestsList().equals(other.getRequestsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
    hash = (53 * hash) + getProperty().hashCode();
    if (getRequestsCount() > 0) {
      hash = (37 * hash) + REQUESTS_FIELD_NUMBER;
      hash = (53 * hash) + getRequestsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.analytics.data.v1beta.BatchRunPivotReportsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The batch request containing multiple pivot report requests.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1beta.BatchRunPivotReportsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1beta.BatchRunPivotReportsRequest)
      com.google.analytics.data.v1beta.BatchRunPivotReportsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_BatchRunPivotReportsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_BatchRunPivotReportsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1beta.BatchRunPivotReportsRequest.class,
              com.google.analytics.data.v1beta.BatchRunPivotReportsRequest.Builder.class);
    }

    // Construct using com.google.analytics.data.v1beta.BatchRunPivotReportsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      property_ = "";
      if (requestsBuilder_ == null) {
        requests_ = java.util.Collections.emptyList();
      } else {
        requests_ = null;
        requestsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1beta.AnalyticsDataApiProto
          .internal_static_google_analytics_data_v1beta_BatchRunPivotReportsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.BatchRunPivotReportsRequest
        getDefaultInstanceForType() {
      return com.google.analytics.data.v1beta.BatchRunPivotReportsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.BatchRunPivotReportsRequest build() {
      com.google.analytics.data.v1beta.BatchRunPivotReportsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1beta.BatchRunPivotReportsRequest buildPartial() {
      com.google.analytics.data.v1beta.BatchRunPivotReportsRequest result =
          new com.google.analytics.data.v1beta.BatchRunPivotReportsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.analytics.data.v1beta.BatchRunPivotReportsRequest result) {
      if (requestsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          requests_ = java.util.Collections.unmodifiableList(requests_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.requests_ = requests_;
      } else {
        result.requests_ = requestsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.analytics.data.v1beta.BatchRunPivotReportsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.property_ = property_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1beta.BatchRunPivotReportsRequest) {
        return mergeFrom((com.google.analytics.data.v1beta.BatchRunPivotReportsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1beta.BatchRunPivotReportsRequest other) {
      if (other
          == com.google.analytics.data.v1beta.BatchRunPivotReportsRequest.getDefaultInstance())
        return this;
      if (!other.getProperty().isEmpty()) {
        property_ = other.property_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (requestsBuilder_ == null) {
        if (!other.requests_.isEmpty()) {
          if (requests_.isEmpty()) {
            requests_ = other.requests_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureRequestsIsMutable();
            requests_.addAll(other.requests_);
          }
          onChanged();
        }
      } else {
        if (!other.requests_.isEmpty()) {
          if (requestsBuilder_.isEmpty()) {
            requestsBuilder_.dispose();
            requestsBuilder_ = null;
            requests_ = other.requests_;
            bitField0_ = (bitField0_ & ~0x00000002);
            requestsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRequestsFieldBuilder()
                    : null;
          } else {
            requestsBuilder_.addAllMessages(other.requests_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                property_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.analytics.data.v1beta.RunPivotReportRequest m =
                    input.readMessage(
                        com.google.analytics.data.v1beta.RunPivotReportRequest.parser(),
                        extensionRegistry);
                if (requestsBuilder_ == null) {
                  ensureRequestsIsMutable();
                  requests_.add(m);
                } else {
                  requestsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object property_ = "";

    /**
     *
     *
     * <pre>
     * A Google Analytics property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * This property must be specified for the batch. The property within
     * RunPivotReportRequest may either be unspecified or consistent with this
     * property.
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return The property.
     */
    public java.lang.String getProperty() {
      java.lang.Object ref = property_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        property_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A Google Analytics property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * This property must be specified for the batch. The property within
     * RunPivotReportRequest may either be unspecified or consistent with this
     * property.
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return The bytes for property.
     */
    public com.google.protobuf.ByteString getPropertyBytes() {
      java.lang.Object ref = property_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        property_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A Google Analytics property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * This property must be specified for the batch. The property within
     * RunPivotReportRequest may either be unspecified or consistent with this
     * property.
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @param value The property to set.
     * @return This builder for chaining.
     */
    public Builder setProperty(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      property_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Google Analytics property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * This property must be specified for the batch. The property within
     * RunPivotReportRequest may either be unspecified or consistent with this
     * property.
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProperty() {
      property_ = getDefaultInstance().getProperty();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A Google Analytics property identifier whose events are tracked.
     * Specified in the URL path and not the body. To learn more, see [where to
     * find your Property
     * ID](https://developers.google.com/analytics/devguides/reporting/data/v1/property-id).
     * This property must be specified for the batch. The property within
     * RunPivotReportRequest may either be unspecified or consistent with this
     * property.
     *
     * Example: properties/1234
     * </pre>
     *
     * <code>string property = 1;</code>
     *
     * @param value The bytes for property to set.
     * @return This builder for chaining.
     */
    public Builder setPropertyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      property_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.analytics.data.v1beta.RunPivotReportRequest> requests_ =
        java.util.Collections.emptyList();

    private void ensureRequestsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        requests_ =
            new java.util.ArrayList<com.google.analytics.data.v1beta.RunPivotReportRequest>(
                requests_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.RunPivotReportRequest,
            com.google.analytics.data.v1beta.RunPivotReportRequest.Builder,
            com.google.analytics.data.v1beta.RunPivotReportRequestOrBuilder>
        requestsBuilder_;

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.RunPivotReportRequest>
        getRequestsList() {
      if (requestsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(requests_);
      } else {
        return requestsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public int getRequestsCount() {
      if (requestsBuilder_ == null) {
        return requests_.size();
      } else {
        return requestsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public com.google.analytics.data.v1beta.RunPivotReportRequest getRequests(int index) {
      if (requestsBuilder_ == null) {
        return requests_.get(index);
      } else {
        return requestsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder setRequests(
        int index, com.google.analytics.data.v1beta.RunPivotReportRequest value) {
      if (requestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestsIsMutable();
        requests_.set(index, value);
        onChanged();
      } else {
        requestsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder setRequests(
        int index, com.google.analytics.data.v1beta.RunPivotReportRequest.Builder builderForValue) {
      if (requestsBuilder_ == null) {
        ensureRequestsIsMutable();
        requests_.set(index, builderForValue.build());
        onChanged();
      } else {
        requestsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder addRequests(com.google.analytics.data.v1beta.RunPivotReportRequest value) {
      if (requestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestsIsMutable();
        requests_.add(value);
        onChanged();
      } else {
        requestsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder addRequests(
        int index, com.google.analytics.data.v1beta.RunPivotReportRequest value) {
      if (requestsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRequestsIsMutable();
        requests_.add(index, value);
        onChanged();
      } else {
        requestsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder addRequests(
        com.google.analytics.data.v1beta.RunPivotReportRequest.Builder builderForValue) {
      if (requestsBuilder_ == null) {
        ensureRequestsIsMutable();
        requests_.add(builderForValue.build());
        onChanged();
      } else {
        requestsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder addRequests(
        int index, com.google.analytics.data.v1beta.RunPivotReportRequest.Builder builderForValue) {
      if (requestsBuilder_ == null) {
        ensureRequestsIsMutable();
        requests_.add(index, builderForValue.build());
        onChanged();
      } else {
        requestsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder addAllRequests(
        java.lang.Iterable<? extends com.google.analytics.data.v1beta.RunPivotReportRequest>
            values) {
      if (requestsBuilder_ == null) {
        ensureRequestsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, requests_);
        onChanged();
      } else {
        requestsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder clearRequests() {
      if (requestsBuilder_ == null) {
        requests_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        requestsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public Builder removeRequests(int index) {
      if (requestsBuilder_ == null) {
        ensureRequestsIsMutable();
        requests_.remove(index);
        onChanged();
      } else {
        requestsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public com.google.analytics.data.v1beta.RunPivotReportRequest.Builder getRequestsBuilder(
        int index) {
      return getRequestsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public com.google.analytics.data.v1beta.RunPivotReportRequestOrBuilder getRequestsOrBuilder(
        int index) {
      if (requestsBuilder_ == null) {
        return requests_.get(index);
      } else {
        return requestsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public java.util.List<? extends com.google.analytics.data.v1beta.RunPivotReportRequestOrBuilder>
        getRequestsOrBuilderList() {
      if (requestsBuilder_ != null) {
        return requestsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(requests_);
      }
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public com.google.analytics.data.v1beta.RunPivotReportRequest.Builder addRequestsBuilder() {
      return getRequestsFieldBuilder()
          .addBuilder(com.google.analytics.data.v1beta.RunPivotReportRequest.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public com.google.analytics.data.v1beta.RunPivotReportRequest.Builder addRequestsBuilder(
        int index) {
      return getRequestsFieldBuilder()
          .addBuilder(
              index, com.google.analytics.data.v1beta.RunPivotReportRequest.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Individual requests. Each request has a separate pivot report response.
     * Each batch request is allowed up to 5 requests.
     * </pre>
     *
     * <code>repeated .google.analytics.data.v1beta.RunPivotReportRequest requests = 2;</code>
     */
    public java.util.List<com.google.analytics.data.v1beta.RunPivotReportRequest.Builder>
        getRequestsBuilderList() {
      return getRequestsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.analytics.data.v1beta.RunPivotReportRequest,
            com.google.analytics.data.v1beta.RunPivotReportRequest.Builder,
            com.google.analytics.data.v1beta.RunPivotReportRequestOrBuilder>
        getRequestsFieldBuilder() {
      if (requestsBuilder_ == null) {
        requestsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.analytics.data.v1beta.RunPivotReportRequest,
                com.google.analytics.data.v1beta.RunPivotReportRequest.Builder,
                com.google.analytics.data.v1beta.RunPivotReportRequestOrBuilder>(
                requests_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        requests_ = null;
      }
      return requestsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1beta.BatchRunPivotReportsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1beta.BatchRunPivotReportsRequest)
  private static final com.google.analytics.data.v1beta.BatchRunPivotReportsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1beta.BatchRunPivotReportsRequest();
  }

  public static com.google.analytics.data.v1beta.BatchRunPivotReportsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchRunPivotReportsRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchRunPivotReportsRequest>() {
        @java.lang.Override
        public BatchRunPivotReportsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchRunPivotReportsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchRunPivotReportsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1beta.BatchRunPivotReportsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
