/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/analytics/data/v1alpha/data.proto

// Protobuf Java Version: 3.25.8
package com.google.analytics.data.v1alpha;

/**
 *
 *
 * <pre>
 * Steps define the user journey you want to measure. Steps contain one or
 * more conditions that your users must meet to be included in that step of
 * the funnel journey.
 * </pre>
 *
 * Protobuf type {@code google.analytics.data.v1alpha.FunnelStep}
 */
public final class FunnelStep extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.analytics.data.v1alpha.FunnelStep)
    FunnelStepOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FunnelStep.newBuilder() to construct.
  private FunnelStep(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FunnelStep() {
    name_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FunnelStep();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_FunnelStep_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.analytics.data.v1alpha.ReportingApiProto
        .internal_static_google_analytics_data_v1alpha_FunnelStep_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.analytics.data.v1alpha.FunnelStep.class,
            com.google.analytics.data.v1alpha.FunnelStep.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The distinctive name for this step. If unspecified, steps will be named
   * by a 1 based indexed name (for example "0. ", "1. ", etc.). This name
   * defines string value returned by the `funnelStepName` dimension. For
   * example, specifying `name = Purchase` in the request's third funnel step
   * will produce `3. Purchase` in the funnel report response.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The distinctive name for this step. If unspecified, steps will be named
   * by a 1 based indexed name (for example "0. ", "1. ", etc.). This name
   * defines string value returned by the `funnelStepName` dimension. For
   * example, specifying `name = Purchase` in the request's third funnel step
   * will produce `3. Purchase` in the funnel report response.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_DIRECTLY_FOLLOWED_BY_FIELD_NUMBER = 2;
  private boolean isDirectlyFollowedBy_ = false;

  /**
   *
   *
   * <pre>
   * If true, this step must directly follow the previous step. If false,
   * there can be events between the previous step and this step. If
   * unspecified, `isDirectlyFollowedBy` is treated as false.
   * </pre>
   *
   * <code>bool is_directly_followed_by = 2;</code>
   *
   * @return The isDirectlyFollowedBy.
   */
  @java.lang.Override
  public boolean getIsDirectlyFollowedBy() {
    return isDirectlyFollowedBy_;
  }

  public static final int WITHIN_DURATION_FROM_PRIOR_STEP_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration withinDurationFromPriorStep_;

  /**
   *
   *
   * <pre>
   * If specified, this step must complete within this duration of the
   * completion of the prior step. `withinDurationFromPriorStep` is inclusive
   * of the endpoint at the microsecond granularity. For example a duration of
   * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
   * microsecond.
   *
   * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
   * be separated by any time duration.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
   *
   * @return Whether the withinDurationFromPriorStep field is set.
   */
  @java.lang.Override
  public boolean hasWithinDurationFromPriorStep() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * If specified, this step must complete within this duration of the
   * completion of the prior step. `withinDurationFromPriorStep` is inclusive
   * of the endpoint at the microsecond granularity. For example a duration of
   * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
   * microsecond.
   *
   * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
   * be separated by any time duration.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
   *
   * @return The withinDurationFromPriorStep.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getWithinDurationFromPriorStep() {
    return withinDurationFromPriorStep_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : withinDurationFromPriorStep_;
  }

  /**
   *
   *
   * <pre>
   * If specified, this step must complete within this duration of the
   * completion of the prior step. `withinDurationFromPriorStep` is inclusive
   * of the endpoint at the microsecond granularity. For example a duration of
   * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
   * microsecond.
   *
   * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
   * be separated by any time duration.
   * </pre>
   *
   * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getWithinDurationFromPriorStepOrBuilder() {
    return withinDurationFromPriorStep_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : withinDurationFromPriorStep_;
  }

  public static final int FILTER_EXPRESSION_FIELD_NUMBER = 4;
  private com.google.analytics.data.v1alpha.FunnelFilterExpression filterExpression_;

  /**
   *
   *
   * <pre>
   * The condition that your users must meet to be included in this step of
   * the funnel journey.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
   *
   * @return Whether the filterExpression field is set.
   */
  @java.lang.Override
  public boolean hasFilterExpression() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The condition that your users must meet to be included in this step of
   * the funnel journey.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
   *
   * @return The filterExpression.
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelFilterExpression getFilterExpression() {
    return filterExpression_ == null
        ? com.google.analytics.data.v1alpha.FunnelFilterExpression.getDefaultInstance()
        : filterExpression_;
  }

  /**
   *
   *
   * <pre>
   * The condition that your users must meet to be included in this step of
   * the funnel journey.
   * </pre>
   *
   * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
   */
  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelFilterExpressionOrBuilder
      getFilterExpressionOrBuilder() {
    return filterExpression_ == null
        ? com.google.analytics.data.v1alpha.FunnelFilterExpression.getDefaultInstance()
        : filterExpression_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (isDirectlyFollowedBy_ != false) {
      output.writeBool(2, isDirectlyFollowedBy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getWithinDurationFromPriorStep());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getFilterExpression());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (isDirectlyFollowedBy_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, isDirectlyFollowedBy_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, getWithinDurationFromPriorStep());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getFilterExpression());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.analytics.data.v1alpha.FunnelStep)) {
      return super.equals(obj);
    }
    com.google.analytics.data.v1alpha.FunnelStep other =
        (com.google.analytics.data.v1alpha.FunnelStep) obj;

    if (!getName().equals(other.getName())) return false;
    if (getIsDirectlyFollowedBy() != other.getIsDirectlyFollowedBy()) return false;
    if (hasWithinDurationFromPriorStep() != other.hasWithinDurationFromPriorStep()) return false;
    if (hasWithinDurationFromPriorStep()) {
      if (!getWithinDurationFromPriorStep().equals(other.getWithinDurationFromPriorStep()))
        return false;
    }
    if (hasFilterExpression() != other.hasFilterExpression()) return false;
    if (hasFilterExpression()) {
      if (!getFilterExpression().equals(other.getFilterExpression())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + IS_DIRECTLY_FOLLOWED_BY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsDirectlyFollowedBy());
    if (hasWithinDurationFromPriorStep()) {
      hash = (37 * hash) + WITHIN_DURATION_FROM_PRIOR_STEP_FIELD_NUMBER;
      hash = (53 * hash) + getWithinDurationFromPriorStep().hashCode();
    }
    if (hasFilterExpression()) {
      hash = (37 * hash) + FILTER_EXPRESSION_FIELD_NUMBER;
      hash = (53 * hash) + getFilterExpression().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.analytics.data.v1alpha.FunnelStep parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.analytics.data.v1alpha.FunnelStep prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Steps define the user journey you want to measure. Steps contain one or
   * more conditions that your users must meet to be included in that step of
   * the funnel journey.
   * </pre>
   *
   * Protobuf type {@code google.analytics.data.v1alpha.FunnelStep}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.analytics.data.v1alpha.FunnelStep)
      com.google.analytics.data.v1alpha.FunnelStepOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_FunnelStep_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_FunnelStep_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.analytics.data.v1alpha.FunnelStep.class,
              com.google.analytics.data.v1alpha.FunnelStep.Builder.class);
    }

    // Construct using com.google.analytics.data.v1alpha.FunnelStep.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getWithinDurationFromPriorStepFieldBuilder();
        getFilterExpressionFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      isDirectlyFollowedBy_ = false;
      withinDurationFromPriorStep_ = null;
      if (withinDurationFromPriorStepBuilder_ != null) {
        withinDurationFromPriorStepBuilder_.dispose();
        withinDurationFromPriorStepBuilder_ = null;
      }
      filterExpression_ = null;
      if (filterExpressionBuilder_ != null) {
        filterExpressionBuilder_.dispose();
        filterExpressionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.analytics.data.v1alpha.ReportingApiProto
          .internal_static_google_analytics_data_v1alpha_FunnelStep_descriptor;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.FunnelStep getDefaultInstanceForType() {
      return com.google.analytics.data.v1alpha.FunnelStep.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.FunnelStep build() {
      com.google.analytics.data.v1alpha.FunnelStep result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.analytics.data.v1alpha.FunnelStep buildPartial() {
      com.google.analytics.data.v1alpha.FunnelStep result =
          new com.google.analytics.data.v1alpha.FunnelStep(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.analytics.data.v1alpha.FunnelStep result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.isDirectlyFollowedBy_ = isDirectlyFollowedBy_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.withinDurationFromPriorStep_ =
            withinDurationFromPriorStepBuilder_ == null
                ? withinDurationFromPriorStep_
                : withinDurationFromPriorStepBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.filterExpression_ =
            filterExpressionBuilder_ == null ? filterExpression_ : filterExpressionBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.analytics.data.v1alpha.FunnelStep) {
        return mergeFrom((com.google.analytics.data.v1alpha.FunnelStep) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.analytics.data.v1alpha.FunnelStep other) {
      if (other == com.google.analytics.data.v1alpha.FunnelStep.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getIsDirectlyFollowedBy() != false) {
        setIsDirectlyFollowedBy(other.getIsDirectlyFollowedBy());
      }
      if (other.hasWithinDurationFromPriorStep()) {
        mergeWithinDurationFromPriorStep(other.getWithinDurationFromPriorStep());
      }
      if (other.hasFilterExpression()) {
        mergeFilterExpression(other.getFilterExpression());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                isDirectlyFollowedBy_ = input.readBool();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getWithinDurationFromPriorStepFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getFilterExpressionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The distinctive name for this step. If unspecified, steps will be named
     * by a 1 based indexed name (for example "0. ", "1. ", etc.). This name
     * defines string value returned by the `funnelStepName` dimension. For
     * example, specifying `name = Purchase` in the request's third funnel step
     * will produce `3. Purchase` in the funnel report response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The distinctive name for this step. If unspecified, steps will be named
     * by a 1 based indexed name (for example "0. ", "1. ", etc.). This name
     * defines string value returned by the `funnelStepName` dimension. For
     * example, specifying `name = Purchase` in the request's third funnel step
     * will produce `3. Purchase` in the funnel report response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The distinctive name for this step. If unspecified, steps will be named
     * by a 1 based indexed name (for example "0. ", "1. ", etc.). This name
     * defines string value returned by the `funnelStepName` dimension. For
     * example, specifying `name = Purchase` in the request's third funnel step
     * will produce `3. Purchase` in the funnel report response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The distinctive name for this step. If unspecified, steps will be named
     * by a 1 based indexed name (for example "0. ", "1. ", etc.). This name
     * defines string value returned by the `funnelStepName` dimension. For
     * example, specifying `name = Purchase` in the request's third funnel step
     * will produce `3. Purchase` in the funnel report response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The distinctive name for this step. If unspecified, steps will be named
     * by a 1 based indexed name (for example "0. ", "1. ", etc.). This name
     * defines string value returned by the `funnelStepName` dimension. For
     * example, specifying `name = Purchase` in the request's third funnel step
     * will produce `3. Purchase` in the funnel report response.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private boolean isDirectlyFollowedBy_;

    /**
     *
     *
     * <pre>
     * If true, this step must directly follow the previous step. If false,
     * there can be events between the previous step and this step. If
     * unspecified, `isDirectlyFollowedBy` is treated as false.
     * </pre>
     *
     * <code>bool is_directly_followed_by = 2;</code>
     *
     * @return The isDirectlyFollowedBy.
     */
    @java.lang.Override
    public boolean getIsDirectlyFollowedBy() {
      return isDirectlyFollowedBy_;
    }

    /**
     *
     *
     * <pre>
     * If true, this step must directly follow the previous step. If false,
     * there can be events between the previous step and this step. If
     * unspecified, `isDirectlyFollowedBy` is treated as false.
     * </pre>
     *
     * <code>bool is_directly_followed_by = 2;</code>
     *
     * @param value The isDirectlyFollowedBy to set.
     * @return This builder for chaining.
     */
    public Builder setIsDirectlyFollowedBy(boolean value) {

      isDirectlyFollowedBy_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, this step must directly follow the previous step. If false,
     * there can be events between the previous step and this step. If
     * unspecified, `isDirectlyFollowedBy` is treated as false.
     * </pre>
     *
     * <code>bool is_directly_followed_by = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsDirectlyFollowedBy() {
      bitField0_ = (bitField0_ & ~0x00000002);
      isDirectlyFollowedBy_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration withinDurationFromPriorStep_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        withinDurationFromPriorStepBuilder_;

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     *
     * @return Whether the withinDurationFromPriorStep field is set.
     */
    public boolean hasWithinDurationFromPriorStep() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     *
     * @return The withinDurationFromPriorStep.
     */
    public com.google.protobuf.Duration getWithinDurationFromPriorStep() {
      if (withinDurationFromPriorStepBuilder_ == null) {
        return withinDurationFromPriorStep_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : withinDurationFromPriorStep_;
      } else {
        return withinDurationFromPriorStepBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     */
    public Builder setWithinDurationFromPriorStep(com.google.protobuf.Duration value) {
      if (withinDurationFromPriorStepBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        withinDurationFromPriorStep_ = value;
      } else {
        withinDurationFromPriorStepBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     */
    public Builder setWithinDurationFromPriorStep(
        com.google.protobuf.Duration.Builder builderForValue) {
      if (withinDurationFromPriorStepBuilder_ == null) {
        withinDurationFromPriorStep_ = builderForValue.build();
      } else {
        withinDurationFromPriorStepBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     */
    public Builder mergeWithinDurationFromPriorStep(com.google.protobuf.Duration value) {
      if (withinDurationFromPriorStepBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && withinDurationFromPriorStep_ != null
            && withinDurationFromPriorStep_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getWithinDurationFromPriorStepBuilder().mergeFrom(value);
        } else {
          withinDurationFromPriorStep_ = value;
        }
      } else {
        withinDurationFromPriorStepBuilder_.mergeFrom(value);
      }
      if (withinDurationFromPriorStep_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     */
    public Builder clearWithinDurationFromPriorStep() {
      bitField0_ = (bitField0_ & ~0x00000004);
      withinDurationFromPriorStep_ = null;
      if (withinDurationFromPriorStepBuilder_ != null) {
        withinDurationFromPriorStepBuilder_.dispose();
        withinDurationFromPriorStepBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getWithinDurationFromPriorStepBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getWithinDurationFromPriorStepFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getWithinDurationFromPriorStepOrBuilder() {
      if (withinDurationFromPriorStepBuilder_ != null) {
        return withinDurationFromPriorStepBuilder_.getMessageOrBuilder();
      } else {
        return withinDurationFromPriorStep_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : withinDurationFromPriorStep_;
      }
    }

    /**
     *
     *
     * <pre>
     * If specified, this step must complete within this duration of the
     * completion of the prior step. `withinDurationFromPriorStep` is inclusive
     * of the endpoint at the microsecond granularity. For example a duration of
     * 5 seconds can be completed at 4.9 or 5.0 seconds, but not 5 seconds and 1
     * microsecond.
     *
     * `withinDurationFromPriorStep` is optional, and if unspecified, steps may
     * be separated by any time duration.
     * </pre>
     *
     * <code>optional .google.protobuf.Duration within_duration_from_prior_step = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getWithinDurationFromPriorStepFieldBuilder() {
      if (withinDurationFromPriorStepBuilder_ == null) {
        withinDurationFromPriorStepBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getWithinDurationFromPriorStep(), getParentForChildren(), isClean());
        withinDurationFromPriorStep_ = null;
      }
      return withinDurationFromPriorStepBuilder_;
    }

    private com.google.analytics.data.v1alpha.FunnelFilterExpression filterExpression_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelFilterExpression,
            com.google.analytics.data.v1alpha.FunnelFilterExpression.Builder,
            com.google.analytics.data.v1alpha.FunnelFilterExpressionOrBuilder>
        filterExpressionBuilder_;

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     *
     * @return Whether the filterExpression field is set.
     */
    public boolean hasFilterExpression() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     *
     * @return The filterExpression.
     */
    public com.google.analytics.data.v1alpha.FunnelFilterExpression getFilterExpression() {
      if (filterExpressionBuilder_ == null) {
        return filterExpression_ == null
            ? com.google.analytics.data.v1alpha.FunnelFilterExpression.getDefaultInstance()
            : filterExpression_;
      } else {
        return filterExpressionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     */
    public Builder setFilterExpression(
        com.google.analytics.data.v1alpha.FunnelFilterExpression value) {
      if (filterExpressionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filterExpression_ = value;
      } else {
        filterExpressionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     */
    public Builder setFilterExpression(
        com.google.analytics.data.v1alpha.FunnelFilterExpression.Builder builderForValue) {
      if (filterExpressionBuilder_ == null) {
        filterExpression_ = builderForValue.build();
      } else {
        filterExpressionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     */
    public Builder mergeFilterExpression(
        com.google.analytics.data.v1alpha.FunnelFilterExpression value) {
      if (filterExpressionBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && filterExpression_ != null
            && filterExpression_
                != com.google.analytics.data.v1alpha.FunnelFilterExpression.getDefaultInstance()) {
          getFilterExpressionBuilder().mergeFrom(value);
        } else {
          filterExpression_ = value;
        }
      } else {
        filterExpressionBuilder_.mergeFrom(value);
      }
      if (filterExpression_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     */
    public Builder clearFilterExpression() {
      bitField0_ = (bitField0_ & ~0x00000008);
      filterExpression_ = null;
      if (filterExpressionBuilder_ != null) {
        filterExpressionBuilder_.dispose();
        filterExpressionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelFilterExpression.Builder
        getFilterExpressionBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getFilterExpressionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     */
    public com.google.analytics.data.v1alpha.FunnelFilterExpressionOrBuilder
        getFilterExpressionOrBuilder() {
      if (filterExpressionBuilder_ != null) {
        return filterExpressionBuilder_.getMessageOrBuilder();
      } else {
        return filterExpression_ == null
            ? com.google.analytics.data.v1alpha.FunnelFilterExpression.getDefaultInstance()
            : filterExpression_;
      }
    }

    /**
     *
     *
     * <pre>
     * The condition that your users must meet to be included in this step of
     * the funnel journey.
     * </pre>
     *
     * <code>.google.analytics.data.v1alpha.FunnelFilterExpression filter_expression = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.analytics.data.v1alpha.FunnelFilterExpression,
            com.google.analytics.data.v1alpha.FunnelFilterExpression.Builder,
            com.google.analytics.data.v1alpha.FunnelFilterExpressionOrBuilder>
        getFilterExpressionFieldBuilder() {
      if (filterExpressionBuilder_ == null) {
        filterExpressionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.analytics.data.v1alpha.FunnelFilterExpression,
                com.google.analytics.data.v1alpha.FunnelFilterExpression.Builder,
                com.google.analytics.data.v1alpha.FunnelFilterExpressionOrBuilder>(
                getFilterExpression(), getParentForChildren(), isClean());
        filterExpression_ = null;
      }
      return filterExpressionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.analytics.data.v1alpha.FunnelStep)
  }

  // @@protoc_insertion_point(class_scope:google.analytics.data.v1alpha.FunnelStep)
  private static final com.google.analytics.data.v1alpha.FunnelStep DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.analytics.data.v1alpha.FunnelStep();
  }

  public static com.google.analytics.data.v1alpha.FunnelStep getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FunnelStep> PARSER =
      new com.google.protobuf.AbstractParser<FunnelStep>() {
        @java.lang.Override
        public FunnelStep parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FunnelStep> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FunnelStep> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.analytics.data.v1alpha.FunnelStep getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
