/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.analytics.data.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

// AUTO-GENERATED DOCUMENTATION AND CLASS.
@Generated("by gapic-generator-java")
public class AudienceListName implements ResourceName {
  private static final PathTemplate PROPERTY_AUDIENCE_LIST =
      PathTemplate.createWithoutUrlEncoding("properties/{property}/audienceLists/{audience_list}");
  private volatile Map<String, String> fieldValuesMap;
  private final String property;
  private final String audienceList;

  @Deprecated
  protected AudienceListName() {
    property = null;
    audienceList = null;
  }

  private AudienceListName(Builder builder) {
    property = Preconditions.checkNotNull(builder.getProperty());
    audienceList = Preconditions.checkNotNull(builder.getAudienceList());
  }

  public String getProperty() {
    return property;
  }

  public String getAudienceList() {
    return audienceList;
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public Builder toBuilder() {
    return new Builder(this);
  }

  public static AudienceListName of(String property, String audienceList) {
    return newBuilder().setProperty(property).setAudienceList(audienceList).build();
  }

  public static String format(String property, String audienceList) {
    return newBuilder().setProperty(property).setAudienceList(audienceList).build().toString();
  }

  public static AudienceListName parse(String formattedString) {
    if (formattedString.isEmpty()) {
      return null;
    }
    Map<String, String> matchMap =
        PROPERTY_AUDIENCE_LIST.validatedMatch(
            formattedString, "AudienceListName.parse: formattedString not in valid format");
    return of(matchMap.get("property"), matchMap.get("audience_list"));
  }

  public static List<AudienceListName> parseList(List<String> formattedStrings) {
    List<AudienceListName> list = new ArrayList<>(formattedStrings.size());
    for (String formattedString : formattedStrings) {
      list.add(parse(formattedString));
    }
    return list;
  }

  public static List<String> toStringList(List<AudienceListName> values) {
    List<String> list = new ArrayList<>(values.size());
    for (AudienceListName value : values) {
      if (value == null) {
        list.add("");
      } else {
        list.add(value.toString());
      }
    }
    return list;
  }

  public static boolean isParsableFrom(String formattedString) {
    return PROPERTY_AUDIENCE_LIST.matches(formattedString);
  }

  @Override
  public Map<String, String> getFieldValuesMap() {
    if (fieldValuesMap == null) {
      synchronized (this) {
        if (fieldValuesMap == null) {
          ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
          if (property != null) {
            fieldMapBuilder.put("property", property);
          }
          if (audienceList != null) {
            fieldMapBuilder.put("audience_list", audienceList);
          }
          fieldValuesMap = fieldMapBuilder.build();
        }
      }
    }
    return fieldValuesMap;
  }

  public String getFieldValue(String fieldName) {
    return getFieldValuesMap().get(fieldName);
  }

  @Override
  public String toString() {
    return PROPERTY_AUDIENCE_LIST.instantiate("property", property, "audience_list", audienceList);
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o != null && getClass() == o.getClass()) {
      AudienceListName that = ((AudienceListName) o);
      return Objects.equals(this.property, that.property)
          && Objects.equals(this.audienceList, that.audienceList);
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= Objects.hashCode(property);
    h *= 1000003;
    h ^= Objects.hashCode(audienceList);
    return h;
  }

  /** Builder for properties/{property}/audienceLists/{audience_list}. */
  public static class Builder {
    private String property;
    private String audienceList;

    protected Builder() {}

    public String getProperty() {
      return property;
    }

    public String getAudienceList() {
      return audienceList;
    }

    public Builder setProperty(String property) {
      this.property = property;
      return this;
    }

    public Builder setAudienceList(String audienceList) {
      this.audienceList = audienceList;
      return this;
    }

    private Builder(AudienceListName audienceListName) {
      this.property = audienceListName.property;
      this.audienceList = audienceListName.audienceList;
    }

    public AudienceListName build() {
      return new AudienceListName(this);
    }
  }
}
