/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AudienceListName
implements ResourceName {
    private static final PathTemplate PROPERTYID_AUDIENCELISTID = PathTemplate.createWithoutUrlEncoding((String)"properties/{propertyId}/audienceLists/{audienceListId}");
    private volatile Map<String, String> fieldValuesMap;
    private final String propertyId;
    private final String audienceListId;

    @Deprecated
    protected AudienceListName() {
        this.propertyId = null;
        this.audienceListId = null;
    }

    private AudienceListName(Builder builder) {
        this.propertyId = (String)Preconditions.checkNotNull((Object)builder.getPropertyId());
        this.audienceListId = (String)Preconditions.checkNotNull((Object)builder.getAudienceListId());
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getAudienceListId() {
        return this.audienceListId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AudienceListName of(String propertyId, String audienceListId) {
        return AudienceListName.newBuilder().setPropertyId(propertyId).setAudienceListId(audienceListId).build();
    }

    public static String format(String propertyId, String audienceListId) {
        return AudienceListName.newBuilder().setPropertyId(propertyId).setAudienceListId(audienceListId).build().toString();
    }

    public static AudienceListName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTYID_AUDIENCELISTID.validatedMatch(formattedString, "AudienceListName.parse: formattedString not in valid format");
        return AudienceListName.of((String)matchMap.get("propertyId"), (String)matchMap.get("audienceListId"));
    }

    public static List<AudienceListName> parseList(List<String> formattedStrings) {
        ArrayList<AudienceListName> list = new ArrayList<AudienceListName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AudienceListName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AudienceListName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AudienceListName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTYID_AUDIENCELISTID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AudienceListName audienceListName = this;
            synchronized (audienceListName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.propertyId != null) {
                        fieldMapBuilder.put((Object)"propertyId", (Object)this.propertyId);
                    }
                    if (this.audienceListId != null) {
                        fieldMapBuilder.put((Object)"audienceListId", (Object)this.audienceListId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTYID_AUDIENCELISTID.instantiate(new String[]{"propertyId", this.propertyId, "audienceListId", this.audienceListId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AudienceListName that = (AudienceListName)o;
            return Objects.equals(this.propertyId, that.propertyId) && Objects.equals(this.audienceListId, that.audienceListId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.propertyId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.audienceListId);
    }

    public static class Builder {
        private String propertyId;
        private String audienceListId;

        protected Builder() {
        }

        public String getPropertyId() {
            return this.propertyId;
        }

        public String getAudienceListId() {
            return this.audienceListId;
        }

        public Builder setPropertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public Builder setAudienceListId(String audienceListId) {
            this.audienceListId = audienceListId;
            return this;
        }

        private Builder(AudienceListName audienceListName) {
            this.propertyId = audienceListName.propertyId;
            this.audienceListId = audienceListName.audienceListId;
        }

        public AudienceListName build() {
            return new AudienceListName(this);
        }
    }
}

