/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.admin.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccountName
implements ResourceName {
    private static final PathTemplate ACCOUNT = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;

    @Deprecated
    protected AccountName() {
        this.account = null;
    }

    private AccountName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
    }

    public String getAccount() {
        return this.account;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AccountName of(String account) {
        return AccountName.newBuilder().setAccount(account).build();
    }

    public static String format(String account) {
        return AccountName.newBuilder().setAccount(account).build().toString();
    }

    public static AccountName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT.validatedMatch(formattedString, "AccountName.parse: formattedString not in valid format");
        return AccountName.of((String)matchMap.get("account"));
    }

    public static List<AccountName> parseList(List<String> formattedStrings) {
        ArrayList<AccountName> list = new ArrayList<AccountName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountName accountName = this;
            synchronized (accountName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT.instantiate(new String[]{"account", this.account});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AccountName that = (AccountName)o;
            return Objects.equals(this.account, that.account);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.account);
    }

    public static class Builder {
        private String account;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        private Builder(AccountName accountName) {
            this.account = accountName.account;
        }

        public AccountName build() {
            return new AccountName(this);
        }
    }
}

