/*
 * Decompiled with CFR 0.152.
 */
package com.google.storage.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import com.google.storage.v2.QueryWriteStatusRequest;
import com.google.storage.v2.QueryWriteStatusResponse;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StartResumableWriteRequest;
import com.google.storage.v2.StartResumableWriteResponse;
import com.google.storage.v2.WriteObjectRequest;
import com.google.storage.v2.WriteObjectResponse;
import com.google.storage.v2.stub.GrpcStorageCallableFactory;
import com.google.storage.v2.stub.StorageStub;
import com.google.storage.v2.stub.StorageStubSettings;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcStorageStub
extends StorageStub {
    private static final MethodDescriptor<ReadObjectRequest, ReadObjectResponse> readObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.storage.v2.Storage/ReadObject").setRequestMarshaller(ProtoUtils.marshaller((Message)ReadObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ReadObjectResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<WriteObjectRequest, WriteObjectResponse> writeObjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.CLIENT_STREAMING).setFullMethodName("google.storage.v2.Storage/WriteObject").setRequestMarshaller(ProtoUtils.marshaller((Message)WriteObjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)WriteObjectResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/StartResumableWrite").setRequestMarshaller(ProtoUtils.marshaller((Message)StartResumableWriteRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)StartResumableWriteResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.storage.v2.Storage/QueryWriteStatus").setRequestMarshaller(ProtoUtils.marshaller((Message)QueryWriteStatusRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)QueryWriteStatusResponse.getDefaultInstance())).build();
    private final ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> readObjectCallable;
    private final ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeObjectCallable;
    private final UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteCallable;
    private final UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcStorageStub create(StorageStubSettings settings) throws IOException {
        return new GrpcStorageStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcStorageStub create(ClientContext clientContext) throws IOException {
        return new GrpcStorageStub(StorageStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcStorageStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcStorageStub(StorageStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcStorageStub(StorageStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcStorageCallableFactory());
    }

    protected GrpcStorageStub(StorageStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings readObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readObjectMethodDescriptor).build();
        GrpcCallSettings writeObjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(writeObjectMethodDescriptor).build();
        GrpcCallSettings startResumableWriteTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startResumableWriteMethodDescriptor).build();
        GrpcCallSettings queryWriteStatusTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(queryWriteStatusMethodDescriptor).build();
        this.readObjectCallable = callableFactory.createServerStreamingCallable(readObjectTransportSettings, settings.readObjectSettings(), clientContext);
        this.writeObjectCallable = callableFactory.createClientStreamingCallable(writeObjectTransportSettings, settings.writeObjectSettings(), clientContext);
        this.startResumableWriteCallable = callableFactory.createUnaryCallable(startResumableWriteTransportSettings, settings.startResumableWriteSettings(), clientContext);
        this.queryWriteStatusCallable = callableFactory.createUnaryCallable(queryWriteStatusTransportSettings, settings.queryWriteStatusSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public ServerStreamingCallable<ReadObjectRequest, ReadObjectResponse> readObjectCallable() {
        return this.readObjectCallable;
    }

    @Override
    public ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> writeObjectCallable() {
        return this.writeObjectCallable;
    }

    @Override
    public UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> startResumableWriteCallable() {
        return this.startResumableWriteCallable;
    }

    @Override
    public UnaryCallable<QueryWriteStatusRequest, QueryWriteStatusResponse> queryWriteStatusCallable() {
        return this.queryWriteStatusCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

