/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.OperationFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@InternalApi(value="for testing")
public class FakeOperationApi {

    public static class FakeOperation {
    }

    public static class FakeOperationFuture
    extends AbstractApiFuture<String>
    implements OperationFuture<String, Long, FakeOperation> {
        private final String result;
        private final String operationName;

        public FakeOperationFuture(String result, String operationName) {
            this.result = result;
            this.operationName = operationName;
        }

        public String get() {
            return this.result;
        }

        @Override
        public String getName() throws InterruptedException, ExecutionException {
            return this.operationName;
        }

        @Override
        public ApiFuture<FakeOperation> getInitialFuture() {
            return null;
        }

        @Override
        public ApiFuture<Long> peekMetadata() {
            return null;
        }

        @Override
        public ApiFuture<Long> getMetadata() {
            return null;
        }
    }

    public static class OperationStashCallable
    extends OperationCallable<Integer, String, Long, FakeOperation> {
        private ApiCallContext context;
        private Integer request;
        private Map<String, FakeOperationFuture> operations = new HashMap<String, FakeOperationFuture>();
        private ApiCallContext resumeContext;
        private ApiCallContext cancelContext;
        private boolean wasCancelCalled = false;

        @Override
        public OperationFuture<String, Long, FakeOperation> futureCall(Integer request, ApiCallContext context) {
            this.request = request;
            this.context = context;
            String opName = "opName-" + request;
            FakeOperationFuture opFuture = new FakeOperationFuture(request.toString(), opName);
            this.operations.put(opName, opFuture);
            return opFuture;
        }

        @Override
        public OperationFuture<String, Long, FakeOperation> resumeFutureCall(String operationName, ApiCallContext context) {
            if (!this.operations.containsKey(operationName)) {
                throw new IllegalArgumentException("Operation not found: " + operationName);
            }
            this.resumeContext = context;
            return this.operations.get(operationName);
        }

        @Override
        public ApiFuture<Void> cancel(String operationName, ApiCallContext context) {
            this.wasCancelCalled = true;
            this.cancelContext = context;
            return ApiFutures.immediateFuture(null);
        }

        public ApiCallContext getContext() {
            return this.context;
        }

        public Integer getRequest() {
            return this.request;
        }

        public ApiCallContext getResumeContext() {
            return this.resumeContext;
        }

        public boolean wasCancelCalled() {
            return this.wasCancelCalled;
        }

        public ApiCallContext getCancelContext() {
            return this.cancelContext;
        }
    }
}

