/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.ApiFutureCallback;
import com.google.api.gax.tracing.ApiTracer;
import java.util.concurrent.CancellationException;

class TraceFinisher<T>
implements ApiFutureCallback<T> {
    private final ApiTracer tracer;

    TraceFinisher(ApiTracer tracer) {
        this.tracer = tracer;
    }

    public void onFailure(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.tracer.operationCancelled();
        } else {
            this.tracer.operationFailed(throwable);
        }
    }

    public void onSuccess(T responseT) {
        this.tracer.operationSucceeded();
    }
}

