/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.batching.BatchMerger;
import com.google.api.gax.batching.BatchingFlowController;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.BatchingThreshold;
import com.google.api.gax.batching.ElementCounter;
import com.google.api.gax.batching.NumericThreshold;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.ThresholdBatcher;
import com.google.api.gax.core.FlowControlSettings;
import com.google.api.gax.core.FlowController;
import com.google.api.gax.grpc.Batch;
import com.google.api.gax.grpc.BatchExecutor;
import com.google.api.gax.grpc.BatchingDescriptor;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;

public final class BatcherFactory<RequestT, ResponseT> {
    private final Map<PartitionKey, ThresholdBatcher<Batch<RequestT, ResponseT>>> batchers = new ConcurrentHashMap<PartitionKey, ThresholdBatcher<Batch<RequestT, ResponseT>>>();
    private final ScheduledExecutorService executor;
    private final BatchingDescriptor<RequestT, ResponseT> batchingDescriptor;
    private final FlowController flowController;
    private final BatchingSettings batchingSettings;
    private final Object lock = new Object();

    public BatcherFactory(BatchingDescriptor<RequestT, ResponseT> batchingDescriptor, BatchingSettings batchingSettings, ScheduledExecutorService executor) {
        this(batchingDescriptor, batchingSettings, executor, new FlowController(batchingSettings.getFlowControlSettings() != null ? batchingSettings.getFlowControlSettings() : FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Ignore).build()));
    }

    public BatcherFactory(BatchingDescriptor<RequestT, ResponseT> batchingDescriptor, BatchingSettings batchingSettings, ScheduledExecutorService executor, FlowController flowController) {
        this.batchingDescriptor = batchingDescriptor;
        this.batchingSettings = batchingSettings;
        this.executor = executor;
        this.flowController = flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThresholdBatcher<Batch<RequestT, ResponseT>> getPushingBatcher(PartitionKey partitionKey) {
        ThresholdBatcher<Batch<RequestT, ResponseT>> batcher = this.batchers.get(partitionKey);
        if (batcher == null) {
            Object object = this.lock;
            synchronized (object) {
                batcher = this.batchers.get(partitionKey);
                if (batcher == null) {
                    batcher = this.createBatcher(partitionKey);
                    this.batchers.put(partitionKey, batcher);
                }
            }
        }
        return batcher;
    }

    BatchingSettings getBatchingSettings() {
        return this.batchingSettings;
    }

    private ThresholdBatcher<Batch<RequestT, ResponseT>> createBatcher(PartitionKey partitionKey) {
        BatchExecutor<RequestT, ResponseT> processor = new BatchExecutor<RequestT, ResponseT>(this.batchingDescriptor, partitionKey);
        return ThresholdBatcher.newBuilder().setThresholds((Collection<BatchingThreshold<Batch<RequestT, ResponseT>>>)this.getThresholds(this.batchingSettings)).setExecutor(this.executor).setMaxDelay(this.batchingSettings.getDelayThreshold()).setReceiver(processor).setFlowController(this.createBatchingFlowController()).setBatchMerger(this.createBatchMerger()).build();
    }

    private BatchingFlowController<Batch<RequestT, ResponseT>> createBatchingFlowController() {
        return new BatchingFlowController<Batch<RequestT, ResponseT>>(this.flowController, new ElementCounter<Batch<RequestT, ResponseT>>(){

            @Override
            public long count(Batch<RequestT, ResponseT> batch) {
                return BatcherFactory.this.batchingDescriptor.countElements(batch.getRequest());
            }
        }, new ElementCounter<Batch<RequestT, ResponseT>>(){

            @Override
            public long count(Batch<RequestT, ResponseT> batch) {
                return batch.getByteCount();
            }
        });
    }

    private BatchMerger<Batch<RequestT, ResponseT>> createBatchMerger() {
        return new BatchMerger<Batch<RequestT, ResponseT>>(){

            @Override
            public void merge(Batch<RequestT, ResponseT> batch, Batch<RequestT, ResponseT> newBatch) {
                batch.merge(newBatch);
            }
        };
    }

    private ImmutableList<BatchingThreshold<Batch<RequestT, ResponseT>>> getThresholds(BatchingSettings batchingSettings) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        if (batchingSettings.getElementCountThreshold() != null) {
            ElementCounter elementCounter = new ElementCounter<Batch<RequestT, ResponseT>>(){

                @Override
                public long count(Batch<RequestT, ResponseT> batch) {
                    return BatcherFactory.this.batchingDescriptor.countElements(batch.getRequest());
                }
            };
            NumericThreshold countThreshold = new NumericThreshold(batchingSettings.getElementCountThreshold(), elementCounter);
            listBuilder.add(countThreshold);
        }
        if (batchingSettings.getRequestByteThreshold() != null) {
            ElementCounter requestByteCounter = new ElementCounter<Batch<RequestT, ResponseT>>(){

                @Override
                public long count(Batch<RequestT, ResponseT> batch) {
                    return batch.getByteCount();
                }
            };
            NumericThreshold byteThreshold = new NumericThreshold(batchingSettings.getRequestByteThreshold(), requestByteCounter);
            listBuilder.add(byteThreshold);
        }
        return listBuilder.build();
    }
}

