/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.bundling;

import com.google.api.gax.bundling.BundlingThreshold;
import com.google.api.gax.bundling.ElementCounter;
import com.google.common.base.Preconditions;

public final class NumericThreshold<E>
implements BundlingThreshold<E> {
    private final long threshold;
    private final ElementCounter<E> extractor;
    private long sum;

    public NumericThreshold(long threshold, ElementCounter<E> extractor) {
        this.threshold = threshold;
        this.extractor = (ElementCounter)Preconditions.checkNotNull(extractor);
        this.sum = 0L;
    }

    @Override
    public void accumulate(E e) {
        this.sum += this.extractor.count(e);
    }

    @Override
    public boolean isThresholdReached() {
        return this.sum >= this.threshold;
    }

    @Override
    public BundlingThreshold<E> copyWithZeroedValue() {
        return new NumericThreshold<E>(this.threshold, this.extractor);
    }
}

