/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.testing;

import com.google.api.gax.grpc.ChannelProvider;
import io.grpc.ManagedChannel;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

public class LocalChannelProvider
implements ChannelProvider {
    private final SocketAddress address;

    private LocalChannelProvider(String addressString) {
        this.address = new LocalAddress(addressString);
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    @Override
    public boolean needsExecutor() {
        return false;
    }

    @Override
    public ManagedChannel getChannel() {
        return NettyChannelBuilder.forAddress((SocketAddress)this.address).negotiationType(NegotiationType.PLAINTEXT).channelType(LocalChannel.class).build();
    }

    @Override
    public ManagedChannel getChannel(Executor executor) {
        throw new IllegalStateException("getChannel(Executor) called when needsExecutor() is false.");
    }

    public static LocalChannelProvider create(String addressString) {
        return new LocalChannelProvider(addressString);
    }
}

