/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.AutoValue_FlowControlSettings;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public abstract class FlowControlSettings {
    public static FlowControlSettings getDefaultInstance() {
        return FlowControlSettings.newBuilder().build();
    }

    @Nullable
    public abstract Integer getMaxOutstandingElementCount();

    @Nullable
    public abstract Integer getMaxOutstandingRequestBytes();

    public Builder toBuilder() {
        return new AutoValue_FlowControlSettings.Builder(this);
    }

    public static Builder newBuilder() {
        return new AutoValue_FlowControlSettings.Builder();
    }

    public static abstract class Builder {
        public abstract Builder setMaxOutstandingElementCount(Integer var1);

        public abstract Builder setMaxOutstandingRequestBytes(Integer var1);

        abstract FlowControlSettings autoBuild();

        public FlowControlSettings build() {
            FlowControlSettings settings = this.autoBuild();
            Preconditions.checkArgument((settings.getMaxOutstandingElementCount() == null || settings.getMaxOutstandingElementCount() > 0 ? 1 : 0) != 0, (Object)"maxOutstandingElementCount limit is disabled by default, but if set it must be set to a value greater than 0.");
            Preconditions.checkArgument((settings.getMaxOutstandingRequestBytes() == null || settings.getMaxOutstandingRequestBytes() > 0 ? 1 : 0) != 0, (Object)"maxOutstandingRequestBytes limit is disabled by default, but if set it must be set to a value greater than 0.");
            return settings;
        }
    }
}

