
package com.google.api.gax.core;

import javax.annotation.Generated;
import org.joda.time.Duration;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RetryParams extends RetryParams {

  private final BackoffParams retryBackoff;
  private final BackoffParams timeoutBackoff;
  private final Duration totalTimeout;

  private AutoValue_RetryParams(
      BackoffParams retryBackoff,
      BackoffParams timeoutBackoff,
      Duration totalTimeout) {
    if (retryBackoff == null) {
      throw new NullPointerException("Null retryBackoff");
    }
    this.retryBackoff = retryBackoff;
    if (timeoutBackoff == null) {
      throw new NullPointerException("Null timeoutBackoff");
    }
    this.timeoutBackoff = timeoutBackoff;
    if (totalTimeout == null) {
      throw new NullPointerException("Null totalTimeout");
    }
    this.totalTimeout = totalTimeout;
  }

  @Override
  public BackoffParams getRetryBackoff() {
    return retryBackoff;
  }

  @Override
  public BackoffParams getTimeoutBackoff() {
    return timeoutBackoff;
  }

  @Override
  public Duration getTotalTimeout() {
    return totalTimeout;
  }

  @Override
  public String toString() {
    return "RetryParams{"
        + "retryBackoff=" + retryBackoff + ", "
        + "timeoutBackoff=" + timeoutBackoff + ", "
        + "totalTimeout=" + totalTimeout
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RetryParams) {
      RetryParams that = (RetryParams) o;
      return (this.retryBackoff.equals(that.getRetryBackoff()))
           && (this.timeoutBackoff.equals(that.getTimeoutBackoff()))
           && (this.totalTimeout.equals(that.getTotalTimeout()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= retryBackoff.hashCode();
    h *= 1000003;
    h ^= timeoutBackoff.hashCode();
    h *= 1000003;
    h ^= totalTimeout.hashCode();
    return h;
  }

  static final class Builder extends RetryParams.Builder {
    private BackoffParams retryBackoff;
    private BackoffParams timeoutBackoff;
    private Duration totalTimeout;
    Builder() {
    }
    Builder(RetryParams source) {
      this.retryBackoff = source.getRetryBackoff();
      this.timeoutBackoff = source.getTimeoutBackoff();
      this.totalTimeout = source.getTotalTimeout();
    }
    @Override
    public RetryParams.Builder setRetryBackoff(BackoffParams retryBackoff) {
      this.retryBackoff = retryBackoff;
      return this;
    }
    @Override
    public RetryParams.Builder setTimeoutBackoff(BackoffParams timeoutBackoff) {
      this.timeoutBackoff = timeoutBackoff;
      return this;
    }
    @Override
    public RetryParams.Builder setTotalTimeout(Duration totalTimeout) {
      this.totalTimeout = totalTimeout;
      return this;
    }
    @Override
    public RetryParams autoBuild() {
      String missing = "";
      if (retryBackoff == null) {
        missing += " retryBackoff";
      }
      if (timeoutBackoff == null) {
        missing += " timeoutBackoff";
      }
      if (totalTimeout == null) {
        missing += " totalTimeout";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_RetryParams(
          this.retryBackoff,
          this.timeoutBackoff,
          this.totalTimeout);
    }
  }
}
