/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.bundling.ExternalThreshold;
import com.google.api.gax.bundling.ThresholdBundleHandle;

class BlockingCallThreshold<E>
implements ExternalThreshold<E> {
    private final long threshold;
    private long sum;

    public BlockingCallThreshold(long threshold) {
        this.threshold = threshold;
        this.sum = 0L;
    }

    @Override
    public void startBundle() {
    }

    @Override
    public void handleEvent(ThresholdBundleHandle bundleHandle, Object event) {
        if (event instanceof NewBlockingCall) {
            ++this.sum;
            if (this.sum >= this.threshold) {
                bundleHandle.flush();
            }
        }
    }

    @Override
    public ExternalThreshold<E> copyWithZeroedValue() {
        return new BlockingCallThreshold<E>(this.threshold);
    }

    public static class NewBlockingCall {
    }
}

