/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ExecutorProvider;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public final class InstantiatingExecutorProvider
implements ExecutorProvider {
    private final int executorThreadCount;

    private InstantiatingExecutorProvider(int executorThreadCount) {
        this.executorThreadCount = executorThreadCount;
    }

    @Override
    public ScheduledExecutorService getExecutor() {
        return MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(this.executorThreadCount));
    }

    @Override
    public boolean shouldAutoClose() {
        return true;
    }

    public int getExecutorThreadCount() {
        return this.executorThreadCount;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private static final int DEFAULT_EXECUTOR_THREADS = 4;
        private int executorThreadCount = 4;

        private Builder() {
        }

        public Builder setExecutorThreadCount(int executorThreadCount) {
            this.executorThreadCount = executorThreadCount;
            return this;
        }

        public int getExecutorThreadCount() {
            return this.executorThreadCount;
        }

        private Builder(InstantiatingExecutorProvider provider) {
            this.executorThreadCount = provider.executorThreadCount;
        }

        public InstantiatingExecutorProvider build() {
            return new InstantiatingExecutorProvider(this.executorThreadCount);
        }
    }
}

