/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CancellationException;

class ExceptionTransformingCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final ImmutableSet<Status.Code> retryableCodes;

    ExceptionTransformingCallable(FutureCallable<RequestT, ResponseT> callable, ImmutableSet<Status.Code> retryableCodes) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.retryableCodes = (ImmutableSet)Preconditions.checkNotNull(retryableCodes);
    }

    @Override
    public ListenableFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        ListenableFuture<ResponseT> innerCallFuture = this.callable.futureCall(request, context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        Futures.addCallback(innerCallFuture, (FutureCallback)transformingFuture);
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractFuture<ResponseT>
    implements FutureCallback<ResponseT> {
        private ListenableFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(ListenableFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        public void onFailure(Throwable throwable) {
            boolean canRetry;
            Status.Code statusCode;
            if (throwable instanceof StatusException) {
                StatusException e = (StatusException)throwable;
                statusCode = e.getStatus().getCode();
                canRetry = ExceptionTransformingCallable.this.retryableCodes.contains((Object)statusCode);
            } else if (throwable instanceof StatusRuntimeException) {
                StatusRuntimeException e = (StatusRuntimeException)throwable;
                statusCode = e.getStatus().getCode();
                canRetry = ExceptionTransformingCallable.this.retryableCodes.contains((Object)statusCode);
            } else {
                if (throwable instanceof CancellationException && this.cancelled) {
                    return;
                }
                statusCode = Status.Code.UNKNOWN;
                canRetry = false;
            }
            super.setException((Throwable)new ApiException(throwable, statusCode, canRetry));
        }
    }
}

