/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.testing;

import com.google.api.gax.testing.EmulatorRunner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalServiceHelper {
    private final int port;
    private EmulatorRunner activeRunner;
    private List<EmulatorRunner> runners;
    private ProcessStreamReader processReader;
    private ProcessErrorStreamReader processErrorReader;
    private static final Logger log = Logger.getLogger(LocalServiceHelper.class.getName());
    private static final int DEFAULT_PORT = 8080;
    private static final int STREAM_READER_SLEEP_INTERVAL_IN_MS = 200;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findAvailablePort(int defaultPort) {
        try (ServerSocket tempSocket = new ServerSocket(0);){
            int n = tempSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            return defaultPort;
        }
    }

    public LocalServiceHelper(List<EmulatorRunner> runners, int port) {
        this.port = port > 0 ? port : 8080;
        this.runners = runners;
    }

    public void start(String blockUntilOutput) throws IOException, InterruptedException {
        for (EmulatorRunner runner : this.runners) {
            if (!runner.isAvailable()) continue;
            this.activeRunner = runner;
            runner.start();
            break;
        }
        if (this.activeRunner == null) {
            throw new IOException("No available emulator runner is found.");
        }
        this.processReader = ProcessStreamReader.start(this.activeRunner.getProcess().getInputStream());
        this.processErrorReader = ProcessErrorStreamReader.start(this.activeRunner.getProcess().getErrorStream(), blockUntilOutput);
    }

    public void stop() throws IOException, InterruptedException {
        if (this.processReader != null) {
            this.processReader.terminate();
            this.processReader = null;
        }
        if (this.processErrorReader != null) {
            this.processErrorReader.terminate();
            this.processErrorReader = null;
        }
        if (this.activeRunner != null) {
            this.activeRunner.stop();
            this.activeRunner = null;
        }
    }

    public String sendPostRequest(String request) throws IOException {
        URL url = new URL("http", "localhost", this.port, request);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        OutputStream out = con.getOutputStream();
        out.write("".getBytes());
        out.flush();
        InputStream in = con.getInputStream();
        String response = CharStreams.toString((Readable)new InputStreamReader(con.getInputStream()));
        in.close();
        return response;
    }

    private static class ProcessErrorStreamReader
    extends Thread {
        private static final int LOG_LENGTH_LIMIT = 50000;
        private static final String LOGGING_CLASS = "com.google.apphosting.client.serviceapp.BaseApiServlet";
        private final BufferedReader errorReader;
        private StringBuilder currentLog;
        private Level currentLogLevel;
        private boolean collectionMode;
        private volatile boolean terminated;

        ProcessErrorStreamReader(InputStream errorStream, String blockUntil) throws IOException {
            super("Local ErrorStream reader");
            this.setDaemon(true);
            this.errorReader = new BufferedReader(new InputStreamReader(errorStream));
            if (!Strings.isNullOrEmpty((String)blockUntil)) {
                String line;
                while ((line = this.errorReader.readLine()) != null && !line.contains(blockUntil)) {
                }
            }
        }

        void terminate() throws IOException {
            this.terminated = true;
            this.errorReader.close();
            this.interrupt();
        }

        @Override
        public void run() {
            String previousLine = "";
            String nextLine = "";
            while (!this.terminated) {
                try {
                    if (this.errorReader.ready()) {
                        previousLine = nextLine;
                        nextLine = this.errorReader.readLine();
                        if (nextLine == null) {
                            this.terminated = true;
                            continue;
                        }
                        this.processLogLine(previousLine, nextLine);
                        continue;
                    }
                    ProcessErrorStreamReader.sleep(200L);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            this.processLogLine(previousLine, (String)MoreObjects.firstNonNull((Object)nextLine, (Object)""));
            ProcessErrorStreamReader.writeLog(this.currentLogLevel, this.currentLog);
        }

        private void processLogLine(String previousLine, String nextLine) {
            Level nextLogLevel = ProcessErrorStreamReader.getLevel(nextLine);
            if (nextLogLevel != null) {
                ProcessErrorStreamReader.writeLog(this.currentLogLevel, this.currentLog);
                this.currentLog = new StringBuilder();
                this.currentLogLevel = nextLogLevel;
                this.collectionMode = previousLine.contains(LOGGING_CLASS);
            } else if (this.collectionMode) {
                if (this.currentLog.length() > 50000) {
                    this.collectionMode = false;
                } else if (this.currentLog.length() == 0) {
                    this.currentLog.append(previousLine.split(":", 2)[1]);
                    this.currentLog.append(System.getProperty("line.separator"));
                } else {
                    this.currentLog.append(previousLine);
                    this.currentLog.append(System.getProperty("line.separator"));
                }
            }
        }

        private static void writeLog(Level level, StringBuilder msg) {
            if (level != null && msg != null && msg.length() != 0) {
                log.log(level, msg.toString().trim());
            }
        }

        private static Level getLevel(String line) {
            try {
                return Level.parse(line.split(":")[0]);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static ProcessErrorStreamReader start(InputStream errorStream, String blockUntil) throws IOException {
            ProcessErrorStreamReader thread = new ProcessErrorStreamReader(errorStream, blockUntil);
            thread.start();
            return thread;
        }
    }

    private static class ProcessStreamReader
    extends Thread {
        private final BufferedReader reader;
        private volatile boolean terminated;

        ProcessStreamReader(InputStream inputStream) {
            super("Local InputStream reader");
            this.setDaemon(true);
            this.reader = new BufferedReader(new InputStreamReader(inputStream));
        }

        void terminate() throws IOException {
            this.terminated = true;
            this.reader.close();
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.terminated) {
                try {
                    if (this.reader.ready()) {
                        String line = this.reader.readLine();
                        if (line != null) continue;
                        this.terminated = true;
                        continue;
                    }
                    ProcessStreamReader.sleep(200L);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public static ProcessStreamReader start(InputStream inputStream) {
            ProcessStreamReader thread = new ProcessStreamReader(inputStream);
            thread.start();
            return thread;
        }
    }
}

