/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.testing;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CommandWrapper {
    private final List<String> prefix = new ArrayList<String>();
    private List<String> command;
    private String nullFilename;
    private boolean redirectOutputToNull;
    private boolean redirectErrorStream;
    private boolean redirectErrorInherit;
    private Path directory;

    private CommandWrapper() {
        if (CommandWrapper.isWindows()) {
            this.prefix.add("cmd");
            this.prefix.add("/C");
            this.nullFilename = "NUL:";
        } else {
            this.prefix.add("bash");
            this.nullFilename = "/dev/null";
        }
    }

    public CommandWrapper command(List<String> command) {
        this.command = new ArrayList<String>(command.size() + this.prefix.size());
        this.command.addAll(this.prefix);
        this.command.addAll(command);
        return this;
    }

    public CommandWrapper redirectOutputToNull() {
        this.redirectOutputToNull = true;
        return this;
    }

    public CommandWrapper redirectErrorStream() {
        this.redirectErrorStream = true;
        return this;
    }

    public CommandWrapper redirectErrorInherit() {
        this.redirectErrorInherit = true;
        return this;
    }

    public CommandWrapper directory(Path directory) {
        this.directory = directory;
        return this;
    }

    public ProcessBuilder builder() {
        ProcessBuilder builder = new ProcessBuilder(this.command);
        if (this.redirectOutputToNull) {
            builder.redirectOutput(new File(this.nullFilename));
        }
        if (this.directory != null) {
            builder.directory(this.directory.toFile());
        }
        if (this.redirectErrorStream) {
            builder.redirectErrorStream(true);
        }
        if (this.redirectErrorInherit) {
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        return builder;
    }

    public Process start() throws IOException {
        return this.builder().start();
    }

    public static CommandWrapper create() {
        return new CommandWrapper();
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    }
}

