/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.DescriptorClientCallFactory;
import com.google.api.gax.grpc.DirectStreamingCallable;
import com.google.api.gax.grpc.StreamingCallable;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;

public class StreamingCallSettings<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor) {
        return new Builder<RequestT, ResponseT>(grpcMethodDescriptor);
    }

    public StreamingCallSettings(MethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public final Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
        return this.methodDescriptor;
    }

    StreamingCallable<RequestT, ResponseT> createStreamingCallable(ManagedChannel channel) {
        DescriptorClientCallFactory<RequestT, ResponseT> clientCallFactory = new DescriptorClientCallFactory<RequestT, ResponseT>(this.methodDescriptor);
        StreamingCallable<RequestT, ResponseT> callable = new StreamingCallable<RequestT, ResponseT>(new DirectStreamingCallable<RequestT, ResponseT>(clientCallFactory));
        callable.bind(channel);
        return callable;
    }

    public static class Builder<RequestT, ResponseT> {
        private MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor;

        public Builder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor) {
            this.grpcMethodDescriptor = grpcMethodDescriptor;
        }

        public Builder(StreamingCallSettings<RequestT, ResponseT> settings) {
            this.grpcMethodDescriptor = settings.getMethodDescriptor();
        }

        public StreamingCallSettings<RequestT, ResponseT> build() {
            return new StreamingCallSettings<RequestT, ResponseT>(this.grpcMethodDescriptor);
        }
    }
}

