/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.CredentialsProvider;

final class AutoValue_ConnectionSettings
extends ConnectionSettings {
    private final CredentialsProvider credentialsProvider;
    private final String serviceAddress;
    private final int port;

    private AutoValue_ConnectionSettings(CredentialsProvider credentialsProvider, String serviceAddress, int port) {
        if (credentialsProvider == null) {
            throw new NullPointerException("Null credentialsProvider");
        }
        this.credentialsProvider = credentialsProvider;
        if (serviceAddress == null) {
            throw new NullPointerException("Null serviceAddress");
        }
        this.serviceAddress = serviceAddress;
        this.port = port;
    }

    @Override
    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public String getServiceAddress() {
        return this.serviceAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "ConnectionSettings{credentialsProvider=" + this.credentialsProvider + ", " + "serviceAddress=" + this.serviceAddress + ", " + "port=" + this.port + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConnectionSettings) {
            ConnectionSettings that = (ConnectionSettings)o;
            return this.credentialsProvider.equals(that.getCredentialsProvider()) && this.serviceAddress.equals(that.getServiceAddress()) && this.port == that.getPort();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.credentialsProvider.hashCode();
        h *= 1000003;
        h ^= this.serviceAddress.hashCode();
        h *= 1000003;
        return h ^= this.port;
    }

    static final class Builder
    extends ConnectionSettings.Builder {
        private CredentialsProvider credentialsProvider;
        private String serviceAddress;
        private Integer port;

        Builder() {
        }

        Builder(ConnectionSettings source) {
            this.credentialsProvider = source.getCredentialsProvider();
            this.serviceAddress = source.getServiceAddress();
            this.port = source.getPort();
        }

        @Override
        public ConnectionSettings.Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public ConnectionSettings.Builder setServiceAddress(String serviceAddress) {
            this.serviceAddress = serviceAddress;
            return this;
        }

        @Override
        public ConnectionSettings.Builder setPort(int port) {
            this.port = port;
            return this;
        }

        @Override
        public ConnectionSettings build() {
            String missing = "";
            if (this.credentialsProvider == null) {
                missing = missing + " credentialsProvider";
            }
            if (this.serviceAddress == null) {
                missing = missing + " serviceAddress";
            }
            if (this.port == null) {
                missing = missing + " port";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ConnectionSettings(this.credentialsProvider, this.serviceAddress, this.port);
        }
    }
}

