/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.grpc.ChannelPool;
import com.google.api.gax.grpc.GrpcChannelUUIDInterceptor;
import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.GrpcMetadataHandlerInterceptor;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.alts.ComputeEngineChannelBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@InternalExtensionOnly
public final class InstantiatingGrpcChannelProvider
implements TransportChannelProvider {
    static final String DIRECT_PATH_ENV_VAR = "GOOGLE_CLOUD_ENABLE_DIRECT_PATH";
    static final long DIRECT_PATH_KEEP_ALIVE_TIME_SECONDS = 3600L;
    static final long DIRECT_PATH_KEEP_ALIVE_TIMEOUT_SECONDS = 20L;
    private final int processorCount;
    private final ExecutorProvider executorProvider;
    private final HeaderProvider headerProvider;
    private final String endpoint;
    private final EnvironmentProvider envProvider;
    @Nullable
    private final GrpcInterceptorProvider interceptorProvider;
    @Nullable
    private final Integer maxInboundMessageSize;
    @Nullable
    private final Integer maxInboundMetadataSize;
    @Nullable
    private final Duration keepAliveTime;
    @Nullable
    private final Duration keepAliveTimeout;
    @Nullable
    private final Boolean keepAliveWithoutCalls;
    @Nullable
    private final Integer poolSize;
    @Nullable
    private final Credentials credentials;
    @Nullable
    private final ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;

    private InstantiatingGrpcChannelProvider(Builder builder) {
        this.processorCount = builder.processorCount;
        this.executorProvider = builder.executorProvider;
        this.headerProvider = builder.headerProvider;
        this.endpoint = builder.endpoint;
        this.envProvider = builder.envProvider;
        this.interceptorProvider = builder.interceptorProvider;
        this.maxInboundMessageSize = builder.maxInboundMessageSize;
        this.maxInboundMetadataSize = builder.maxInboundMetadataSize;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
        this.poolSize = builder.poolSize;
        this.channelConfigurator = builder.channelConfigurator;
        this.credentials = builder.credentials;
    }

    public boolean needsExecutor() {
        return this.executorProvider == null;
    }

    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.toBuilder().setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)executor)).build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers)).build();
    }

    public String getTransportName() {
        return GrpcTransportChannel.getGrpcTransportName();
    }

    public boolean needsEndpoint() {
        return this.endpoint == null;
    }

    public TransportChannelProvider withEndpoint(String endpoint) {
        InstantiatingGrpcChannelProvider.validateEndpoint(endpoint);
        return this.toBuilder().setEndpoint(endpoint).build();
    }

    @BetaApi(value="The surface for customizing pool size is not stable yet and may change in the future.")
    public boolean acceptsPoolSize() {
        return this.poolSize == null;
    }

    @BetaApi(value="The surface for customizing pool size is not stable yet and may change in the future.")
    public TransportChannelProvider withPoolSize(int size) {
        Preconditions.checkState((boolean)this.acceptsPoolSize(), (String)"pool size already set to %s", (Object)this.poolSize);
        return this.toBuilder().setPoolSize(size).build();
    }

    public boolean needsCredentials() {
        return this.credentials == null;
    }

    public TransportChannelProvider withCredentials(Credentials credentials) {
        return this.toBuilder().setCredentials(credentials).build();
    }

    public TransportChannel getTransportChannel() throws IOException {
        if (this.needsExecutor()) {
            throw new IllegalStateException("getTransportChannel() called when needsExecutor() is true");
        }
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        if (this.needsEndpoint()) {
            throw new IllegalStateException("getTransportChannel() called when needsEndpoint() is true");
        }
        return this.createChannel();
    }

    private TransportChannel createChannel() throws IOException {
        ManagedChannel outerChannel;
        if (this.poolSize == null || this.poolSize == 1) {
            outerChannel = this.createSingleChannel();
        } else {
            ImmutableList.Builder channels = ImmutableList.builder();
            for (int i = 0; i < this.poolSize; ++i) {
                channels.add((Object)this.createSingleChannel());
            }
            outerChannel = new ChannelPool((List<ManagedChannel>)channels.build());
        }
        return GrpcTransportChannel.create(outerChannel);
    }

    private boolean isDirectPathEnabled(String serviceAddress) {
        String whiteList = this.envProvider.getenv(DIRECT_PATH_ENV_VAR);
        if (whiteList == null) {
            return false;
        }
        for (String service : whiteList.split(",")) {
            if (service.isEmpty() || !serviceAddress.contains(service)) continue;
            return true;
        }
        return false;
    }

    private ManagedChannel createSingleChannel() throws IOException {
        ManagedChannelBuilder builder;
        ScheduledExecutorService executor = this.executorProvider.getExecutor();
        GrpcHeaderInterceptor headerInterceptor = new GrpcHeaderInterceptor(this.headerProvider.getHeaders());
        GrpcMetadataHandlerInterceptor metadataHandlerInterceptor = new GrpcMetadataHandlerInterceptor();
        int colon = this.endpoint.indexOf(58);
        if (colon < 0) {
            throw new IllegalStateException("invalid endpoint - should have been validated: " + this.endpoint);
        }
        int port = Integer.parseInt(this.endpoint.substring(colon + 1));
        String serviceAddress = this.endpoint.substring(0, colon);
        if (this.isDirectPathEnabled(serviceAddress) && this.credentials instanceof ComputeEngineCredentials) {
            builder = ComputeEngineChannelBuilder.forAddress((String)serviceAddress, (int)port);
            builder.keepAliveTime(3600L, TimeUnit.SECONDS);
            builder.keepAliveTimeout(20L, TimeUnit.SECONDS);
        } else {
            builder = ManagedChannelBuilder.forAddress((String)serviceAddress, (int)port);
        }
        builder = builder.disableServiceConfigLookUp().intercept(new ClientInterceptor[]{new GrpcChannelUUIDInterceptor()}).intercept(new ClientInterceptor[]{headerInterceptor}).intercept(new ClientInterceptor[]{metadataHandlerInterceptor}).userAgent(headerInterceptor.getUserAgentHeader()).executor((Executor)executor);
        if (this.maxInboundMetadataSize != null) {
            builder.maxInboundMetadataSize(this.maxInboundMetadataSize.intValue());
        }
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        if (this.keepAliveTime != null) {
            builder.keepAliveTime(this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveTimeout != null) {
            builder.keepAliveTimeout(this.keepAliveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveWithoutCalls != null) {
            builder.keepAliveWithoutCalls(this.keepAliveWithoutCalls.booleanValue());
        }
        if (this.interceptorProvider != null) {
            builder.intercept(this.interceptorProvider.getInterceptors());
        }
        if (this.channelConfigurator != null) {
            builder = (ManagedChannelBuilder)this.channelConfigurator.apply((Object)builder);
        }
        return builder.build();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Boolean getKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
    public Integer getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static void validateEndpoint(String endpoint) {
        int colon = endpoint.indexOf(58);
        if (colon < 0) {
            throw new IllegalArgumentException(String.format("invalid endpoint, expecting \"<host>:<port>\"", new Object[0]));
        }
        Integer.parseInt(endpoint.substring(colon + 1));
    }

    static class DirectPathEnvironmentProvider
    implements EnvironmentProvider {
        private static DirectPathEnvironmentProvider provider;

        private DirectPathEnvironmentProvider() {
        }

        public static DirectPathEnvironmentProvider getInstance() {
            if (provider == null) {
                provider = new DirectPathEnvironmentProvider();
            }
            return provider;
        }

        @Override
        public String getenv(String env) {
            return System.getenv(env);
        }
    }

    static interface EnvironmentProvider {
        @Nullable
        public String getenv(String var1);
    }

    public static final class Builder {
        private int processorCount;
        private ExecutorProvider executorProvider;
        private HeaderProvider headerProvider;
        private String endpoint;
        private EnvironmentProvider envProvider;
        @Nullable
        private GrpcInterceptorProvider interceptorProvider;
        @Nullable
        private Integer maxInboundMessageSize;
        @Nullable
        private Integer maxInboundMetadataSize;
        @Nullable
        private Duration keepAliveTime;
        @Nullable
        private Duration keepAliveTimeout;
        @Nullable
        private Boolean keepAliveWithoutCalls;
        @Nullable
        private Integer poolSize;
        @Nullable
        private ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
        @Nullable
        private Credentials credentials;

        private Builder() {
            this.processorCount = Runtime.getRuntime().availableProcessors();
            this.envProvider = DirectPathEnvironmentProvider.getInstance();
        }

        private Builder(InstantiatingGrpcChannelProvider provider) {
            this.processorCount = provider.processorCount;
            this.executorProvider = provider.executorProvider;
            this.headerProvider = provider.headerProvider;
            this.endpoint = provider.endpoint;
            this.envProvider = provider.envProvider;
            this.interceptorProvider = provider.interceptorProvider;
            this.maxInboundMessageSize = provider.maxInboundMessageSize;
            this.maxInboundMetadataSize = provider.maxInboundMetadataSize;
            this.keepAliveTime = provider.keepAliveTime;
            this.keepAliveTimeout = provider.keepAliveTimeout;
            this.keepAliveWithoutCalls = provider.keepAliveWithoutCalls;
            this.poolSize = provider.poolSize;
            this.channelConfigurator = provider.channelConfigurator;
            this.credentials = provider.credentials;
        }

        Builder setProcessorCount(int processorCount) {
            this.processorCount = processorCount;
            return this;
        }

        Builder setEnvironmentProvider(EnvironmentProvider envProvider) {
            this.envProvider = envProvider;
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            InstantiatingGrpcChannelProvider.validateEndpoint(endpoint);
            this.endpoint = endpoint;
            return this;
        }

        public Builder setInterceptorProvider(GrpcInterceptorProvider interceptorProvider) {
            this.interceptorProvider = interceptorProvider;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Builder setMaxInboundMessageSize(Integer max) {
            this.maxInboundMessageSize = max;
            return this;
        }

        public Integer getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
        public Builder setMaxInboundMetadataSize(Integer max) {
            this.maxInboundMetadataSize = max;
            return this;
        }

        @BetaApi(value="The surface for maximum metadata size is not stable yet and may change in the future.")
        public Integer getMaxInboundMetadataSize() {
            return this.maxInboundMetadataSize;
        }

        public Builder setKeepAliveTime(Duration duration) {
            this.keepAliveTime = duration;
            return this;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public Builder setKeepAliveTimeout(Duration duration) {
            this.keepAliveTimeout = duration;
            return this;
        }

        public Duration getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public Builder setKeepAliveWithoutCalls(Boolean keepalive) {
            this.keepAliveWithoutCalls = keepalive;
            return this;
        }

        public Boolean getKeepAliveWithoutCalls() {
            return this.keepAliveWithoutCalls;
        }

        public int getPoolSize() {
            if (this.poolSize == null) {
                return 1;
            }
            return this.poolSize;
        }

        public Builder setPoolSize(int poolSize) {
            Preconditions.checkArgument((poolSize > 0 ? 1 : 0) != 0, (Object)"Pool size must be positive");
            this.poolSize = poolSize;
            return this;
        }

        public Builder setChannelsPerCpu(double multiplier) {
            return this.setChannelsPerCpu(multiplier, 100);
        }

        public Builder setChannelsPerCpu(double multiplier, int maxChannels) {
            Preconditions.checkArgument((multiplier > 0.0 ? 1 : 0) != 0, (Object)"multiplier must be positive");
            Preconditions.checkArgument((maxChannels > 0 ? 1 : 0) != 0, (Object)"maxChannels must be positive");
            int channelCount = (int)Math.ceil((double)this.processorCount * multiplier);
            if (channelCount > maxChannels) {
                channelCount = maxChannels;
            }
            return this.setPoolSize(channelCount);
        }

        public Builder setCredentials(Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public InstantiatingGrpcChannelProvider build() {
            return new InstantiatingGrpcChannelProvider(this);
        }

        @BetaApi(value="Surface for advanced channel configuration is not yet stable")
        public Builder setChannelConfigurator(@Nullable ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator) {
            this.channelConfigurator = channelConfigurator;
            return this;
        }

        @Nullable
        public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator() {
            return this.channelConfigurator;
        }
    }
}

