/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ApiStreamObserverDelegate;
import com.google.api.gax.grpc.GrpcClientCalls;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.common.base.Preconditions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.stub.ClientCalls;
import java.util.Iterator;

class GrpcDirectServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> descriptor;

    GrpcDirectServerStreamingCallable(MethodDescriptor<RequestT, ResponseT> descriptor) {
        this.descriptor = (MethodDescriptor)Preconditions.checkNotNull(descriptor);
    }

    public void serverStreamingCall(RequestT request, ApiStreamObserver<ResponseT> responseObserver, ApiCallContext context) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(responseObserver);
        ClientCall<RequestT, ResponseT> call = GrpcClientCalls.newCall(this.descriptor, context);
        ClientCalls.asyncServerStreamingCall(call, request, new ApiStreamObserverDelegate<ResponseT>(responseObserver));
    }

    public Iterator<ResponseT> blockingServerStreamingCall(RequestT request, ApiCallContext context) {
        Preconditions.checkNotNull(request);
        ClientCall<RequestT, ResponseT> call = GrpcClientCalls.newCall(this.descriptor, context);
        return ClientCalls.blockingServerStreamingCall(call, request);
    }
}

