/*
 * Decompiled with CFR 0.152.
 */
package com.google.longrunning;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.GrpcExtraHeaderData;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.DeleteOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.ListOperationsRequest;
import com.google.longrunning.ListOperationsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.PagedResponseWrappers;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class OperationsSettings
extends ClientSettings<OperationsSettings> {
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/longrunning/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final UnaryCallSettings<GetOperationRequest, Operation> getOperationSettings;
    private final PagedCallSettings<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings;
    private final UnaryCallSettings<CancelOperationRequest, Empty> cancelOperationSettings;
    private final UnaryCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings;
    private static final PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation> LIST_OPERATIONS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> LIST_OPERATIONS_PAGE_STR_FACT;

    public UnaryCallSettings<GetOperationRequest, Operation> getOperationSettings() {
        return this.getOperationSettings;
    }

    public PagedCallSettings<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings() {
        return this.listOperationsSettings;
    }

    public UnaryCallSettings<CancelOperationRequest, Empty> cancelOperationSettings() {
        return this.cancelOperationSettings;
    }

    public UnaryCallSettings<DeleteOperationRequest, Empty> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public OperationsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcOperationsStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratorHeader(DEFAULT_GAPIC_NAME, OperationsSettings.getGapicVersion()).setApiClientHeaderLineKey("x-goog-api-client").addApiClientHeaderLineData(GrpcExtraHeaderData.getXGoogApiClientData());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(OperationsSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    @Deprecated
    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    @Deprecated
    public static Builder defaultBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private OperationsSettings(Builder settingsBuilder) throws IOException {
        super((ClientSettings.Builder)settingsBuilder);
        this.getOperationSettings = settingsBuilder.getOperationSettings().build();
        this.listOperationsSettings = settingsBuilder.listOperationsSettings().build();
        this.cancelOperationSettings = settingsBuilder.cancelOperationSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
    }

    static {
        LIST_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListOperationsRequest, ListOperationsResponse, Operation>(){

            public String emptyToken() {
                return OperationsSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListOperationsRequest injectToken(ListOperationsRequest payload, String token) {
                return ListOperationsRequest.newBuilder((ListOperationsRequest)payload).setPageToken(token).build();
            }

            public ListOperationsRequest injectPageSize(ListOperationsRequest payload, int pageSize) {
                return ListOperationsRequest.newBuilder((ListOperationsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListOperationsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListOperationsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<Operation> extractResources(ListOperationsResponse payload) {
                return payload.getOperationsList();
            }
        };
        LIST_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListOperationsRequest, ListOperationsResponse> callable, ListOperationsRequest request, ApiCallContext context, ApiFuture<ListOperationsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListOperationsPagedResponse.createAsync((PageContext<ListOperationsRequest, ListOperationsResponse, Operation>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder<OperationsSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings;
        private final PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings;
        private final UnaryCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings;
        private final UnaryCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.getOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_OPERATIONS_PAGE_STR_FACT);
            this.cancelOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperationSettings, this.listOperationsSettings, this.cancelOperationSettings, this.deleteOperationSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.cancelOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(OperationsSettings settings) {
            super((ClientSettings)settings);
            this.getOperationSettings = settings.getOperationSettings.toBuilder();
            this.listOperationsSettings = settings.listOperationsSettings.toBuilder();
            this.cancelOperationSettings = settings.cancelOperationSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getOperationSettings, this.listOperationsSettings, this.cancelOperationSettings, this.deleteOperationSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            ClientSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public UnaryCallSettings.Builder<GetOperationRequest, Operation> getOperationSettings() {
            return this.getOperationSettings;
        }

        public PagedCallSettings.Builder<ListOperationsRequest, ListOperationsResponse, PagedResponseWrappers.ListOperationsPagedResponse> listOperationsSettings() {
            return this.listOperationsSettings;
        }

        public UnaryCallSettings.Builder<CancelOperationRequest, Empty> cancelOperationSettings() {
            return this.cancelOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteOperationRequest, Empty> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public OperationsSettings build() throws IOException {
            return new OperationsSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)90000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)90000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

