/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.grpc.GrpcHeaderInterceptor;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

@BetaApi
public final class InstantiatingGrpcChannelProvider
implements TransportChannelProvider {
    private final ExecutorProvider executorProvider;
    private final HeaderProvider headerProvider;
    private final String serviceAddress;
    private final int port;
    @Nullable
    private final Integer maxInboundMessageSize;
    @Nullable
    private final Duration keepAliveTime;
    @Nullable
    private final Duration keepAliveTimeout;
    @Nullable
    private final Boolean keepAliveWithoutCalls;

    private InstantiatingGrpcChannelProvider(Builder builder) {
        this.executorProvider = builder.executorProvider;
        this.headerProvider = builder.headerProvider;
        this.serviceAddress = builder.serviceAddress;
        this.port = builder.port;
        this.maxInboundMessageSize = builder.maxInboundMessageSize;
        this.keepAliveTime = builder.keepAliveTime;
        this.keepAliveTimeout = builder.keepAliveTimeout;
        this.keepAliveWithoutCalls = builder.keepAliveWithoutCalls;
    }

    public boolean needsExecutor() {
        return this.executorProvider == null;
    }

    public TransportChannelProvider withExecutor(ScheduledExecutorService executor) {
        return this.toBuilder().setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)executor)).build();
    }

    public boolean needsHeaders() {
        return this.headerProvider == null;
    }

    public TransportChannelProvider withHeaders(Map<String, String> headers) {
        return this.toBuilder().setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers)).build();
    }

    public String getTransportName() {
        return GrpcTransportChannel.getGrpcTransportName();
    }

    public TransportChannel getTransportChannel() throws IOException {
        if (this.needsExecutor()) {
            throw new IllegalStateException("getTransportChannel() called when needsExecutor() is true");
        }
        if (this.needsHeaders()) {
            throw new IllegalStateException("getTransportChannel() called when needsHeaders() is true");
        }
        return this.createChannel();
    }

    private TransportChannel createChannel() throws IOException {
        ScheduledExecutorService executor = this.executorProvider.getExecutor();
        Map headers = this.headerProvider.getHeaders();
        ArrayList<GrpcHeaderInterceptor> interceptors = new ArrayList<GrpcHeaderInterceptor>();
        interceptors.add(new GrpcHeaderInterceptor(headers));
        ManagedChannelBuilder builder = ManagedChannelBuilder.forAddress((String)this.serviceAddress, (int)this.port).intercept(interceptors).executor((Executor)executor);
        if (this.maxInboundMessageSize != null) {
            builder.maxInboundMessageSize(this.maxInboundMessageSize.intValue());
        }
        if (this.keepAliveTime != null) {
            builder.keepAliveTime(this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveTimeout != null) {
            builder.keepAliveTimeout(this.keepAliveTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.keepAliveWithoutCalls != null) {
            builder.keepAliveWithoutCalls(this.keepAliveWithoutCalls.booleanValue());
        }
        return GrpcTransportChannel.newBuilder().setManagedChannel(builder.build()).build();
    }

    public String getEndpoint() {
        return this.serviceAddress + ':' + this.port;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public Boolean getKeepAliveWithoutCalls() {
        return this.keepAliveWithoutCalls;
    }

    public boolean shouldAutoClose() {
        return true;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ExecutorProvider executorProvider;
        private HeaderProvider headerProvider;
        private String serviceAddress;
        private int port;
        @Nullable
        private Integer maxInboundMessageSize;
        @Nullable
        private Duration keepAliveTime;
        @Nullable
        private Duration keepAliveTimeout;
        @Nullable
        private Boolean keepAliveWithoutCalls;

        private Builder() {
        }

        private Builder(InstantiatingGrpcChannelProvider provider) {
            this.executorProvider = provider.executorProvider;
            this.headerProvider = provider.headerProvider;
            this.serviceAddress = provider.serviceAddress;
            this.port = provider.port;
            this.maxInboundMessageSize = provider.maxInboundMessageSize;
            this.keepAliveTime = provider.keepAliveTime;
            this.keepAliveTimeout = provider.keepAliveTimeout;
            this.keepAliveWithoutCalls = provider.keepAliveWithoutCalls;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = executorProvider;
            return this;
        }

        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            this.headerProvider = headerProvider;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            int colon = endpoint.indexOf(58);
            if (colon < 0) {
                throw new IllegalArgumentException(String.format("invalid endpoint, expecting \"<host>:<port>\"", new Object[0]));
            }
            this.port = Integer.parseInt(endpoint.substring(colon + 1));
            this.serviceAddress = endpoint.substring(0, colon);
            return this;
        }

        public String getEndpoint() {
            return this.serviceAddress + ':' + this.port;
        }

        public Builder setMaxInboundMessageSize(Integer max) {
            this.maxInboundMessageSize = max;
            return this;
        }

        public Integer getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        public Builder setKeepAliveTime(Duration duration) {
            this.keepAliveTime = duration;
            return this;
        }

        public Duration getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public Builder setKeepAliveTimeout(Duration duration) {
            this.keepAliveTimeout = duration;
            return this;
        }

        public Duration getKeepAliveTimeout() {
            return this.keepAliveTimeout;
        }

        public Builder setKeepAliveWithoutCalls(Boolean keepalive) {
            this.keepAliveWithoutCalls = keepalive;
            return this;
        }

        public Boolean getKeepAliveWithoutCalls() {
            return this.keepAliveWithoutCalls;
        }

        public InstantiatingGrpcChannelProvider build() {
            return new InstantiatingGrpcChannelProvider(this);
        }
    }
}

