/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.AbortedException;
import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.CancelledException;
import com.google.api.gax.rpc.DataLossException;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.FailedPreconditionException;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.NotFoundException;
import com.google.api.gax.rpc.OutOfRangeException;
import com.google.api.gax.rpc.PermissionDeniedException;
import com.google.api.gax.rpc.ResourceExhaustedException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnauthenticatedException;
import com.google.api.gax.rpc.UnavailableException;
import com.google.api.gax.rpc.UnknownException;
import io.grpc.Status;

@BetaApi
public class GrpcApiExceptionFactory {
    @BetaApi
    public static ApiException createException(Throwable cause, Status.Code statusCode, boolean retryable) {
        GrpcStatusCode grpcStatusCode = GrpcStatusCode.of(statusCode);
        switch (statusCode) {
            case CANCELLED: {
                return new CancelledException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case NOT_FOUND: {
                return new NotFoundException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case UNKNOWN: {
                return new UnknownException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case INVALID_ARGUMENT: {
                return new InvalidArgumentException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case DEADLINE_EXCEEDED: {
                return new DeadlineExceededException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case ALREADY_EXISTS: {
                return new AlreadyExistsException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case PERMISSION_DENIED: {
                return new PermissionDeniedException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case RESOURCE_EXHAUSTED: {
                return new ResourceExhaustedException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case FAILED_PRECONDITION: {
                return new FailedPreconditionException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case ABORTED: {
                return new AbortedException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case OUT_OF_RANGE: {
                return new OutOfRangeException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case INTERNAL: {
                return new InternalException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case UNAVAILABLE: {
                return new UnavailableException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case DATA_LOSS: {
                return new DataLossException(cause, (StatusCode)grpcStatusCode, retryable);
            }
            case UNAUTHENTICATED: {
                return new UnauthenticatedException(cause, (StatusCode)grpcStatusCode, retryable);
            }
        }
        return new ApiException(cause, (StatusCode)grpcStatusCode, retryable);
    }

    @BetaApi
    public static ApiException createException(String message, Throwable cause, Status.Code statusCode, boolean retryable) {
        GrpcStatusCode grpcStatusCode = GrpcStatusCode.of(statusCode);
        switch (statusCode) {
            case CANCELLED: {
                return new CancelledException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case NOT_FOUND: {
                return new NotFoundException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case UNKNOWN: {
                return new UnknownException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case INVALID_ARGUMENT: {
                return new InvalidArgumentException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case DEADLINE_EXCEEDED: {
                return new DeadlineExceededException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case ALREADY_EXISTS: {
                return new AlreadyExistsException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case PERMISSION_DENIED: {
                return new PermissionDeniedException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case RESOURCE_EXHAUSTED: {
                return new ResourceExhaustedException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case FAILED_PRECONDITION: {
                return new FailedPreconditionException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case ABORTED: {
                return new AbortedException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case OUT_OF_RANGE: {
                return new OutOfRangeException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case INTERNAL: {
                return new InternalException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case UNAVAILABLE: {
                return new UnavailableException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case DATA_LOSS: {
                return new DataLossException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
            case UNAUTHENTICATED: {
                return new UnauthenticatedException(message, cause, (StatusCode)grpcStatusCode, retryable);
            }
        }
        return new ApiException(cause, (StatusCode)grpcStatusCode, retryable);
    }
}

