/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.grpc.ChannelAsBackgroundResource;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.rpc.TransportProvider;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class GrpcTransportProvider
implements TransportProvider {
    private final ChannelProvider channelProvider;

    protected GrpcTransportProvider(ChannelProvider channelProvider) {
        this.channelProvider = (ChannelProvider)Preconditions.checkNotNull((Object)channelProvider);
    }

    public final ChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("channelProvider", (Object)this.channelProvider).toString();
    }

    public boolean needsExecutor() {
        return this.channelProvider.needsExecutor();
    }

    public GrpcTransport getTransport() throws IOException {
        ManagedChannel channel = this.channelProvider.getChannel();
        return GrpcTransport.newBuilder().setChannel((Channel)channel).setBackgroundResources((List<BackgroundResource>)this.getBackgroundResourcesFor(channel)).build();
    }

    public GrpcTransport getTransport(ScheduledExecutorService executor) throws IOException {
        ManagedChannel channel = this.channelProvider.getChannel(executor);
        return GrpcTransport.newBuilder().setChannel((Channel)channel).setBackgroundResources((List<BackgroundResource>)this.getBackgroundResourcesFor(channel)).build();
    }

    public String getTransportName() {
        return GrpcTransport.getGrpcTransportName();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ImmutableList<BackgroundResource> getBackgroundResourcesFor(ManagedChannel channel) {
        ImmutableList.Builder backgroundResources = ImmutableList.builder();
        if (this.channelProvider.shouldAutoClose()) {
            backgroundResources.add((Object)new ChannelAsBackgroundResource(channel));
        }
        return backgroundResources.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ChannelProvider channelProvider;

        protected Builder() {
        }

        protected Builder(GrpcTransportProvider transportProvider) {
            this.channelProvider = transportProvider.channelProvider;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            this.channelProvider = channelProvider;
            return this;
        }

        public ChannelProvider getChannelProvider() {
            return this.channelProvider;
        }

        public GrpcTransportProvider build() {
            return new GrpcTransportProvider(this.channelProvider);
        }
    }
}

