/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcApiExceptionFactory;
import com.google.api.gax.grpc.GrpcOperationFuture;
import com.google.api.gax.grpc.GrpcRetryingCallable;
import com.google.api.gax.grpc.OperationCheckingCallable;
import com.google.api.gax.retrying.RetryingExecutor;
import com.google.api.gax.retrying.RetryingFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import com.google.longrunning.CancelOperationRequest;
import com.google.longrunning.GetOperationRequest;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.Status;

class GrpcOperationCallableImpl<RequestT, ResponseT extends Message, MetadataT extends Message>
extends OperationCallable<RequestT, ResponseT, MetadataT, Operation> {
    private final UnaryCallable<RequestT, Operation> initialCallable;
    private final ClientContext clientContext;
    private final RetryingExecutor<Operation> executor;
    private final OperationsStub operationsStub;
    private final ApiFunction<Operation, ResponseT> responseTransformer;
    private final ApiFunction<Operation, MetadataT> metadataTransformer;

    GrpcOperationCallableImpl(UnaryCallable<RequestT, Operation> initialCallable, ClientContext clientContext, RetryingExecutor<Operation> executor, OperationsStub operationsStub, OperationCallSettings<RequestT, ResponseT, MetadataT, Operation> operationCallSettings) {
        this.initialCallable = (UnaryCallable)Preconditions.checkNotNull(initialCallable);
        this.clientContext = (ClientContext)Preconditions.checkNotNull((Object)clientContext);
        this.executor = (RetryingExecutor)Preconditions.checkNotNull(executor);
        this.operationsStub = (OperationsStub)Preconditions.checkNotNull((Object)operationsStub);
        this.responseTransformer = new ResponseTransformer(new AnyTransformer(operationCallSettings.getResponseClass()));
        this.metadataTransformer = new MetadataTransformer(new AnyTransformer(operationCallSettings.getMetadataClass()));
    }

    public GrpcOperationFuture<ResponseT, MetadataT> futureCall(RequestT request, ApiCallContext context) {
        return this.futureCall((ApiFuture<Operation>)this.initialCallable.futureCall(request, context));
    }

    GrpcOperationFuture<ResponseT, MetadataT> futureCall(ApiFuture<Operation> initialFuture) {
        GrpcRetryingCallable<Object, Operation> callable = new GrpcRetryingCallable<Object, Operation>(new OperationCheckingCallable(this.operationsStub.getOperationCallable(), initialFuture), this.executor);
        RetryingFuture<Operation> pollingFuture = callable.futureCall((Object)null, (ApiCallContext)null);
        return new GrpcOperationFuture<ResponseT, MetadataT>(pollingFuture, initialFuture, this.responseTransformer, this.metadataTransformer);
    }

    public GrpcOperationFuture<ResponseT, MetadataT> resumeFutureCall(String operationName, ApiCallContext context) {
        GetOperationRequest request = GetOperationRequest.newBuilder().setName(operationName).build();
        ApiFuture getOperationFuture = this.operationsStub.getOperationCallable().futureCall((Object)request, context);
        return this.futureCall((ApiFuture<Operation>)getOperationFuture);
    }

    public ApiFuture<Void> cancel(String operationName, ApiCallContext context) {
        CancelOperationRequest cancelRequest = CancelOperationRequest.newBuilder().setName(operationName).build();
        return ApiFutures.transform((ApiFuture)this.operationsStub.cancelOperationCallable().futureCall((Object)cancelRequest, context), (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    static class AnyTransformer<PackedT extends Message>
    implements ApiFunction<Any, PackedT> {
        private final Class<PackedT> packedClass;

        public AnyTransformer(Class<PackedT> packedClass) {
            this.packedClass = packedClass;
        }

        public PackedT apply(Any input) {
            try {
                return (PackedT)(input == null || this.packedClass == null ? null : input.unpack(this.packedClass));
            }
            catch (InvalidProtocolBufferException | ClassCastException e) {
                throw new IllegalStateException("Failed to unpack object from 'any' field. Expected " + this.packedClass.getName() + ", found " + input.getTypeUrl());
            }
        }
    }

    static class MetadataTransformer<MetadataT extends Message>
    implements ApiFunction<Operation, MetadataT> {
        private final AnyTransformer<MetadataT> transformer;

        public MetadataTransformer(AnyTransformer<MetadataT> transformer) {
            this.transformer = transformer;
        }

        public MetadataT apply(Operation input) {
            try {
                return this.transformer.apply(input.hasMetadata() ? input.getMetadata() : null);
            }
            catch (RuntimeException e) {
                throw GrpcApiExceptionFactory.createException("Polling operation with name \"" + input.getName() + "\" succeeded, but encountered a problem unpacking it.", e, Status.fromCodeValue((int)input.getError().getCode()).getCode(), false);
            }
        }
    }

    static class ResponseTransformer<ResponseT extends Message>
    implements ApiFunction<Operation, ResponseT> {
        private final AnyTransformer<ResponseT> transformer;

        public ResponseTransformer(AnyTransformer<ResponseT> transformer) {
            this.transformer = transformer;
        }

        public ResponseT apply(Operation input) {
            Status status = Status.fromCodeValue((int)input.getError().getCode());
            if (!status.equals((Object)Status.OK)) {
                throw GrpcApiExceptionFactory.createException("Operation with name \"" + input.getName() + "\" failed with status = " + status, null, status.getCode(), false);
            }
            try {
                return this.transformer.apply(input.getResponse());
            }
            catch (RuntimeException e) {
                throw GrpcApiExceptionFactory.createException("Operation with name \"" + input.getName() + "\" succeeded, but encountered a problem unpacking it.", e, status.getCode(), false);
            }
        }
    }
}

