/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiCallContextEnhancer;
import com.google.auth.Credentials;
import com.google.common.base.Preconditions;
import io.grpc.CallCredentials;
import io.grpc.auth.MoreCallCredentials;

class GrpcAuthCallContextEnhancer
implements ApiCallContextEnhancer {
    private final CallCredentials credentials;

    public GrpcAuthCallContextEnhancer(Credentials credentials) {
        this.credentials = MoreCallCredentials.from((Credentials)((Credentials)Preconditions.checkNotNull((Object)credentials)));
    }

    public GrpcCallContext enhance(ApiCallContext inputContext) {
        GrpcCallContext context = GrpcCallContext.getAsGrpcCallContextWithDefault(inputContext);
        if (context.getCallOptions().getCredentials() == null) {
            context = context.withCallOptions(context.getCallOptions().withCallCredentials(this.credentials));
        }
        return context;
    }
}

