/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.ListenableFutureToApiFuture;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ClientCallFactory;
import com.google.api.gax.grpc.FutureCallable;
import com.google.common.base.Preconditions;
import io.grpc.stub.ClientCalls;

class DirectCallable<RequestT, ResponseT>
implements FutureCallable<RequestT, ResponseT> {
    private final ClientCallFactory<RequestT, ResponseT> factory;

    DirectCallable(ClientCallFactory<RequestT, ResponseT> factory) {
        Preconditions.checkNotNull(factory);
        this.factory = factory;
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, CallContext context) {
        Preconditions.checkNotNull(request);
        return new ListenableFutureToApiFuture(ClientCalls.futureUnaryCall(this.factory.newCall(context.getChannel(), context.getCallOptions()), request));
    }

    public String toString() {
        return String.format("direct(%s)", this.factory);
    }
}

