/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.grpc.ApiException;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.TimedAttemptSettings;
import io.grpc.Status;
import org.threeten.bp.Duration;

class ApiResultRetryAlgorithm<ResponseT>
implements ResultRetryAlgorithm<ResponseT> {
    public static final Duration DEADLINE_SLEEP_DURATION = Duration.ofMillis((long)1L);

    ApiResultRetryAlgorithm() {
    }

    public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, ResponseT prevResponse, TimedAttemptSettings prevSettings) {
        if (prevThrowable != null && ((ApiException)prevThrowable).getStatusCode() == Status.Code.DEADLINE_EXCEEDED) {
            return new TimedAttemptSettings(prevSettings.getGlobalSettings(), prevSettings.getRetryDelay(), prevSettings.getRpcTimeout(), DEADLINE_SLEEP_DURATION, prevSettings.getAttemptCount() + 1, prevSettings.getFirstAttemptStartTimeNanos());
        }
        return null;
    }

    public boolean shouldRetry(Throwable prevThrowable, ResponseT prevResponse) {
        return prevThrowable instanceof ApiException && ((ApiException)prevThrowable).isRetryable();
    }
}

