/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.UnaryCallSettingsTyped;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.retrying.RetrySettings;
import com.google.common.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public final class SimpleCallSettings<RequestT, ResponseT>
extends UnaryCallSettingsTyped<RequestT, ResponseT> {
    UnaryCallable<RequestT, ResponseT> create(Channel channel, ScheduledExecutorService executor) {
        return this.createBaseCallable(channel, executor);
    }

    private SimpleCallSettings(ImmutableSet<Status.Code> retryableCodes, RetrySettings retrySettings, MethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        super(retryableCodes, retrySettings, methodDescriptor);
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor) {
        return new Builder<RequestT, ResponseT>(grpcMethodDescriptor);
    }

    @Override
    public final Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<RequestT, ResponseT>
    extends UnaryCallSettingsTyped.Builder<RequestT, ResponseT> {
        public Builder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor) {
            super(grpcMethodDescriptor);
        }

        public Builder(SimpleCallSettings<RequestT, ResponseT> settings) {
            super(settings);
        }

        @Override
        public Builder<RequestT, ResponseT> setRetryableCodes(Set<Status.Code> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT> setRetryableCodes(Status.Code ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT> setRetrySettingsBuilder(RetrySettings.Builder retrySettingsBuilder) {
            super.setRetrySettingsBuilder(retrySettingsBuilder);
            return this;
        }

        @Override
        public SimpleCallSettings<RequestT, ResponseT> build() {
            return new SimpleCallSettings(ImmutableSet.copyOf(this.getRetryableCodes()), this.getRetrySettingsBuilder().build(), this.getMethodDescriptor());
        }
    }
}

