/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.FutureCallable;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.common.base.Preconditions;

class PagedCallable<RequestT, ResponseT, PagedListResponseT>
implements FutureCallable<RequestT, PagedListResponseT> {
    private final FutureCallable<RequestT, ResponseT> callable;
    private final PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory;

    PagedCallable(FutureCallable<RequestT, ResponseT> callable, PagedListResponseFactory<RequestT, ResponseT, PagedListResponseT> pagedListResponseFactory) {
        this.callable = (FutureCallable)Preconditions.checkNotNull(callable);
        this.pagedListResponseFactory = pagedListResponseFactory;
    }

    public String toString() {
        return String.format("paged(%s)", this.callable);
    }

    @Override
    public ApiFuture<PagedListResponseT> futureCall(RequestT request, CallContext context) {
        ApiFuture<ResponseT> futureResponse = this.callable.futureCall(request, context);
        return this.pagedListResponseFactory.getFuturePagedResponse(UnaryCallable.create(this.callable), request, context, futureResponse);
    }
}

