/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.grpc;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.grpc.BatcherFactory;
import com.google.api.gax.grpc.BatchingDescriptor;
import com.google.api.gax.grpc.UnaryCallSettingsTyped;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.retrying.RetrySettings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public final class BatchingCallSettings<RequestT, ResponseT>
extends UnaryCallSettingsTyped<RequestT, ResponseT> {
    private final BatchingDescriptor<RequestT, ResponseT> batchingDescriptor;
    private final BatchingSettings batchingSettings;
    private BatcherFactory<RequestT, ResponseT> batcherFactory;

    UnaryCallable<RequestT, ResponseT> create(Channel channel, ScheduledExecutorService executor) {
        UnaryCallable<RequestT, ResponseT> baseCallable = this.createBaseCallable(channel, executor);
        this.batcherFactory = new BatcherFactory<RequestT, ResponseT>(this.batchingDescriptor, this.batchingSettings, executor);
        return baseCallable.batching(this.batchingDescriptor, this.batcherFactory);
    }

    public BatcherFactory<RequestT, ResponseT> getBatcherFactory() {
        return this.batcherFactory;
    }

    private BatchingCallSettings(ImmutableSet<Status.Code> retryableCodes, RetrySettings retrySettings, MethodDescriptor<RequestT, ResponseT> methodDescriptor, BatchingDescriptor<RequestT, ResponseT> batchingDescriptor, BatchingSettings batchingSettings) {
        super(retryableCodes, retrySettings, methodDescriptor);
        this.batchingDescriptor = batchingDescriptor;
        this.batchingSettings = batchingSettings;
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor, BatchingDescriptor<RequestT, ResponseT> batchingDescriptor) {
        return new Builder<RequestT, ResponseT>(grpcMethodDescriptor, batchingDescriptor);
    }

    @Override
    public final Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public static class Builder<RequestT, ResponseT>
    extends UnaryCallSettingsTyped.Builder<RequestT, ResponseT> {
        private BatchingDescriptor<RequestT, ResponseT> batchingDescriptor;
        private BatchingSettings.Builder batchingSettingsBuilder;

        public Builder(MethodDescriptor<RequestT, ResponseT> grpcMethodDescriptor, BatchingDescriptor<RequestT, ResponseT> batchingDescriptor) {
            super(grpcMethodDescriptor);
            this.batchingDescriptor = batchingDescriptor;
            this.batchingSettingsBuilder = BatchingSettings.newBuilder();
        }

        public Builder(BatchingCallSettings<RequestT, ResponseT> settings) {
            super(settings);
            this.batchingDescriptor = ((BatchingCallSettings)settings).batchingDescriptor;
            this.batchingSettingsBuilder = ((BatchingCallSettings)settings).batchingSettings.toBuilder();
        }

        public BatchingDescriptor<RequestT, ResponseT> getBatchingDescriptor() {
            return this.batchingDescriptor;
        }

        public Builder<RequestT, ResponseT> setBatchingSettingsBuilder(BatchingSettings.Builder batchingSettingsBuilder) {
            this.batchingSettingsBuilder = (BatchingSettings.Builder)Preconditions.checkNotNull((Object)batchingSettingsBuilder);
            return this;
        }

        public BatchingSettings.Builder getBatchingSettingsBuilder() {
            return this.batchingSettingsBuilder;
        }

        @Override
        public Builder<RequestT, ResponseT> setRetryableCodes(Set<Status.Code> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT> setRetryableCodes(Status.Code ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        @Override
        public Builder<RequestT, ResponseT> setRetrySettingsBuilder(RetrySettings.Builder retrySettingsBuilder) {
            super.setRetrySettingsBuilder(retrySettingsBuilder);
            return this;
        }

        @Override
        public BatchingCallSettings<RequestT, ResponseT> build() {
            return new BatchingCallSettings(ImmutableSet.copyOf(this.getRetryableCodes()), this.getRetrySettingsBuilder().build(), this.getMethodDescriptor(), this.batchingDescriptor, this.batchingSettingsBuilder.build());
        }
    }
}

