/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.common;

import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.EmptyLineStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.LineComment;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.PrimitiveValue;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.TryCatchStatement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.common.ClassComposer;
import com.google.api.generator.gapic.composer.common.TransportContext;
import com.google.api.generator.gapic.composer.defaultvalue.DefaultValueComposer;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.composer.utils.ClassNames;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.MethodArgument;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractServiceClientTestClassComposer
implements ClassComposer {
    protected static final Statement EMPTY_LINE_STATEMENT = EmptyLineStatement.create();
    protected static final String CLIENT_VAR_NAME = "client";
    private static final String MOCK_SERVICE_VAR_NAME_PATTERN = "mock%s";
    protected static final TypeStore FIXED_TYPESTORE = AbstractServiceClientTestClassComposer.createStaticTypes();
    protected static final AnnotationNode TEST_ANNOTATION = AnnotationNode.withType(FIXED_TYPESTORE.get("Test"));
    private final TransportContext transportContext;

    protected AbstractServiceClientTestClassComposer(TransportContext transportContext) {
        this.transportContext = transportContext;
    }

    public TransportContext getTransportContext() {
        return this.transportContext;
    }

    @Override
    public GapicClass generate(GapicContext context, Service service) {
        return this.generate(ClassNames.getServiceClientTestClassName(service), context, service);
    }

    protected GapicClass generate(String className, GapicContext context, Service service) {
        if (!service.hasAnyEnabledMethodsForTransport(this.getTransportContext().transport())) {
            return GapicClass.createNonGeneratedGapicClass();
        }
        ImmutableMap<String, ResourceName> resourceNames = context.helperResourceNames();
        String pakkage = service.pakkage();
        TypeStore typeStore = new TypeStore();
        this.addDynamicTypes(context, service, typeStore);
        GapicClass.Kind kind = GapicClass.Kind.MAIN;
        Map<String, VariableExpr> classMemberVarExprs = this.createClassMemberVarExprs(service, context, typeStore);
        ClassDefinition classDef = ClassDefinition.builder().setPackageString(pakkage).setAnnotations(this.createClassAnnotations()).setScope(ScopeNode.PUBLIC).setName(className).setStatements(this.createClassMemberFieldDecls(classMemberVarExprs)).setMethods(this.createClassMethods(service, context, classMemberVarExprs, typeStore, resourceNames)).build();
        return GapicClass.create(kind, classDef);
    }

    private List<AnnotationNode> createClassAnnotations() {
        return Arrays.asList(AnnotationNode.builder().setType(FIXED_TYPESTORE.get("Generated")).setDescription("by gapic-generator-java").build());
    }

    protected abstract Map<String, VariableExpr> createClassMemberVarExprs(Service var1, GapicContext var2, TypeStore var3);

    protected List<Statement> createClassMemberFieldDecls(Map<String, VariableExpr> classMemberVarExprs) {
        Function<VariableExpr, Boolean> isMockVarExprFn = v -> v.type().reference().name().startsWith("Mock");
        ArrayList<Statement> fieldDeclStatements = new ArrayList<Statement>();
        fieldDeclStatements.addAll(classMemberVarExprs.values().stream().filter(v -> (Boolean)isMockVarExprFn.apply((VariableExpr)v)).map(v -> ExprStatement.withExpr(v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsStatic(true).build())).collect(Collectors.toList()));
        fieldDeclStatements.addAll(classMemberVarExprs.values().stream().filter(v -> (Boolean)isMockVarExprFn.apply((VariableExpr)v) == false).map(v -> ExprStatement.withExpr(v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).build())).collect(Collectors.toList()));
        return fieldDeclStatements;
    }

    private List<MethodDefinition> createClassMethods(Service service, GapicContext context, Map<String, VariableExpr> classMemberVarExprs, TypeStore typeStore, Map<String, ResourceName> resourceNames) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.addAll(this.createTestAdminMethods(service, context, classMemberVarExprs, typeStore));
        javaMethods.addAll(this.createTestMethods(service, context, classMemberVarExprs, resourceNames));
        return javaMethods;
    }

    private List<MethodDefinition> createTestAdminMethods(Service service, GapicContext context, Map<String, VariableExpr> classMemberVarExprs, TypeStore typeStore) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.add(this.createStartStaticServerMethod(service, context, classMemberVarExprs, typeStore, "newBuilder"));
        javaMethods.add(this.createStopServerMethod(service, classMemberVarExprs));
        javaMethods.add(this.createSetUpMethod(service, classMemberVarExprs, typeStore));
        javaMethods.add(this.createTearDownMethod(service, classMemberVarExprs));
        return javaMethods;
    }

    protected abstract MethodDefinition createStartStaticServerMethod(Service var1, GapicContext var2, Map<String, VariableExpr> var3, TypeStore var4, String var5);

    protected abstract MethodDefinition createStopServerMethod(Service var1, Map<String, VariableExpr> var2);

    protected abstract MethodDefinition createSetUpMethod(Service var1, Map<String, VariableExpr> var2, TypeStore var3);

    protected abstract MethodDefinition createTearDownMethod(Service var1, Map<String, VariableExpr> var2);

    private List<MethodDefinition> createTestMethods(Service service, GapicContext context, Map<String, VariableExpr> classMemberVarExprs, Map<String, ResourceName> resourceNames) {
        ImmutableMap<String, Message> messageTypes = context.messages();
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        for (Method method : service.methods()) {
            if (!method.isSupportedByTransport(this.getTransportContext().transport())) {
                javaMethods.add(this.createUnsupportedTestMethod(method));
                continue;
            }
            Service matchingService = service;
            if (method.isMixin()) {
                int dotIndex = method.mixedInApiName().lastIndexOf(".");
                String mixinServiceName = method.mixedInApiName().substring(dotIndex + 1);
                String mixinServiceProtoPackage = method.mixedInApiName().substring(0, dotIndex);
                Optional<Service> mixinServiceOpt = context.mixinServices().stream().filter(s -> s.name().equals(mixinServiceName) && s.protoPakkage().equals(mixinServiceProtoPackage)).findFirst();
                if (mixinServiceOpt.isPresent()) {
                    matchingService = mixinServiceOpt.get();
                }
            }
            if (method.methodSignatures().isEmpty() || !method.stream().equals((Object)Method.Stream.NONE)) {
                javaMethods.add(this.createRpcTestMethod(method, service, matchingService, Collections.emptyList(), 0, true, classMemberVarExprs, resourceNames, messageTypes));
                javaMethods.add(this.createRpcExceptionTestMethod(method, matchingService, Collections.emptyList(), 0, classMemberVarExprs, resourceNames, messageTypes));
                continue;
            }
            for (int i = 0; i < method.methodSignatures().size(); ++i) {
                javaMethods.add(this.createRpcTestMethod(method, service, matchingService, (List)method.methodSignatures().get(i), i, false, classMemberVarExprs, resourceNames, messageTypes));
                javaMethods.add(this.createRpcExceptionTestMethod(method, matchingService, (List)method.methodSignatures().get(i), i, classMemberVarExprs, resourceNames, messageTypes));
            }
        }
        return javaMethods;
    }

    private MethodDefinition createRpcTestMethod(Method method, Service apiService, Service rpcService, List<MethodArgument> methodSignature, int variantIndex, boolean isRequestArg, Map<String, VariableExpr> classMemberVarExprs, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes) {
        boolean returnsVoid;
        if (!method.stream().equals((Object)Method.Stream.NONE)) {
            return this.createStreamingRpcTestMethod(rpcService, method, classMemberVarExprs, resourceNames, messageTypes);
        }
        TypeNode methodOutputType = method.hasLro() ? method.lro().responseType() : method.outputType();
        ArrayList<Expr> methodExprs = new ArrayList<Expr>();
        TypeNode repeatedResponseType = null;
        VariableExpr responsesElementVarExpr = null;
        String mockServiceVarName = this.getMockServiceVarName(rpcService);
        if (method.isPaged()) {
            Message methodOutputMessage = messageTypes.get(method.outputType().reference().fullName());
            Field repeatedPagedResultsField = methodOutputMessage.findAndUnwrapPaginatedRepeatedField();
            Preconditions.checkNotNull(repeatedPagedResultsField, String.format("No repeated field found for paged method %s with output message type %s", method.name(), methodOutputMessage.name()));
            repeatedResponseType = repeatedPagedResultsField.isMap() ? TypeNode.withReference((Reference)repeatedPagedResultsField.type().reference().generics().get(1)) : repeatedPagedResultsField.type();
            responsesElementVarExpr = VariableExpr.withVariable(Variable.builder().setType(repeatedResponseType).setName("responsesElement").build());
            methodExprs.add(AssignmentExpr.builder().setVariableExpr(responsesElementVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(DefaultValueComposer.createValue(Field.builder().setType(repeatedResponseType).setName("responsesElement").setIsMessage(!repeatedResponseType.isProtoPrimitiveType()).build())).build());
        }
        VariableExpr expectedResponseVarExpr = VariableExpr.withVariable(Variable.builder().setType(methodOutputType).setName("expectedResponse").build());
        Expr expectedResponseValExpr = null;
        if (method.isPaged()) {
            Message methodOutputMessage = messageTypes.get(method.outputType().reference().fullName());
            Field firstRepeatedField = methodOutputMessage.findAndUnwrapPaginatedRepeatedField();
            Preconditions.checkNotNull(firstRepeatedField, String.format("Expected paged RPC %s to have a repeated field in the response %s but found none", method.name(), methodOutputMessage.name()));
            expectedResponseValExpr = DefaultValueComposer.createSimplePagedResponseValue(method.outputType(), firstRepeatedField.name(), responsesElementVarExpr, firstRepeatedField.isMap());
        } else {
            expectedResponseValExpr = messageTypes.containsKey(methodOutputType.reference().fullName()) ? DefaultValueComposer.createSimpleMessageBuilderValue(messageTypes.get(methodOutputType.reference().fullName()), resourceNames, messageTypes, method.httpBindings()) : DefaultValueComposer.createValue(Field.builder().setType(methodOutputType).setIsMessage(true).setName("expectedResponse").build());
        }
        methodExprs.add(AssignmentExpr.builder().setVariableExpr(expectedResponseVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(expectedResponseValExpr).build());
        if (method.hasLro() && (method.lro().operationServiceStubType() == null || !method.lro().responseType().equals(method.outputType()))) {
            VariableExpr resultOperationVarExpr = VariableExpr.withVariable(Variable.builder().setType(FIXED_TYPESTORE.get("Operation")).setName("resultOperation").build());
            methodExprs.add(AssignmentExpr.builder().setVariableExpr(resultOperationVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(DefaultValueComposer.createSimpleOperationBuilderValue(String.format("%sTest", JavaStyle.toLowerCamelCase(method.name())), expectedResponseVarExpr)).build());
            methodExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(mockServiceVarName)).setMethodName("addResponse").setArguments(resultOperationVarExpr).build());
        } else {
            methodExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(mockServiceVarName)).setMethodName("addResponse").setArguments(expectedResponseVarExpr).build());
        }
        ArrayList<Statement> methodStatements = new ArrayList<Statement>();
        methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        methodExprs.clear();
        methodStatements.add(EMPTY_LINE_STATEMENT);
        VariableExpr requestVarExpr = null;
        Message requestMessage = null;
        ArrayList<VariableExpr> argExprs = new ArrayList<VariableExpr>();
        if (isRequestArg) {
            requestVarExpr = VariableExpr.withVariable(Variable.builder().setType(method.inputType()).setName("request").build());
            argExprs.add(requestVarExpr);
            requestMessage = messageTypes.get(method.inputType().reference().fullName());
            Preconditions.checkNotNull(requestMessage);
            Map<String, String> pathParamValuePatterns = Collections.emptyMap();
            if (this.getTransportContext().useValuePatterns() && method.hasHttpBindings()) {
                pathParamValuePatterns = method.httpBindings().getPathParametersValuePatterns();
            }
            Expr valExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, pathParamValuePatterns, method.httpBindings());
            methodExprs.add(AssignmentExpr.builder().setVariableExpr(requestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(valExpr).build());
        } else {
            Map<String, String> valuePatterns = Collections.emptyMap();
            if (this.getTransportContext().useValuePatterns() && method.hasHttpBindings()) {
                valuePatterns = method.httpBindings().getPathParametersValuePatterns();
            }
            for (MethodArgument methodArg : methodSignature) {
                String methodArgName = JavaStyle.toLowerCamelCase(methodArg.name());
                VariableExpr varExpr = VariableExpr.withVariable(Variable.builder().setType(methodArg.type()).setName(methodArgName).build());
                argExprs.add(varExpr);
                Expr valExpr = DefaultValueComposer.createMethodArgValue(methodArg, resourceNames, messageTypes, valuePatterns, method.httpBindings());
                methodExprs.add(AssignmentExpr.builder().setVariableExpr(varExpr.toBuilder().setIsDecl(true).build()).setValueExpr(valExpr).build());
            }
        }
        methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        methodExprs.clear();
        methodStatements.add(EMPTY_LINE_STATEMENT);
        VariableExpr actualResponseVarExpr = VariableExpr.withVariable(Variable.builder().setType(!method.isPaged() ? methodOutputType : AbstractServiceClientTestClassComposer.getPagedResponseType(method, method.isMixin() ? apiService : rpcService)).setName(method.isPaged() ? "pagedListResponse" : "actualResponse").build());
        MethodInvocationExpr rpcJavaMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(CLIENT_VAR_NAME)).setMethodName(JavaStyle.toLowerCamelCase(method.name()) + (method.hasLro() ? "Async" : "")).setArguments(argExprs.stream().map(e -> e).collect(Collectors.toList())).setReturnType(actualResponseVarExpr.type()).build();
        if (method.hasLro()) {
            rpcJavaMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(rpcJavaMethodInvocationExpr).setMethodName("get").setReturnType(rpcJavaMethodInvocationExpr.type()).build();
        }
        if (returnsVoid = AbstractServiceClientTestClassComposer.isProtoEmptyType(methodOutputType)) {
            methodExprs.add(rpcJavaMethodInvocationExpr);
        } else {
            methodExprs.add(AssignmentExpr.builder().setVariableExpr(actualResponseVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(rpcJavaMethodInvocationExpr).build());
        }
        if (method.isPaged()) {
            MethodInvocationExpr expectedPagedResponseExpr;
            Message methodOutputMessage = messageTypes.get(method.outputType().reference().fullName());
            Field repeatedPagedResultsField = methodOutputMessage.findAndUnwrapPaginatedRepeatedField();
            VariableExpr resourcesVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(repeatedPagedResultsField.type().reference())).build())).setName("resources").build());
            MethodInvocationExpr iterateAllExpr = MethodInvocationExpr.builder().setExprReferenceExpr(actualResponseVarExpr).setMethodName("iterateAll").build();
            MethodInvocationExpr resourcesValExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Lists")).setMethodName("newArrayList").setArguments(iterateAllExpr).setReturnType(resourcesVarExpr.type()).build();
            methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
            methodExprs.clear();
            methodStatements.add(EMPTY_LINE_STATEMENT);
            methodStatements.add(ExprStatement.withExpr(AssignmentExpr.builder().setVariableExpr(resourcesVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(resourcesValExpr).build()));
            methodStatements.add(EMPTY_LINE_STATEMENT);
            methodExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("1").build()), MethodInvocationExpr.builder().setExprReferenceExpr(resourcesVarExpr).setMethodName("size").setReturnType(TypeNode.INT).build()).build());
            Preconditions.checkNotNull(repeatedPagedResultsField, String.format("No repeated field found for paged method %s with output message type %s", method.name(), methodOutputMessage.name()));
            ValueExpr zeroExpr = ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("0").build());
            if (repeatedPagedResultsField.isMap()) {
                expectedPagedResponseExpr = MethodInvocationExpr.builder().setMethodName("next").setExprReferenceExpr(MethodInvocationExpr.builder().setMethodName("iterator").setExprReferenceExpr(MethodInvocationExpr.builder().setMethodName("entrySet").setExprReferenceExpr(MethodInvocationExpr.builder().setExprReferenceExpr(expectedResponseVarExpr).setMethodName(String.format("get%sMap", JavaStyle.toUpperCamelCase(repeatedPagedResultsField.name()))).build()).build()).build()).build();
            } else {
                expectedPagedResponseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(expectedResponseVarExpr).setMethodName(String.format("get%sList", JavaStyle.toUpperCamelCase(repeatedPagedResultsField.name()))).build();
                expectedPagedResponseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(expectedPagedResponseExpr).setMethodName("get").setArguments(zeroExpr).build();
            }
            MethodInvocationExpr actualPagedResponseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(resourcesVarExpr).setMethodName("get").setArguments(zeroExpr).build();
            methodExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(expectedPagedResponseExpr, actualPagedResponseExpr).build());
        } else if (!returnsVoid) {
            methodExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(expectedResponseVarExpr, actualResponseVarExpr).build());
        }
        methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        methodExprs.clear();
        methodStatements.add(EMPTY_LINE_STATEMENT);
        methodStatements.addAll(this.constructRpcTestCheckerLogic(method, methodSignature, rpcService, isRequestArg, classMemberVarExprs, requestVarExpr, requestMessage));
        String testMethodName = String.format("%sTest%s", JavaStyle.toLowerCamelCase(method.name()), variantIndex > 0 ? Integer.valueOf(variantIndex + 1) : "");
        return MethodDefinition.builder().setAnnotations(Arrays.asList(TEST_ANNOTATION)).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.VOID).setName(testMethodName).setThrowsExceptions(Arrays.asList(TypeNode.withExceptionClazz(Exception.class))).setBody(methodStatements).build();
    }

    protected abstract List<Statement> constructRpcTestCheckerLogic(Method var1, List<MethodArgument> var2, Service var3, boolean var4, Map<String, VariableExpr> var5, VariableExpr var6, Message var7);

    protected abstract MethodDefinition createStreamingRpcTestMethod(Service var1, Method var2, Map<String, VariableExpr> var3, Map<String, ResourceName> var4, Map<String, Message> var5);

    protected abstract MethodDefinition createRpcExceptionTestMethod(Method var1, Service var2, List<MethodArgument> var3, int var4, Map<String, VariableExpr> var5, Map<String, ResourceName> var6, Map<String, Message> var7);

    protected abstract List<Statement> createStreamingRpcExceptionTestStatements(Method var1, Map<String, VariableExpr> var2, Map<String, ResourceName> var3, Map<String, Message> var4);

    protected MethodDefinition createUnsupportedTestMethod(Method method) {
        String javaMethodName = JavaStyle.toLowerCamelCase(method.name());
        String exceptionTestMethodName = String.format("%sUnsupportedMethodTest", javaMethodName);
        List<Statement> methodBody = Collections.singletonList(CommentStatement.withComment(LineComment.withComment("The " + javaMethodName + "() method is not supported in " + String.join((CharSequence)"+", this.getTransportContext().transportNames()) + " transport.\nThis empty test is generated for technical reasons.")));
        return MethodDefinition.builder().setAnnotations(Arrays.asList(TEST_ANNOTATION)).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.VOID).setName(exceptionTestMethodName).setThrowsExceptions(Arrays.asList(TypeNode.withExceptionClazz(Exception.class))).setBody(methodBody).build();
    }

    protected List<Statement> createRpcExceptionTestStatements(Method method, List<MethodArgument> methodSignature, Map<String, VariableExpr> classMemberVarExprs, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes) {
        ArrayList<VariableExpr> argVarExprs = new ArrayList<VariableExpr>();
        ArrayList<Expr> tryBodyExprs = new ArrayList<Expr>();
        if (methodSignature.isEmpty()) {
            VariableExpr varExpr = VariableExpr.withVariable(Variable.builder().setType(method.inputType()).setName("request").build());
            argVarExprs.add(varExpr);
            Message requestMessage = messageTypes.get(method.inputType().reference().fullName());
            Preconditions.checkNotNull(requestMessage);
            Map<String, String> valuePatterns = Collections.emptyMap();
            if (this.getTransportContext().useValuePatterns() && method.hasHttpBindings()) {
                valuePatterns = method.httpBindings().getPathParametersValuePatterns();
            }
            Expr valExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, valuePatterns, method.httpBindings());
            tryBodyExprs.add(AssignmentExpr.builder().setVariableExpr(varExpr.toBuilder().setIsDecl(true).build()).setValueExpr(valExpr).build());
        } else {
            Map<String, String> valuePatterns = Collections.emptyMap();
            if (this.getTransportContext().useValuePatterns() && method.hasHttpBindings()) {
                valuePatterns = method.httpBindings().getPathParametersValuePatterns();
            }
            for (MethodArgument methodArg : methodSignature) {
                String methodArgName = JavaStyle.toLowerCamelCase(methodArg.name());
                VariableExpr varExpr = VariableExpr.withVariable(Variable.builder().setType(methodArg.type()).setName(methodArgName).build());
                argVarExprs.add(varExpr);
                Expr valExpr = DefaultValueComposer.createMethodArgValue(methodArg, resourceNames, messageTypes, valuePatterns, method.httpBindings());
                tryBodyExprs.add(AssignmentExpr.builder().setVariableExpr(varExpr.toBuilder().setIsDecl(true).build()).setValueExpr(valExpr).build());
            }
        }
        String rpcJavaName = JavaStyle.toLowerCamelCase(method.name());
        if (method.hasLro()) {
            rpcJavaName = rpcJavaName + "Async";
        }
        MethodInvocationExpr rpcJavaMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(CLIENT_VAR_NAME)).setMethodName(rpcJavaName).setArguments(argVarExprs.stream().map(e -> e).collect(Collectors.toList())).build();
        if (method.hasLro()) {
            rpcJavaMethodInvocationExpr = MethodInvocationExpr.builder().setExprReferenceExpr(rpcJavaMethodInvocationExpr).setMethodName("get").build();
        }
        tryBodyExprs.add(rpcJavaMethodInvocationExpr);
        VariableExpr catchExceptionVarExpr = VariableExpr.builder().setVariable(Variable.builder().setType(TypeNode.withExceptionClazz(method.hasLro() ? ExecutionException.class : InvalidArgumentException.class)).setName("e").build()).build();
        List<Statement> catchBody = method.hasLro() ? this.createRpcLroExceptionTestCatchBody(catchExceptionVarExpr, false) : Arrays.asList(CommentStatement.withComment(LineComment.withComment("Expected exception.")));
        tryBodyExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("fail").setArguments(ValueExpr.withValue(StringObjectValue.withValue("No exception raised"))).build());
        TryCatchStatement tryCatchBlock = TryCatchStatement.builder().setTryBody(tryBodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).addCatch(catchExceptionVarExpr.toBuilder().setIsDecl(true).build(), catchBody).build();
        return Arrays.asList(EMPTY_LINE_STATEMENT, tryCatchBlock);
    }

    protected abstract List<Statement> createRpcLroExceptionTestCatchBody(VariableExpr var1, boolean var2);

    private static TypeStore createStaticTypes() {
        List<Class<?>> concreteClazzes = Arrays.asList(AbstractMessage.class, After.class, AfterClass.class, Any.class, ApiClientHeaderProvider.class, ApiStreamObserver.class, Arrays.class, Assert.class, Before.class, BeforeClass.class, BidiStreamingCallable.class, ClientStreamingCallable.class, ExecutionException.class, Generated.class, IOException.class, InvalidArgumentException.class, List.class, Lists.class, NoCredentialsProvider.class, Operation.class, ServerStreamingCallable.class, StatusCode.class, Test.class, UUID.class);
        return new TypeStore(concreteClazzes);
    }

    private void addDynamicTypes(GapicContext context, Service service, TypeStore typeStore) {
        typeStore.putAll(service.pakkage(), Arrays.asList(ClassNames.getMockServiceClassName(service), ClassNames.getServiceClientClassName(service), ClassNames.getServiceSettingsClassName(service)));
        String stubPakkage = String.format("%s.stub", service.pakkage());
        typeStore.put(stubPakkage, this.getTransportContext().classNames().getTransportServiceStubClassName(service));
        typeStore.putAll(service.pakkage(), service.methods().stream().filter(m -> m.isPaged()).map(m -> String.format("%sPagedResponse", m.name())).collect(Collectors.toList()), true, ClassNames.getServiceClientClassName(service));
        for (Service mixinService : context.mixinServices()) {
            typeStore.put(mixinService.pakkage(), ClassNames.getMockServiceClassName(mixinService));
            for (Method mixinMethod : mixinService.methods()) {
                if (!mixinMethod.isPaged()) continue;
                typeStore.put(service.pakkage(), String.format("%sPagedResponse", mixinMethod.name()), true, ClassNames.getServiceClientClassName(service));
            }
        }
    }

    protected static TypeNode getCallableType(Method protoMethod) {
        Preconditions.checkState(!protoMethod.stream().equals((Object)Method.Stream.NONE), "No callable type exists for non-streaming methods.");
        Class callableClazz = ClientStreamingCallable.class;
        switch (protoMethod.stream()) {
            case BIDI: {
                callableClazz = BidiStreamingCallable.class;
                break;
            }
            case SERVER: {
                callableClazz = ServerStreamingCallable.class;
                break;
            }
        }
        ArrayList<Reference> generics = new ArrayList<Reference>();
        generics.add(protoMethod.inputType().reference());
        generics.add(protoMethod.outputType().reference());
        return TypeNode.withReference(ConcreteReference.builder().setClazz(callableClazz).setGenerics(generics).build());
    }

    private static TypeNode getPagedResponseType(Method method, Service service) {
        return TypeNode.withReference(VaporReference.builder().setName(String.format("%sPagedResponse", method.name())).setPakkage(service.pakkage()).setEnclosingClassNames(ClassNames.getServiceClientClassName(service)).setIsStaticImport(true).build());
    }

    protected static String getCallableMethodName(Method protoMethod) {
        Preconditions.checkState(!protoMethod.stream().equals((Object)Method.Stream.NONE), "No callable type exists for non-streaming methods.");
        switch (protoMethod.stream()) {
            case BIDI: {
                return "bidiStreamingCall";
            }
            case SERVER: {
                return "serverStreamingCall";
            }
        }
        return "clientStreamingCall";
    }

    protected String getMockServiceVarName(Service service) {
        return String.format(MOCK_SERVICE_VAR_NAME_PATTERN, service.name());
    }

    private static boolean isProtoEmptyType(TypeNode type) {
        return type.reference().pakkage().equals("com.google.protobuf") && type.reference().name().equals("Empty");
    }
}

