/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.Internal;
import io.grpc.xds.client.AutoValue_Bootstrapper_AuthorityInfo;
import io.grpc.xds.client.AutoValue_Bootstrapper_BootstrapInfo;
import io.grpc.xds.client.AutoValue_Bootstrapper_CertificateProviderInfo;
import io.grpc.xds.client.AutoValue_Bootstrapper_ServerInfo;
import io.grpc.xds.client.EnvoyProtoData;
import io.grpc.xds.client.XdsInitializationException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public abstract class Bootstrapper {
    public static final String XDSTP_SCHEME = "xdstp:";

    public abstract BootstrapInfo bootstrap() throws XdsInitializationException;

    public BootstrapInfo bootstrap(Map<String, ?> rawData) throws XdsInitializationException {
        throw new UnsupportedOperationException();
    }

    @AutoValue
    @Internal
    public static abstract class BootstrapInfo {
        public abstract ImmutableList<ServerInfo> servers();

        public abstract EnvoyProtoData.Node node();

        @Nullable
        public abstract ImmutableMap<String, CertificateProviderInfo> certProviders();

        @Nullable
        public abstract String serverListenerResourceNameTemplate();

        public abstract String clientDefaultListenerResourceNameTemplate();

        public abstract ImmutableMap<String, AuthorityInfo> authorities();

        @VisibleForTesting
        public static Builder builder() {
            return new AutoValue_Bootstrapper_BootstrapInfo.Builder().clientDefaultListenerResourceNameTemplate("%s").authorities(ImmutableMap.of());
        }

        @AutoValue.Builder
        @VisibleForTesting
        public static abstract class Builder {
            public abstract Builder servers(List<ServerInfo> var1);

            public abstract Builder node(EnvoyProtoData.Node var1);

            public abstract Builder certProviders(@Nullable Map<String, CertificateProviderInfo> var1);

            public abstract Builder serverListenerResourceNameTemplate(@Nullable String var1);

            public abstract Builder clientDefaultListenerResourceNameTemplate(String var1);

            public abstract Builder authorities(Map<String, AuthorityInfo> var1);

            public abstract BootstrapInfo build();
        }
    }

    @AutoValue
    public static abstract class AuthorityInfo {
        public abstract String clientListenerResourceNameTemplate();

        public abstract ImmutableList<ServerInfo> xdsServers();

        public static AuthorityInfo create(String clientListenerResourceNameTemplate, List<ServerInfo> xdsServers) {
            Preconditions.checkArgument(!xdsServers.isEmpty(), "xdsServers must not be empty");
            return new AutoValue_Bootstrapper_AuthorityInfo(clientListenerResourceNameTemplate, ImmutableList.copyOf(xdsServers));
        }
    }

    @AutoValue
    @Internal
    public static abstract class CertificateProviderInfo {
        public abstract String pluginName();

        public abstract ImmutableMap<String, ?> config();

        @VisibleForTesting
        public static CertificateProviderInfo create(String pluginName, Map<String, ?> config) {
            return new AutoValue_Bootstrapper_CertificateProviderInfo(pluginName, ImmutableMap.copyOf(config));
        }
    }

    @AutoValue
    @Internal
    public static abstract class ServerInfo {
        public abstract String target();

        public abstract Object implSpecificConfig();

        public abstract boolean ignoreResourceDeletion();

        public abstract boolean isTrustedXdsServer();

        public abstract boolean resourceTimerIsTransientError();

        @VisibleForTesting
        public static ServerInfo create(String target, @Nullable Object implSpecificConfig) {
            return new AutoValue_Bootstrapper_ServerInfo(target, implSpecificConfig, false, false, false);
        }

        @VisibleForTesting
        public static ServerInfo create(String target, Object implSpecificConfig, boolean ignoreResourceDeletion, boolean isTrustedXdsServer, boolean resourceTimerIsTransientError) {
            return new AutoValue_Bootstrapper_ServerInfo(target, implSpecificConfig, ignoreResourceDeletion, isTrustedXdsServer, resourceTimerIsTransientError);
        }
    }
}

