/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.LongCounterMetricInstrument;
import io.grpc.LongGaugeMetricInstrument;
import io.grpc.MetricInstrumentRegistry;
import io.grpc.MetricRecorder;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsClientMetricReporter;
import io.grpc.xds.client.XdsResourceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class XdsClientMetricReporterImpl
implements XdsClientMetricReporter {
    private static final Logger logger = Logger.getLogger(XdsClientMetricReporterImpl.class.getName());
    private static final LongCounterMetricInstrument SERVER_FAILURE_COUNTER;
    private static final LongCounterMetricInstrument RESOURCE_UPDATES_VALID_COUNTER;
    private static final LongCounterMetricInstrument RESOURCE_UPDATES_INVALID_COUNTER;
    private static final LongGaugeMetricInstrument CONNECTED_GAUGE;
    private static final LongGaugeMetricInstrument RESOURCES_GAUGE;
    private final MetricRecorder metricRecorder;
    private final String target;
    @Nullable
    private MetricRecorder.Registration gaugeRegistration = null;

    XdsClientMetricReporterImpl(MetricRecorder metricRecorder, String target) {
        this.metricRecorder = metricRecorder;
        this.target = target;
    }

    @Override
    public void reportResourceUpdates(long validResourceCount, long invalidResourceCount, String xdsServer, String resourceType) {
        this.metricRecorder.addLongCounter(RESOURCE_UPDATES_VALID_COUNTER, validResourceCount, Arrays.asList(this.target, xdsServer, resourceType), Collections.emptyList());
        this.metricRecorder.addLongCounter(RESOURCE_UPDATES_INVALID_COUNTER, invalidResourceCount, Arrays.asList(this.target, xdsServer, resourceType), Collections.emptyList());
    }

    @Override
    public void reportServerFailure(long serverFailure, String xdsServer) {
        this.metricRecorder.addLongCounter(SERVER_FAILURE_COUNTER, serverFailure, Arrays.asList(this.target, xdsServer), Collections.emptyList());
    }

    void setXdsClient(final XdsClient xdsClient) {
        assert (this.gaugeRegistration == null);
        this.gaugeRegistration = this.metricRecorder.registerBatchCallback(new MetricRecorder.BatchCallback(){

            @Override
            public void accept(MetricRecorder.BatchRecorder recorder) {
                XdsClientMetricReporterImpl.this.reportCallbackMetrics(recorder, xdsClient);
            }
        }, CONNECTED_GAUGE, RESOURCES_GAUGE);
    }

    void close() {
        if (this.gaugeRegistration != null) {
            this.gaugeRegistration.close();
            this.gaugeRegistration = null;
        }
    }

    void reportCallbackMetrics(MetricRecorder.BatchRecorder recorder, XdsClient xdsClient) {
        MetricReporterCallback callback = new MetricReporterCallback(recorder, this.target);
        try {
            Future<Void> reportServerConnectionsCompleted = xdsClient.reportServerConnections(callback);
            ListenableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> getResourceMetadataCompleted = xdsClient.getSubscribedResourcesMetadataSnapshot();
            Map metadataByType = (Map)getResourceMetadataCompleted.get(10L, TimeUnit.SECONDS);
            this.computeAndReportResourceCounts(metadataByType, callback);
            Void void_ = reportServerConnectionsCompleted.get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.log(Level.WARNING, "Failed to report gauge metrics", e);
        }
    }

    private void computeAndReportResourceCounts(Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>> metadataByType, MetricReporterCallback callback) {
        for (Map.Entry<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>> metadataByTypeEntry : metadataByType.entrySet()) {
            XdsResourceType<?> type = metadataByTypeEntry.getKey();
            Map<String, XdsClient.ResourceMetadata> resources = metadataByTypeEntry.getValue();
            HashMap<String, Map> resourceCountsByAuthorityAndState = new HashMap<String, Map>();
            for (Map.Entry<String, XdsClient.ResourceMetadata> entry : resources.entrySet()) {
                String resourceName = entry.getKey();
                XdsClient.ResourceMetadata metadata = entry.getValue();
                String authority = XdsClient.getAuthorityFromResourceName(resourceName);
                String cacheState = XdsClientMetricReporterImpl.cacheStateFromResourceStatus(metadata.getStatus(), metadata.isCached());
                resourceCountsByAuthorityAndState.computeIfAbsent(authority, k -> new HashMap()).merge(cacheState, 1L, Long::sum);
            }
            for (Map.Entry<String, XdsClient.ResourceMetadata> entry : resourceCountsByAuthorityAndState.entrySet()) {
                String authority = entry.getKey();
                Map stateCounts = (Map)((Object)entry.getValue());
                for (Map.Entry stateEntry : stateCounts.entrySet()) {
                    String cacheState = (String)stateEntry.getKey();
                    Long count = (Long)stateEntry.getValue();
                    callback.reportResourceCountGauge(count, authority, cacheState, type.typeUrl());
                }
            }
        }
    }

    private static String cacheStateFromResourceStatus(XdsClient.ResourceMetadata.ResourceMetadataStatus metadataStatus, boolean isResourceCached) {
        switch (metadataStatus) {
            case REQUESTED: {
                return "requested";
            }
            case DOES_NOT_EXIST: {
                return "does_not_exist";
            }
            case ACKED: {
                return "acked";
            }
            case NACKED: {
                return isResourceCached ? "nacked_but_cached" : "nacked";
            }
        }
        return "unknown";
    }

    static {
        MetricInstrumentRegistry metricInstrumentRegistry = MetricInstrumentRegistry.getDefaultRegistry();
        SERVER_FAILURE_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.xds_client.server_failure", "EXPERIMENTAL. A counter of xDS servers going from healthy to unhealthy. A server goes unhealthy when we have a connectivity failure or when the ADS stream fails without seeing a response message, as per gRFC A57.", "{failure}", Arrays.asList("grpc.target", "grpc.xds.server"), Collections.emptyList(), false);
        RESOURCE_UPDATES_VALID_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.xds_client.resource_updates_valid", "EXPERIMENTAL. A counter of resources received that were considered valid. The counter will be incremented even for resources that have not changed.", "{resource}", Arrays.asList("grpc.target", "grpc.xds.server", "grpc.xds.resource_type"), Collections.emptyList(), false);
        RESOURCE_UPDATES_INVALID_COUNTER = metricInstrumentRegistry.registerLongCounter("grpc.xds_client.resource_updates_invalid", "EXPERIMENTAL. A counter of resources received that were considered invalid.", "{resource}", Arrays.asList("grpc.target", "grpc.xds.server", "grpc.xds.resource_type"), Collections.emptyList(), false);
        CONNECTED_GAUGE = metricInstrumentRegistry.registerLongGauge("grpc.xds_client.connected", "EXPERIMENTAL. Whether or not the xDS client currently has a working ADS stream to the xDS server. For a given server, this will be set to 1 when the stream is initially created. It will be set to 0 when we have a connectivity failure or when the ADS stream fails without seeing a response message, as per gRFC A57. Once set to 0, it will be reset to 1 when we receive the first response on an ADS stream.", "{bool}", Arrays.asList("grpc.target", "grpc.xds.server"), Collections.emptyList(), false);
        RESOURCES_GAUGE = metricInstrumentRegistry.registerLongGauge("grpc.xds_client.resources", "EXPERIMENTAL.  Number of xDS resources.", "{resource}", Arrays.asList("grpc.target", "grpc.xds.authority", "grpc.xds.cache_state", "grpc.xds.resource_type"), Collections.emptyList(), false);
    }

    @VisibleForTesting
    static final class MetricReporterCallback
    implements XdsClient.ServerConnectionCallback {
        private final MetricRecorder.BatchRecorder recorder;
        private final String target;

        MetricReporterCallback(MetricRecorder.BatchRecorder recorder, String target) {
            this.recorder = recorder;
            this.target = target;
        }

        void reportResourceCountGauge(long resourceCount, String authority, String cacheState, String resourceType) {
            this.recorder.recordLongGauge(RESOURCES_GAUGE, resourceCount, Arrays.asList(this.target, authority == null ? "#old" : authority, cacheState, resourceType), Collections.emptyList());
        }

        @Override
        public void reportServerConnectionGauge(boolean isConnected, String xdsServer) {
            this.recorder.recordLongGauge(CONNECTED_GAUGE, isConnected ? 1L : 0L, Arrays.asList(this.target, xdsServer), Collections.emptyList());
        }
    }
}

