/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AutoValue_PrimitiveValue;
import com.google.api.generator.engine.ast.TypeMismatchException;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.Value;
import com.google.api.generator.engine.lexicon.Literal;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class PrimitiveValue
implements Value {
    @Override
    public abstract TypeNode type();

    @Override
    public abstract String value();

    public static Builder builder() {
        return new AutoValue_PrimitiveValue.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setType(TypeNode var1);

        public abstract Builder setValue(String var1);

        abstract PrimitiveValue autoBuild();

        public PrimitiveValue build() throws TypeMismatchException {
            String value;
            PrimitiveValue primitiveValue = this.autoBuild();
            TypeNode type = primitiveValue.type();
            if (!Builder.typeMatchesValue(type, value = primitiveValue.value())) {
                throw new TypeMismatchException(String.format("Type %s does not match value %s", new Object[]{type.typeKind(), value}));
            }
            return primitiveValue;
        }

        private static boolean typeMatchesValue(TypeNode type, String value) {
            switch (type.typeKind()) {
                case INT: {
                    return Literal.isIntegerLiteral(value);
                }
                case LONG: {
                    return Literal.isLongLiteral(value);
                }
                case FLOAT: {
                    return Literal.isFloatLiteral(value);
                }
                case DOUBLE: {
                    return Literal.isDoubleLiteral(value);
                }
                case BOOLEAN: {
                    return Literal.isBooleanLiteral(value);
                }
            }
            return false;
        }
    }
}

