/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.TypeNode;
import java.util.List;
import javax.annotation.Nullable;

final class AutoValue_MethodInvocationExpr
extends MethodInvocationExpr {
    private final IdentifierNode methodIdentifier;
    private final TypeNode returnType;
    @Nullable
    private final Expr exprReferenceExpr;
    @Nullable
    private final TypeNode staticReferenceType;
    private final List<Expr> arguments;
    private final List<Reference> generics;
    private final String methodName;

    private AutoValue_MethodInvocationExpr(IdentifierNode methodIdentifier, TypeNode returnType, @Nullable Expr exprReferenceExpr, @Nullable TypeNode staticReferenceType, List<Expr> arguments, List<Reference> generics, String methodName) {
        this.methodIdentifier = methodIdentifier;
        this.returnType = returnType;
        this.exprReferenceExpr = exprReferenceExpr;
        this.staticReferenceType = staticReferenceType;
        this.arguments = arguments;
        this.generics = generics;
        this.methodName = methodName;
    }

    @Override
    public IdentifierNode methodIdentifier() {
        return this.methodIdentifier;
    }

    @Override
    public TypeNode returnType() {
        return this.returnType;
    }

    @Override
    @Nullable
    public Expr exprReferenceExpr() {
        return this.exprReferenceExpr;
    }

    @Override
    @Nullable
    public TypeNode staticReferenceType() {
        return this.staticReferenceType;
    }

    @Override
    public List<Expr> arguments() {
        return this.arguments;
    }

    @Override
    public List<Reference> generics() {
        return this.generics;
    }

    @Override
    String methodName() {
        return this.methodName;
    }

    public String toString() {
        return "MethodInvocationExpr{methodIdentifier=" + this.methodIdentifier + ", returnType=" + this.returnType + ", exprReferenceExpr=" + this.exprReferenceExpr + ", staticReferenceType=" + this.staticReferenceType + ", arguments=" + this.arguments + ", generics=" + this.generics + ", methodName=" + this.methodName + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MethodInvocationExpr) {
            MethodInvocationExpr that = (MethodInvocationExpr)o;
            return this.methodIdentifier.equals(that.methodIdentifier()) && this.returnType.equals(that.returnType()) && (this.exprReferenceExpr == null ? that.exprReferenceExpr() == null : this.exprReferenceExpr.equals(that.exprReferenceExpr())) && (this.staticReferenceType == null ? that.staticReferenceType() == null : this.staticReferenceType.equals(that.staticReferenceType())) && this.arguments.equals(that.arguments()) && this.generics.equals(that.generics()) && this.methodName.equals(that.methodName());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.methodIdentifier.hashCode();
        h$ *= 1000003;
        h$ ^= this.returnType.hashCode();
        h$ *= 1000003;
        h$ ^= this.exprReferenceExpr == null ? 0 : this.exprReferenceExpr.hashCode();
        h$ *= 1000003;
        h$ ^= this.staticReferenceType == null ? 0 : this.staticReferenceType.hashCode();
        h$ *= 1000003;
        h$ ^= this.arguments.hashCode();
        h$ *= 1000003;
        h$ ^= this.generics.hashCode();
        h$ *= 1000003;
        return h$ ^= this.methodName.hashCode();
    }

    @Override
    public MethodInvocationExpr.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends MethodInvocationExpr.Builder {
        private IdentifierNode methodIdentifier;
        private TypeNode returnType;
        private Expr exprReferenceExpr;
        private TypeNode staticReferenceType;
        private List<Expr> arguments;
        private List<Reference> generics;
        private String methodName;

        Builder() {
        }

        Builder(MethodInvocationExpr source) {
            this.methodIdentifier = source.methodIdentifier();
            this.returnType = source.returnType();
            this.exprReferenceExpr = source.exprReferenceExpr();
            this.staticReferenceType = source.staticReferenceType();
            this.arguments = source.arguments();
            this.generics = source.generics();
            this.methodName = source.methodName();
        }

        @Override
        MethodInvocationExpr.Builder setMethodIdentifier(IdentifierNode methodIdentifier) {
            if (methodIdentifier == null) {
                throw new NullPointerException("Null methodIdentifier");
            }
            this.methodIdentifier = methodIdentifier;
            return this;
        }

        @Override
        public MethodInvocationExpr.Builder setReturnType(TypeNode returnType) {
            if (returnType == null) {
                throw new NullPointerException("Null returnType");
            }
            this.returnType = returnType;
            return this;
        }

        @Override
        public MethodInvocationExpr.Builder setExprReferenceExpr(Expr exprReferenceExpr) {
            this.exprReferenceExpr = exprReferenceExpr;
            return this;
        }

        @Override
        public MethodInvocationExpr.Builder setStaticReferenceType(TypeNode staticReferenceType) {
            this.staticReferenceType = staticReferenceType;
            return this;
        }

        @Override
        public MethodInvocationExpr.Builder setArguments(List<Expr> arguments) {
            if (arguments == null) {
                throw new NullPointerException("Null arguments");
            }
            this.arguments = arguments;
            return this;
        }

        @Override
        public MethodInvocationExpr.Builder setGenerics(List<Reference> generics) {
            if (generics == null) {
                throw new NullPointerException("Null generics");
            }
            this.generics = generics;
            return this;
        }

        @Override
        public MethodInvocationExpr.Builder setMethodName(String methodName) {
            if (methodName == null) {
                throw new NullPointerException("Null methodName");
            }
            this.methodName = methodName;
            return this;
        }

        @Override
        String methodName() {
            if (this.methodName == null) {
                throw new IllegalStateException("Property \"methodName\" has not been set");
            }
            return this.methodName;
        }

        @Override
        MethodInvocationExpr autoBuild() {
            if (this.methodIdentifier == null || this.returnType == null || this.arguments == null || this.generics == null || this.methodName == null) {
                StringBuilder missing = new StringBuilder();
                if (this.methodIdentifier == null) {
                    missing.append(" methodIdentifier");
                }
                if (this.returnType == null) {
                    missing.append(" returnType");
                }
                if (this.arguments == null) {
                    missing.append(" arguments");
                }
                if (this.generics == null) {
                    missing.append(" generics");
                }
                if (this.methodName == null) {
                    missing.append(" methodName");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MethodInvocationExpr(this.methodIdentifier, this.returnType, this.exprReferenceExpr, this.staticReferenceType, this.arguments, this.generics, this.methodName);
        }
    }
}

