/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_AnonymousClassExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class AnonymousClassExpr
implements Expr {
    @Override
    public abstract TypeNode type();

    public abstract ImmutableList<MethodDefinition> methods();

    public abstract ImmutableList<Statement> statements();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_AnonymousClassExpr.Builder().setMethods(Collections.emptyList()).setStatements(Collections.emptyList());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setType(TypeNode var1);

        public Builder setMethods(MethodDefinition ... methods) {
            return this.setMethods(Arrays.asList(methods));
        }

        public abstract Builder setMethods(List<MethodDefinition> var1);

        public abstract Builder setStatements(List<Statement> var1);

        public abstract AnonymousClassExpr autoBuild();

        public AnonymousClassExpr build() {
            AnonymousClassExpr anonymousClassExpr = this.autoBuild();
            Preconditions.checkState(TypeNode.isReferenceType(anonymousClassExpr.type()), "Anonymous class expression must be reference types.");
            String contextInfo = String.format("anonymous class of type %s", anonymousClassExpr.type().reference().name());
            NodeValidator.checkNoNullElements(anonymousClassExpr.methods(), "methods", contextInfo);
            NodeValidator.checkNoNullElements(anonymousClassExpr.statements(), "statements", contextInfo);
            for (MethodDefinition method : anonymousClassExpr.methods()) {
                Preconditions.checkState(!method.isStatic(), "Anonymous class cannot have static methods.");
                Preconditions.checkState(!method.isConstructor(), "Anonymous class cannot have explicit constructors.");
            }
            for (Statement statement : anonymousClassExpr.statements()) {
                if (!(statement instanceof ExprStatement)) continue;
                Expr expr = ((ExprStatement)statement).expression();
                if (expr instanceof VariableExpr) {
                    Preconditions.checkState(this.validVariableExpr((VariableExpr)expr), "Anonymous class cannot have static variable expression unless it is final.");
                    continue;
                }
                if (!(expr instanceof AssignmentExpr)) continue;
                Preconditions.checkState(this.validVariableExpr(((AssignmentExpr)expr).variableExpr()), "Anonymous class cannot have static variable expression in assignment expression unless it is final.");
            }
            return anonymousClassExpr;
        }

        private boolean validVariableExpr(VariableExpr expr) {
            return !expr.isStatic() || expr.isFinal();
        }
    }
}

