/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.writer;

import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AnonymousClassExpr;
import com.google.api.generator.engine.ast.ArithmeticOperationExpr;
import com.google.api.generator.engine.ast.ArrayExpr;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.AssignmentOperationExpr;
import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.BlockComment;
import com.google.api.generator.engine.ast.BlockStatement;
import com.google.api.generator.engine.ast.BreakStatement;
import com.google.api.generator.engine.ast.CastExpr;
import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.EmptyLineStatement;
import com.google.api.generator.engine.ast.EnumRefExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.ForStatement;
import com.google.api.generator.engine.ast.GeneralForStatement;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.IfStatement;
import com.google.api.generator.engine.ast.InstanceofExpr;
import com.google.api.generator.engine.ast.JavaDocComment;
import com.google.api.generator.engine.ast.LambdaExpr;
import com.google.api.generator.engine.ast.LineComment;
import com.google.api.generator.engine.ast.LogicalOperationExpr;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.NewObjectExpr;
import com.google.api.generator.engine.ast.OperatorKind;
import com.google.api.generator.engine.ast.PackageInfoDefinition;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.ReferenceConstructorExpr;
import com.google.api.generator.engine.ast.RelationalOperationExpr;
import com.google.api.generator.engine.ast.ReturnExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.SynchronizedStatement;
import com.google.api.generator.engine.ast.TernaryExpr;
import com.google.api.generator.engine.ast.ThrowExpr;
import com.google.api.generator.engine.ast.TryCatchStatement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.UnaryOperationExpr;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.engine.ast.WhileStatement;
import com.google.api.generator.engine.writer.ImportWriterVisitor;
import com.google.api.generator.engine.writer.JavaFormatter;
import com.google.api.generator.gapic.model.RegionTag;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class JavaWriterVisitor
implements AstNodeVisitor {
    private static final String SPACE = " ";
    private static final String NEWLINE = "\n";
    private static final String AT = "@";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String BLOCK_COMMENT_START = "/*";
    private static final String BLOCK_COMMENT_END = "*/";
    private static final String DOT = ".";
    private static final String EQUALS = "=";
    private static final String LEFT_ANGLE = "<";
    private static final String LEFT_BRACE = "{";
    private static final String LEFT_PAREN = "(";
    private static final String JAVADOC_COMMENT_START = "/**";
    private static final String QUESTION_MARK = "?";
    private static final String RIGHT_ANGLE = ">";
    private static final String RIGHT_BRACE = "}";
    private static final String RIGHT_PAREN = ")";
    private static final String SEMICOLON = ";";
    private static final String ASTERISK = "*";
    private static final String ABSTRACT = "abstract";
    private static final String CATCH = "catch";
    private static final String CLASS = "class";
    private static final String ELSE = "else";
    private static final String EXTENDS = "extends";
    private static final String FINAL = "final";
    private static final String FOR = "for";
    private static final String IF = "if";
    private static final String INSTANCEOF = "instanceof";
    private static final String IMPLEMENTS = "implements";
    private static final String NEW = "new";
    private static final String RETURN = "return";
    private static final String SYNCHRONIZED = "synchronized";
    private static final String STATIC = "static";
    private static final String THROW = "throw";
    private static final String THROWS = "throws";
    private static final String TRY = "try";
    private static final String VOLATILE = "volatile";
    private static final String WHILE = "while";
    private static final String BREAK = "break";
    private static final String OPERATOR_ADDITION = "+";
    private static final String OPERATOR_EQUAL_TO = "==";
    private static final String OPERATOR_NOT_EQUAL_TO = "!=";
    private static final String OPERATOR_LESS_THAN = "<";
    private static final String OPERATOR_INCREMENT = "++";
    private static final String OPERATOR_LOGICAL_NOT = "!";
    private static final String OPERATOR_LOGICAL_AND = "&&";
    private static final String OPERATOR_LOGICAL_OR = "||";
    private static final String OPERATOR_XOR = "^=";
    private static final String OPERATOR_MULTIPLE_AND_ASSIGNMENT = "*=";
    private final StringBuffer buffer = new StringBuffer();
    private final ImportWriterVisitor importWriterVisitor = new ImportWriterVisitor();

    public void clear() {
        this.buffer.setLength(0);
        this.importWriterVisitor.clear();
    }

    public String write() {
        return this.buffer.toString();
    }

    @Override
    public void visit(IdentifierNode identifier) {
        this.buffer.append(identifier.name());
    }

    @Override
    public void visit(TypeNode type) {
        TypeNode.TypeKind typeKind = type.typeKind();
        if (type.isPrimitiveType()) {
            this.buffer.append(typeKind.toString().toLowerCase());
        } else {
            type.reference().accept(this);
        }
        if (type.isArray()) {
            this.buffer.append("[]");
        }
    }

    @Override
    public void visit(ScopeNode scope) {
        this.buffer.append(scope.toString());
    }

    @Override
    public void visit(ArrayExpr expr) {
        this.buffer.append(LEFT_BRACE);
        for (int i = 0; i < expr.exprs().size(); ++i) {
            expr.exprs().get(i).accept(this);
            if (i >= expr.exprs().size() - 1) continue;
            this.buffer.append(COMMA);
            this.buffer.append(SPACE);
        }
        this.buffer.append(RIGHT_BRACE);
    }

    @Override
    public void visit(AnnotationNode annotation) {
        this.buffer.append(AT);
        annotation.type().accept(this);
        if (annotation.descriptionExprs() != null) {
            this.leftParen();
            for (int i = 0; i < annotation.descriptionExprs().size(); ++i) {
                annotation.descriptionExprs().get(i).accept(this);
                if (i >= annotation.descriptionExprs().size() - 1) continue;
                this.buffer.append(COMMA);
                this.buffer.append(SPACE);
            }
            this.rightParen();
        }
        this.newline();
    }

    @Override
    public void visit(ConcreteReference reference) {
        if (reference.isWildcard()) {
            this.buffer.append(QUESTION_MARK);
            if (reference.wildcardUpperBound() != null) {
                this.buffer.append(SPACE);
                this.buffer.append(EXTENDS);
                this.buffer.append(SPACE);
                reference.wildcardUpperBound().accept(this);
            }
            return;
        }
        String pakkage = reference.pakkage();
        String shortName = reference.name();
        if (reference.useFullName() || this.importWriterVisitor.collidesWithImport(pakkage, shortName)) {
            this.buffer.append(pakkage);
            this.buffer.append(DOT);
        }
        if (reference.hasEnclosingClass() && !reference.isStaticImport()) {
            this.buffer.append(String.join((CharSequence)DOT, reference.enclosingClassNames()));
            this.buffer.append(DOT);
        }
        this.buffer.append(reference.simpleName());
        if (!reference.generics().isEmpty()) {
            this.buffer.append("<");
            for (int i = 0; i < reference.generics().size(); ++i) {
                Reference r = (Reference)reference.generics().get(i);
                r.accept(this);
                if (i >= reference.generics().size() - 1) continue;
                this.buffer.append(COMMA);
                this.buffer.append(SPACE);
            }
            this.buffer.append(RIGHT_ANGLE);
        }
    }

    @Override
    public void visit(VaporReference reference) {
        String pakkage = reference.pakkage();
        String shortName = reference.name();
        if (reference.useFullName() || this.importWriterVisitor.collidesWithImport(pakkage, shortName)) {
            this.buffer.append(pakkage);
            this.buffer.append(DOT);
            if (reference.hasEnclosingClass()) {
                this.buffer.append(String.join((CharSequence)DOT, reference.enclosingClassNames()));
                this.buffer.append(DOT);
            }
        }
        this.buffer.append(shortName);
    }

    @Override
    public void visit(ValueExpr valueExpr) {
        this.buffer.append(valueExpr.value().value());
    }

    @Override
    public void visit(VariableExpr variableExpr) {
        Variable variable = variableExpr.variable();
        TypeNode type = variable.type();
        ScopeNode scope = variableExpr.scope();
        if (variableExpr.isDecl()) {
            this.annotations(variableExpr.annotations());
            if (!scope.equals(ScopeNode.LOCAL)) {
                scope.accept(this);
                this.space();
            }
            if (variableExpr.isStatic()) {
                this.buffer.append(STATIC);
                this.space();
            }
            if (variableExpr.isFinal()) {
                this.buffer.append(FINAL);
                this.space();
            }
            if (variableExpr.isVolatile()) {
                this.buffer.append(VOLATILE);
                this.space();
            }
            type.accept(this);
            if (!variableExpr.templateNodes().isEmpty()) {
                this.leftAngle();
                IntStream.range(0, variableExpr.templateNodes().size()).forEach(i -> {
                    ((AstNode)variableExpr.templateNodes().get(i)).accept(this);
                    if (i < variableExpr.templateNodes().size() - 1) {
                        this.buffer.append(COMMA);
                        this.space();
                    }
                });
                this.rightAngle();
            }
            this.space();
        } else if (variableExpr.exprReferenceExpr() != null) {
            variableExpr.exprReferenceExpr().accept(this);
            this.buffer.append(DOT);
        } else if (variableExpr.staticReferenceType() != null) {
            variableExpr.staticReferenceType().accept(this);
            this.buffer.append(DOT);
        }
        variable.identifier().accept(this);
    }

    @Override
    public void visit(TernaryExpr ternaryExpr) {
        ternaryExpr.conditionExpr().accept(this);
        this.space();
        this.buffer.append(QUESTION_MARK);
        this.space();
        ternaryExpr.thenExpr().accept(this);
        this.space();
        this.buffer.append(COLON);
        this.space();
        ternaryExpr.elseExpr().accept(this);
    }

    @Override
    public void visit(AssignmentExpr assignmentExpr) {
        assignmentExpr.variableExpr().accept(this);
        this.space();
        this.buffer.append(EQUALS);
        this.space();
        assignmentExpr.valueExpr().accept(this);
    }

    @Override
    public void visit(MethodInvocationExpr methodInvocationExpr) {
        int i;
        if (methodInvocationExpr.exprReferenceExpr() != null) {
            methodInvocationExpr.exprReferenceExpr().accept(this);
            this.buffer.append(DOT);
        } else if (methodInvocationExpr.staticReferenceType() != null) {
            methodInvocationExpr.staticReferenceType().accept(this);
            this.buffer.append(DOT);
        }
        if (methodInvocationExpr.isGeneric()) {
            this.leftAngle();
            int numGenerics = methodInvocationExpr.generics().size();
            for (i = 0; i < numGenerics; ++i) {
                Reference r = methodInvocationExpr.generics().get(i);
                r.accept(this);
                if (i >= numGenerics - 1) continue;
                this.buffer.append(COMMA);
                this.space();
            }
            this.rightAngle();
        }
        methodInvocationExpr.methodIdentifier().accept(this);
        this.leftParen();
        int numArguments = methodInvocationExpr.arguments().size();
        for (i = 0; i < numArguments; ++i) {
            Expr argExpr = methodInvocationExpr.arguments().get(i);
            argExpr.accept(this);
            if (i >= numArguments - 1) continue;
            this.buffer.append(COMMA);
            this.space();
        }
        this.rightParen();
    }

    @Override
    public void visit(CastExpr castExpr) {
        this.leftParen();
        this.leftParen();
        castExpr.type().accept(this);
        this.rightParen();
        this.space();
        castExpr.expr().accept(this);
        this.rightParen();
    }

    @Override
    public void visit(AnonymousClassExpr anonymousClassExpr) {
        this.buffer.append(NEW);
        this.space();
        anonymousClassExpr.type().accept(this);
        this.leftParen();
        this.rightParen();
        this.space();
        this.leftBrace();
        this.newline();
        this.statements(anonymousClassExpr.statements());
        this.methods(anonymousClassExpr.methods());
        this.rightBrace();
    }

    @Override
    public void visit(ThrowExpr throwExpr) {
        this.buffer.append(THROW);
        this.space();
        if (throwExpr.throwExpr() != null) {
            throwExpr.throwExpr().accept(this);
            return;
        }
        this.buffer.append(NEW);
        this.space();
        throwExpr.type().accept(this);
        this.leftParen();
        if (throwExpr.messageExpr() != null) {
            throwExpr.messageExpr().accept(this);
        }
        if (throwExpr.causeExpr() != null) {
            if (throwExpr.messageExpr() != null) {
                this.buffer.append(COMMA);
                this.space();
            }
            throwExpr.causeExpr().accept(this);
        }
        this.rightParen();
    }

    @Override
    public void visit(InstanceofExpr instanceofExpr) {
        instanceofExpr.expr().accept(this);
        this.space();
        this.buffer.append(INSTANCEOF);
        this.space();
        instanceofExpr.checkType().accept(this);
    }

    @Override
    public void visit(NewObjectExpr newObjectExpr) {
        this.buffer.append(NEW);
        this.space();
        newObjectExpr.type().accept(this);
        if (newObjectExpr.isGeneric() && newObjectExpr.type().reference().generics().isEmpty()) {
            this.leftAngle();
            this.rightAngle();
        }
        this.leftParen();
        int numArguments = newObjectExpr.arguments().size();
        for (int i = 0; i < numArguments; ++i) {
            ((Expr)newObjectExpr.arguments().get(i)).accept(this);
            if (i >= numArguments - 1) continue;
            this.buffer.append(COMMA);
            this.space();
        }
        this.rightParen();
    }

    @Override
    public void visit(EnumRefExpr enumRefExpr) {
        enumRefExpr.type().accept(this);
        this.buffer.append(DOT);
        enumRefExpr.identifier().accept(this);
    }

    @Override
    public void visit(ReturnExpr returnExpr) {
        this.buffer.append(RETURN);
        this.space();
        returnExpr.expr().accept(this);
    }

    @Override
    public void visit(ReferenceConstructorExpr referenceConstructorExpr) {
        this.buffer.append(referenceConstructorExpr.keywordKind().name().toLowerCase());
        this.leftParen();
        IntStream.range(0, referenceConstructorExpr.arguments().size()).forEach(i -> {
            ((Expr)referenceConstructorExpr.arguments().get(i)).accept(this);
            if (i < referenceConstructorExpr.arguments().size() - 1) {
                this.buffer.append(COMMA);
                this.space();
            }
        });
        this.rightParen();
    }

    @Override
    public void visit(ArithmeticOperationExpr arithmeticOperationExpr) {
        arithmeticOperationExpr.lhsExpr().accept(this);
        this.space();
        this.operator(arithmeticOperationExpr.operatorKind());
        this.space();
        arithmeticOperationExpr.rhsExpr().accept(this);
    }

    @Override
    public void visit(UnaryOperationExpr unaryOperationExpr) {
        if (unaryOperationExpr.operatorKind().isPrefixOperator()) {
            this.operator(unaryOperationExpr.operatorKind());
            unaryOperationExpr.expr().accept(this);
        } else {
            unaryOperationExpr.expr().accept(this);
            this.operator(unaryOperationExpr.operatorKind());
        }
    }

    @Override
    public void visit(RelationalOperationExpr relationalOperationExpr) {
        relationalOperationExpr.lhsExpr().accept(this);
        this.space();
        this.operator(relationalOperationExpr.operatorKind());
        this.space();
        relationalOperationExpr.rhsExpr().accept(this);
    }

    @Override
    public void visit(LogicalOperationExpr logicalOperationExpr) {
        logicalOperationExpr.lhsExpr().accept(this);
        this.space();
        this.operator(logicalOperationExpr.operatorKind());
        this.space();
        logicalOperationExpr.rhsExpr().accept(this);
    }

    @Override
    public void visit(AssignmentOperationExpr assignmentOperationExpr) {
        assignmentOperationExpr.variableExpr().accept(this);
        this.space();
        this.operator(assignmentOperationExpr.operatorKind());
        this.space();
        assignmentOperationExpr.valueExpr().accept(this);
    }

    @Override
    public void visit(LambdaExpr lambdaExpr) {
        if (lambdaExpr.arguments().isEmpty()) {
            this.leftParen();
            this.rightParen();
        } else if (lambdaExpr.arguments().size() == 1) {
            ((VariableExpr)lambdaExpr.arguments().get(0)).variable().identifier().accept(this);
        } else {
            this.leftParen();
            int numArguments = lambdaExpr.arguments().size();
            for (int i = 0; i < numArguments; ++i) {
                ((VariableExpr)lambdaExpr.arguments().get(i)).accept(this);
                if (i >= numArguments - 1) continue;
                this.buffer.append(COMMA);
                this.space();
            }
            this.rightParen();
        }
        this.space();
        this.buffer.append("->");
        this.space();
        if (lambdaExpr.body().isEmpty()) {
            lambdaExpr.returnExpr().expr().accept(this);
            return;
        }
        this.leftBrace();
        this.newline();
        this.statements(lambdaExpr.body());
        ExprStatement.withExpr(lambdaExpr.returnExpr()).accept(this);
        this.rightBrace();
    }

    @Override
    public void visit(ExprStatement exprStatement) {
        exprStatement.expression().accept(this);
        this.semicolon();
        this.newline();
    }

    @Override
    public void visit(BlockStatement blockStatement) {
        if (blockStatement.isStatic()) {
            this.buffer.append(STATIC);
            this.space();
        }
        this.leftBrace();
        this.newline();
        this.statements(blockStatement.body());
        this.rightBrace();
        this.newline();
    }

    @Override
    public void visit(IfStatement ifStatement) {
        this.buffer.append(IF);
        this.space();
        this.leftParen();
        ifStatement.conditionExpr().accept(this);
        this.rightParen();
        this.space();
        this.leftBrace();
        this.newline();
        this.statements(ifStatement.body());
        this.buffer.append(RIGHT_BRACE);
        if (!ifStatement.elseIfs().isEmpty()) {
            for (Map.Entry elseIfEntry : ifStatement.elseIfs().entrySet()) {
                Expr elseIfConditionExpr = (Expr)elseIfEntry.getKey();
                List elseIfBody = (List)elseIfEntry.getValue();
                this.space();
                this.buffer.append(ELSE);
                this.space();
                this.buffer.append(IF);
                this.space();
                this.leftParen();
                elseIfConditionExpr.accept(this);
                this.rightParen();
                this.space();
                this.leftBrace();
                this.newline();
                this.statements(elseIfBody);
                this.rightBrace();
            }
        }
        if (!ifStatement.elseBody().isEmpty()) {
            this.space();
            this.buffer.append(ELSE);
            this.space();
            this.leftBrace();
            this.newline();
            this.statements(ifStatement.elseBody());
            this.rightBrace();
        }
        this.newline();
    }

    @Override
    public void visit(ForStatement forStatement) {
        this.buffer.append(FOR);
        this.space();
        this.leftParen();
        forStatement.localVariableExpr().accept(this);
        this.space();
        this.buffer.append(COLON);
        this.space();
        forStatement.collectionExpr().accept(this);
        this.rightParen();
        this.space();
        this.leftBrace();
        this.newline();
        this.statements(forStatement.body());
        this.rightBrace();
        this.newline();
    }

    @Override
    public void visit(GeneralForStatement generalForStatement) {
        this.buffer.append(FOR);
        this.space();
        this.leftParen();
        generalForStatement.initializationExpr().accept(this);
        this.semicolon();
        this.space();
        generalForStatement.terminationExpr().accept(this);
        this.semicolon();
        this.space();
        generalForStatement.updateExpr().accept(this);
        this.rightParen();
        this.space();
        this.leftBrace();
        this.newline();
        this.statements(generalForStatement.body());
        this.rightBrace();
        this.newline();
    }

    @Override
    public void visit(WhileStatement whileStatement) {
        this.buffer.append(WHILE);
        this.space();
        this.leftParen();
        whileStatement.conditionExpr().accept(this);
        this.rightParen();
        this.space();
        this.leftBrace();
        this.newline();
        this.statements(whileStatement.body());
        this.rightBrace();
        this.newline();
    }

    @Override
    public void visit(TryCatchStatement tryCatchStatement) {
        this.buffer.append(TRY);
        this.space();
        if (tryCatchStatement.tryResourceExpr() != null) {
            this.leftParen();
            tryCatchStatement.tryResourceExpr().accept(this);
            this.rightParen();
            this.space();
        }
        this.leftBrace();
        this.newline();
        this.statements(tryCatchStatement.tryBody());
        this.rightBrace();
        for (int i = 0; i < tryCatchStatement.catchVariableExprs().size(); ++i) {
            this.space();
            this.buffer.append(CATCH);
            this.space();
            this.leftParen();
            tryCatchStatement.catchVariableExprs().get(i).accept(this);
            this.rightParen();
            this.space();
            this.leftBrace();
            this.newline();
            this.statements(tryCatchStatement.catchBlocks().get(i));
            this.rightBrace();
        }
        this.newline();
    }

    @Override
    public void visit(SynchronizedStatement synchronizedStatement) {
        this.buffer.append(SYNCHRONIZED);
        this.space();
        this.leftParen();
        synchronizedStatement.lock().accept(this);
        this.rightParen();
        this.space();
        this.leftBrace();
        this.newline();
        this.statements(synchronizedStatement.body());
        this.rightBrace();
        this.newline();
    }

    @Override
    public void visit(CommentStatement commentStatement) {
        commentStatement.comment().accept(this);
    }

    @Override
    public void visit(EmptyLineStatement emptyLineStatement) {
        this.newline();
    }

    @Override
    public void visit(BreakStatement breakStatement) {
        this.buffer.append(BREAK);
        this.semicolon();
    }

    @Override
    public void visit(LineComment lineComment) {
        String formattedSource = JavaFormatter.format(String.format("// %s", String.join((CharSequence)"\n//", lineComment.comment().split("\\r?\\n"))));
        this.buffer.append(formattedSource);
    }

    @Override
    public void visit(BlockComment blockComment) {
        StringBuilder sourceComment = new StringBuilder();
        sourceComment.append(BLOCK_COMMENT_START).append(NEWLINE);
        Arrays.stream(blockComment.comment().split("\\r?\\n")).forEach(comment -> sourceComment.append(String.format("%s %s%s", ASTERISK, comment, NEWLINE)));
        sourceComment.append(BLOCK_COMMENT_END);
        this.buffer.append(JavaFormatter.format(sourceComment.toString()));
    }

    @Override
    public void visit(JavaDocComment javaDocComment) {
        StringBuilder sourceComment = new StringBuilder();
        sourceComment.append(JAVADOC_COMMENT_START).append(NEWLINE);
        Arrays.stream(javaDocComment.comment().split("\\r?\\n")).forEach(comment -> sourceComment.append(String.format("%s %s%s", ASTERISK, comment, NEWLINE)));
        sourceComment.append(BLOCK_COMMENT_END);
        this.buffer.append(JavaFormatter.format(sourceComment.toString()));
    }

    @Override
    public void visit(MethodDefinition methodDefinition) {
        this.statements(methodDefinition.headerCommentStatements().stream().collect(Collectors.toList()));
        this.annotations(methodDefinition.annotations());
        methodDefinition.scope().accept(this);
        this.space();
        if (!methodDefinition.templateIdentifiers().isEmpty()) {
            this.leftAngle();
            IntStream.range(0, methodDefinition.templateIdentifiers().size()).forEach(i -> {
                ((IdentifierNode)methodDefinition.templateIdentifiers().get(i)).accept(this);
                if (i < methodDefinition.templateIdentifiers().size() - 1) {
                    this.buffer.append(COMMA);
                    this.space();
                }
            });
            this.rightAngle();
            this.space();
        }
        if (methodDefinition.isAbstract()) {
            this.buffer.append(ABSTRACT);
            this.space();
        }
        if (methodDefinition.isStatic()) {
            this.buffer.append(STATIC);
            this.space();
        }
        if (methodDefinition.isFinal()) {
            this.buffer.append(FINAL);
            this.space();
        }
        if (!methodDefinition.isConstructor()) {
            methodDefinition.returnType().accept(this);
            if (!methodDefinition.returnTemplateIdentifiers().isEmpty()) {
                this.leftAngle();
                IntStream.range(0, methodDefinition.returnTemplateIdentifiers().size()).forEach(i -> {
                    ((IdentifierNode)methodDefinition.returnTemplateIdentifiers().get(i)).accept(this);
                    if (i < methodDefinition.returnTemplateIdentifiers().size() - 1) {
                        this.buffer.append(COMMA);
                        this.space();
                    }
                });
                this.rightAngle();
            }
            this.space();
        }
        methodDefinition.methodIdentifier().accept(this);
        this.leftParen();
        int numArguments = methodDefinition.arguments().size();
        for (int i2 = 0; i2 < numArguments; ++i2) {
            ((VariableExpr)methodDefinition.arguments().get(i2)).accept(this);
            if (i2 >= numArguments - 1) continue;
            this.buffer.append(COMMA);
            this.space();
        }
        this.rightParen();
        if (!methodDefinition.throwsExceptions().isEmpty()) {
            this.space();
            this.buffer.append(THROWS);
            this.space();
            Iterator exceptionIter = methodDefinition.throwsExceptions().iterator();
            while (exceptionIter.hasNext()) {
                TypeNode exceptionType = (TypeNode)exceptionIter.next();
                exceptionType.accept(this);
                if (!exceptionIter.hasNext()) continue;
                this.buffer.append(COMMA);
                this.space();
            }
        }
        if (methodDefinition.isAbstract() && methodDefinition.body().isEmpty()) {
            this.semicolon();
            this.newline();
            return;
        }
        this.space();
        this.leftBrace();
        this.newline();
        this.statements(methodDefinition.body());
        if (methodDefinition.returnExpr() != null) {
            ExprStatement.withExpr(methodDefinition.returnExpr()).accept(this);
        }
        this.rightBrace();
        this.newline();
        this.newline();
    }

    @Override
    public void visit(ClassDefinition classDefinition) {
        if (!classDefinition.isNested()) {
            this.statements(classDefinition.fileHeader().stream().collect(Collectors.toList()));
            this.newline();
            this.importWriterVisitor.initialize(classDefinition.packageString(), classDefinition.classIdentifier().name());
            this.buffer.append(String.format("package %s;", classDefinition.packageString()));
            this.newline();
            this.newline();
        }
        String regionTagReplace = "REPLACE_REGION_TAG";
        if (classDefinition.regionTag() != null) {
            Statement[] statementArray = new Statement[1];
            classDefinition.regionTag();
            statementArray[0] = RegionTag.generateTag(RegionTag.RegionTagRegion.START, regionTagReplace);
            this.statements(Arrays.asList(statementArray));
        }
        classDefinition.accept(this.importWriterVisitor);
        if (!classDefinition.isNested()) {
            this.buffer.append(this.importWriterVisitor.write());
        }
        this.statements(classDefinition.headerCommentStatements().stream().collect(Collectors.toList()));
        this.annotations(classDefinition.annotations());
        classDefinition.scope().accept(this);
        this.space();
        if (classDefinition.isStatic()) {
            this.buffer.append(STATIC);
            this.space();
        }
        if (classDefinition.isFinal()) {
            this.buffer.append(FINAL);
            this.space();
        }
        if (classDefinition.isAbstract()) {
            this.buffer.append(ABSTRACT);
            this.space();
        }
        this.buffer.append(CLASS);
        this.space();
        classDefinition.classIdentifier().accept(this);
        this.space();
        if (classDefinition.extendsType() != null) {
            this.buffer.append(EXTENDS);
            this.space();
            classDefinition.extendsType().accept(this);
            this.space();
        }
        if (!classDefinition.implementsTypes().isEmpty()) {
            this.buffer.append(IMPLEMENTS);
            this.space();
            int numImplementsTypes = classDefinition.implementsTypes().size();
            for (int i = 0; i < numImplementsTypes; ++i) {
                ((TypeNode)classDefinition.implementsTypes().get(i)).accept(this);
                if (i < numImplementsTypes - 1) {
                    this.buffer.append(COMMA);
                }
                this.space();
            }
        }
        this.leftBrace();
        this.newline();
        this.statements(classDefinition.statements());
        this.newline();
        this.methods(classDefinition.methods());
        this.newline();
        this.classes(classDefinition.nestedClasses());
        this.rightBrace();
        if (classDefinition.regionTag() != null) {
            Statement[] statementArray = new Statement[1];
            classDefinition.regionTag();
            statementArray[0] = RegionTag.generateTag(RegionTag.RegionTagRegion.END, regionTagReplace);
            this.statements(Arrays.asList(statementArray));
        }
        if (!classDefinition.isNested()) {
            String formattedClazz = JavaFormatter.format(this.buffer.toString());
            if (classDefinition.regionTag() != null) {
                formattedClazz = formattedClazz.replaceAll(regionTagReplace, classDefinition.regionTag().generate());
                formattedClazz = formattedClazz.replaceAll("} // \\[END", "}\n// \\[END");
            }
            this.buffer.replace(0, this.buffer.length(), formattedClazz);
        }
    }

    @Override
    public void visit(PackageInfoDefinition packageInfoDefinition) {
        this.statements(packageInfoDefinition.fileHeader().stream().collect(Collectors.toList()));
        this.newline();
        this.statements(packageInfoDefinition.headerCommentStatements().stream().collect(Collectors.toList()));
        this.newline();
        this.annotations(packageInfoDefinition.annotations());
        this.buffer.append(String.format("package %s;", packageInfoDefinition.pakkage()));
        this.newline();
        packageInfoDefinition.accept(this.importWriterVisitor);
        this.importWriterVisitor.initialize(packageInfoDefinition.pakkage());
        this.buffer.append(this.importWriterVisitor.write());
        this.buffer.replace(0, this.buffer.length(), JavaFormatter.format(this.buffer.toString()));
    }

    private void annotations(List<AnnotationNode> annotations) {
        for (AnnotationNode annotation : annotations) {
            annotation.accept(this);
        }
    }

    private void statements(List<Statement> statements) {
        for (Statement statement : statements) {
            statement.accept(this);
        }
    }

    private void methods(List<MethodDefinition> methods) {
        for (MethodDefinition method : methods) {
            method.accept(this);
        }
    }

    private void classes(List<ClassDefinition> classes) {
        if (!classes.isEmpty()) {
            this.newline();
        }
        for (ClassDefinition classDef : classes) {
            classDef.accept(this);
            this.newline();
            this.newline();
        }
    }

    private void space() {
        this.buffer.append(SPACE);
    }

    private void newline() {
        this.buffer.append(NEWLINE);
    }

    private void leftParen() {
        this.buffer.append(LEFT_PAREN);
    }

    private void rightParen() {
        this.buffer.append(RIGHT_PAREN);
    }

    private void leftAngle() {
        this.buffer.append("<");
    }

    private void rightAngle() {
        this.buffer.append(RIGHT_ANGLE);
    }

    private void leftBrace() {
        this.buffer.append(LEFT_BRACE);
    }

    private void rightBrace() {
        this.buffer.append(RIGHT_BRACE);
    }

    private void semicolon() {
        this.buffer.append(SEMICOLON);
    }

    private void operator(OperatorKind kind) {
        switch (kind) {
            case ARITHMETIC_ADDITION: {
                this.buffer.append(OPERATOR_ADDITION);
                break;
            }
            case ASSIGNMENT_XOR: {
                this.buffer.append(OPERATOR_XOR);
                break;
            }
            case ASSIGNMENT_MULTIPLY: {
                this.buffer.append(OPERATOR_MULTIPLE_AND_ASSIGNMENT);
                break;
            }
            case RELATIONAL_EQUAL_TO: {
                this.buffer.append(OPERATOR_EQUAL_TO);
                break;
            }
            case RELATIONAL_NOT_EQUAL_TO: {
                this.buffer.append(OPERATOR_NOT_EQUAL_TO);
                break;
            }
            case RELATIONAL_LESS_THAN: {
                this.buffer.append("<");
                break;
            }
            case UNARY_POST_INCREMENT: {
                this.buffer.append(OPERATOR_INCREMENT);
                break;
            }
            case UNARY_LOGICAL_NOT: {
                this.buffer.append(OPERATOR_LOGICAL_NOT);
                break;
            }
            case LOGICAL_AND: {
                this.buffer.append(OPERATOR_LOGICAL_AND);
                break;
            }
            case LOGICAL_OR: {
                this.buffer.append(OPERATOR_LOGICAL_OR);
            }
        }
    }
}

