/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_GeneralForStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.RelationalOperationExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.UnaryOperationExpr;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class GeneralForStatement
implements Statement {
    public abstract Expr initializationExpr();

    public abstract Expr terminationExpr();

    public abstract Expr updateExpr();

    public abstract ImmutableList<Statement> body();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static GeneralForStatement incrementWith(VariableExpr localVariableExpr, ValueExpr initialValueExpr, Expr maxSizeExpr, List<Statement> body) {
        return GeneralForStatement.builder().setInitializationExpr(AssignmentExpr.builder().setVariableExpr(localVariableExpr).setValueExpr(initialValueExpr).build()).setTerminationExpr(RelationalOperationExpr.lessThanWithExprs(localVariableExpr.toBuilder().setIsDecl(false).build(), maxSizeExpr)).setUpdateExpr(UnaryOperationExpr.postfixIncrementWithExpr(localVariableExpr.toBuilder().setIsDecl(false).build())).setBody(body).build();
    }

    private static Builder builder() {
        return new AutoValue_GeneralForStatement.Builder().setBody(Collections.emptyList());
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setInitializationExpr(Expr var1);

        abstract Builder setTerminationExpr(Expr var1);

        abstract Builder setUpdateExpr(Expr var1);

        abstract Builder setBody(List<Statement> var1);

        abstract GeneralForStatement autoBuild();

        GeneralForStatement build() {
            VariableExpr localVarExpr;
            GeneralForStatement generalForStatement = this.autoBuild();
            NodeValidator.checkNoNullElements(generalForStatement.body(), "body", "general for-statement");
            Expr initExpr = generalForStatement.initializationExpr();
            if (initExpr instanceof AssignmentExpr && (localVarExpr = ((AssignmentExpr)initExpr).variableExpr()).isDecl()) {
                Preconditions.checkState(localVarExpr.scope().equals(ScopeNode.LOCAL), String.format("Variable %s declare in a general for-loop cannot have a non-local scope", localVarExpr.variable().identifier().name()));
                Preconditions.checkState(!localVarExpr.isStatic(), "Modifier 'static' not allow here.");
            }
            return this.autoBuild();
        }
    }
}

