/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_TypeNode;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.lang.model.type.NullType;

@AutoValue
public abstract class TypeNode
implements AstNode,
Comparable<TypeNode> {
    static final Reference EXCEPTION_REFERENCE = ConcreteReference.withClazz(Exception.class);
    public static final Reference WILDCARD_REFERENCE = ConcreteReference.wildcard();
    public static final TypeNode BOOLEAN = TypeNode.builder().setTypeKind(TypeKind.BOOLEAN).build();
    public static final TypeNode BYTE = TypeNode.builder().setTypeKind(TypeKind.BYTE).build();
    public static final TypeNode CHAR = TypeNode.builder().setTypeKind(TypeKind.CHAR).build();
    public static final TypeNode DOUBLE = TypeNode.builder().setTypeKind(TypeKind.DOUBLE).build();
    public static final TypeNode FLOAT = TypeNode.builder().setTypeKind(TypeKind.FLOAT).build();
    public static final TypeNode INT = TypeNode.builder().setTypeKind(TypeKind.INT).build();
    public static final TypeNode LONG = TypeNode.builder().setTypeKind(TypeKind.LONG).build();
    public static final TypeNode SHORT = TypeNode.builder().setTypeKind(TypeKind.SHORT).build();
    public static final TypeNode BOOLEAN_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Boolean.class));
    public static final TypeNode BYTE_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Byte.class));
    public static final TypeNode CHAR_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Character.class));
    public static final TypeNode DOUBLE_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Double.class));
    public static final TypeNode FLOAT_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Float.class));
    public static final TypeNode INT_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Integer.class));
    public static final TypeNode LONG_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Long.class));
    public static final TypeNode SHORT_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Short.class));
    public static final TypeNode CLASS_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Class.class));
    public static final TypeNode BYTESTRING = TypeNode.withReference(ConcreteReference.withClazz(ByteString.class));
    public static final TypeNode VALUE = TypeNode.withReference(VaporReference.builder().setName("Value").setPakkage("com.google.protobuf").build());
    private static final Map<TypeNode, TypeNode> BOXED_TYPE_MAP = TypeNode.createBoxedTypeMap();
    public static final TypeNode VOID = TypeNode.builder().setTypeKind(TypeKind.VOID).build();
    public static final TypeNode NULL = TypeNode.withReference(ConcreteReference.withClazz(NullType.class));
    public static final TypeNode OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Object.class));
    public static final TypeNode STRING = TypeNode.withReference(ConcreteReference.withClazz(String.class));
    public static final TypeNode VOID_OBJECT = TypeNode.withReference(ConcreteReference.withClazz(Void.class));
    public static final TypeNode THROWABLE = TypeNode.withReference(ConcreteReference.withClazz(Throwable.class));
    public static final TypeNode DEPRECATED = TypeNode.withReference(ConcreteReference.withClazz(Deprecated.class));
    public static final TypeNode STRING_ARRAY = TypeNode.builder().setTypeKind(TypeKind.OBJECT).setReference(ConcreteReference.withClazz(String.class)).setIsArray(true).build();

    public abstract TypeKind typeKind();

    public abstract boolean isArray();

    public static TypeNode createArrayTypeOf(TypeNode type) {
        return TypeNode.builder().setTypeKind(type.typeKind()).setReference(type.reference()).setIsArray(true).build();
    }

    public static TypeNode createElementTypeFromArrayType(TypeNode type) {
        Preconditions.checkArgument(type.isArray(), "Input type must be an array");
        return TypeNode.builder().setTypeKind(type.typeKind()).setReference(type.reference()).setIsArray(false).build();
    }

    @Nullable
    public abstract Reference reference();

    @Override
    public int compareTo(TypeNode other) {
        if (this.isPrimitiveType()) {
            if (other.isPrimitiveType()) {
                return this.typeKind().name().compareTo(other.typeKind().name());
            }
            return -1;
        }
        if (this.equals(NULL)) {
            return other.isPrimitiveType() ? 1 : -1;
        }
        if (other.isPrimitiveType() || other.equals(NULL)) {
            return 1;
        }
        return this.reference().fullName().compareTo(other.reference().fullName());
    }

    public static Builder builder() {
        return new AutoValue_TypeNode.Builder().setIsArray(false);
    }

    public static TypeNode withReference(Reference reference) {
        return TypeNode.builder().setTypeKind(TypeKind.OBJECT).setReference(reference).build();
    }

    public static TypeNode withExceptionClazz(Class<?> clazz) {
        Preconditions.checkState(Exception.class.isAssignableFrom(clazz));
        return TypeNode.withReference(ConcreteReference.withClazz(clazz));
    }

    public static boolean isExceptionType(TypeNode type) {
        return TypeNode.isReferenceType(type) && EXCEPTION_REFERENCE.isAssignableFrom(type.reference());
    }

    public static boolean isReferenceType(TypeNode type) {
        return !TypeNode.isPrimitiveType(type.typeKind()) && type.typeKind().equals((Object)TypeKind.OBJECT) && type.reference() != null && !type.equals(NULL);
    }

    public static boolean isNumericType(TypeNode type) {
        return type.equals(INT) || type.equals(LONG) || type.equals(DOUBLE) || type.equals(SHORT) || type.equals(FLOAT) || type.equals(CHAR) || type.equals(BYTE);
    }

    public static boolean isFloatingPointType(TypeNode type) {
        return type.equals(DOUBLE) || type.equals(FLOAT);
    }

    public static boolean isBoxedType(TypeNode type) {
        return TypeNode.isReferenceType(type) && BOXED_TYPE_MAP.containsValue(type);
    }

    public boolean isPrimitiveType() {
        return TypeNode.isPrimitiveType(this.typeKind());
    }

    public boolean isProtoPrimitiveType() {
        return this.isPrimitiveType() || this.equals(STRING) || this.equals(BYTESTRING);
    }

    public boolean isProtoEmptyType() {
        return this.reference().pakkage().equals("com.google.protobuf") && this.reference().name().equals("Empty");
    }

    public boolean isSupertypeOrEquals(TypeNode other) {
        boolean oneTypeIsNull = this.equals(NULL) ^ other.equals(NULL);
        return !this.isPrimitiveType() && !other.isPrimitiveType() && this.isArray() == other.isArray() && (this.reference().isSupertypeOrEquals(other.reference()) || oneTypeIsNull);
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeNode)) {
            return false;
        }
        TypeNode type = (TypeNode)o;
        return this.strictEquals(type) || this.isBoxedTypeEquals(type);
    }

    public int hashCode() {
        int hash = 17 * this.typeKind().hashCode() + 19 * (this.isArray() ? 1 : 3);
        if (this.reference() != null) {
            hash += 23 * this.reference().hashCode();
        }
        return hash;
    }

    @VisibleForTesting
    boolean strictEquals(TypeNode other) {
        return this.typeKind().equals((Object)other.typeKind()) && this.isArray() == other.isArray() && Objects.equals(this.reference(), other.reference());
    }

    @VisibleForTesting
    boolean isBoxedTypeEquals(TypeNode other) {
        if (this.isArray() || other.isArray()) {
            return false;
        }
        if (other.isPrimitiveType()) {
            return Objects.equals(this, BOXED_TYPE_MAP.get(other));
        }
        return Objects.equals(other, BOXED_TYPE_MAP.get(this));
    }

    private static boolean isPrimitiveType(TypeKind typeKind) {
        return !typeKind.equals((Object)TypeKind.OBJECT);
    }

    private static Map<TypeNode, TypeNode> createBoxedTypeMap() {
        HashMap<TypeNode, TypeNode> map = new HashMap<TypeNode, TypeNode>();
        map.put(INT, INT_OBJECT);
        map.put(BOOLEAN, BOOLEAN_OBJECT);
        map.put(BYTE, BYTE_OBJECT);
        map.put(CHAR, CHAR_OBJECT);
        map.put(FLOAT, FLOAT_OBJECT);
        map.put(LONG, LONG_OBJECT);
        map.put(SHORT, SHORT_OBJECT);
        map.put(DOUBLE, DOUBLE_OBJECT);
        return map;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setTypeKind(TypeKind var1);

        public abstract Builder setIsArray(boolean var1);

        public abstract Builder setReference(Reference var1);

        abstract Reference reference();

        abstract TypeNode autoBuild();

        public TypeNode build() {
            if (this.reference() != null) {
                Preconditions.checkState(!this.reference().isWildcard(), String.format("The top-level referenece in a type cannot be a wildcard, found %s", this.reference().name()));
            }
            return this.autoBuild();
        }
    }

    public static enum TypeKind {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        CHAR,
        OBJECT,
        VOID;

    }
}

