/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.ClientProto;
import com.google.api.DocumentationRule;
import com.google.api.FieldBehavior;
import com.google.api.FieldBehaviorProto;
import com.google.api.FieldInfo;
import com.google.api.FieldInfoProto;
import com.google.api.HttpRule;
import com.google.api.MethodSettings;
import com.google.api.ResourceDescriptor;
import com.google.api.ResourceProto;
import com.google.api.ResourceReference;
import com.google.api.Service;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.GapicBatchingSettings;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicLanguageSettings;
import com.google.api.generator.gapic.model.GapicLroRetrySettings;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.HttpBindings;
import com.google.api.generator.gapic.model.LongrunningOperation;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.OperationResponse;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.RoutingHeaderRule;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.model.SourceCodeInfoLocation;
import com.google.api.generator.gapic.model.Transport;
import com.google.api.generator.gapic.protoparser.BatchingSettingsConfigParser;
import com.google.api.generator.gapic.protoparser.GapicLanguageSettingsParser;
import com.google.api.generator.gapic.protoparser.GapicLroRetrySettingsParser;
import com.google.api.generator.gapic.protoparser.HttpRuleParser;
import com.google.api.generator.gapic.protoparser.MethodSignatureParser;
import com.google.api.generator.gapic.protoparser.PluginArgumentParser;
import com.google.api.generator.gapic.protoparser.ResourceNameParser;
import com.google.api.generator.gapic.protoparser.ResourceParserHelpers;
import com.google.api.generator.gapic.protoparser.ResourceReferenceParser;
import com.google.api.generator.gapic.protoparser.RoutingRuleParser;
import com.google.api.generator.gapic.protoparser.ServiceConfigParser;
import com.google.api.generator.gapic.protoparser.ServiceYamlParser;
import com.google.api.generator.gapic.protoparser.SourceCodeInfoParser;
import com.google.api.generator.gapic.protoparser.TypeParser;
import com.google.cloud.ExtendedOperationsProto;
import com.google.cloud.OperationResponseMapping;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.longrunning.OperationInfo;
import com.google.longrunning.OperationsProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.compiler.PluginProtos;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Parser {
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String DEFAULT_PORT = "443";
    private static final String DOT = ".";
    private static final String SLASH = "/";
    private static final ResourceName WILDCARD_RESOURCE_NAME = ResourceName.createWildcard("*", "com.google.api.wildcard.placeholder");
    private static final Set<String> MIXIN_ALLOWLIST = ImmutableSet.of("google.iam.v1.IAMPolicy", "google.longrunning.Operations", "google.cloud.location.Locations");
    private static final Set<String> MIXIN_JAVA_PACKAGE_ALLOWLIST = ImmutableSet.of("com.google.iam.v1", "com.google.longrunning", "com.google.cloud.location");
    protected static final SourceCodeInfoParser SOURCE_CODE_INFO_PARSER = new SourceCodeInfoParser();

    public static GapicContext parse(PluginProtos.CodeGeneratorRequest request) {
        Transport transport;
        ArrayList<com.google.api.generator.gapic.model.Service> mixinServices;
        HashSet<ResourceName> outputArgResourceNames;
        Optional<String> gapicYamlConfigPathOpt = PluginArgumentParser.parseGapicYamlConfigPath(request);
        Optional<List<GapicBatchingSettings>> batchingSettingsOpt = BatchingSettingsConfigParser.parse(gapicYamlConfigPathOpt);
        Optional<List<GapicLroRetrySettings>> lroRetrySettingsOpt = GapicLroRetrySettingsParser.parse(gapicYamlConfigPathOpt);
        Optional<GapicLanguageSettings> languageSettingsOpt = GapicLanguageSettingsParser.parse(gapicYamlConfigPathOpt);
        Optional<String> transportOpt = PluginArgumentParser.parseTransport(request);
        boolean willGenerateMetadata = PluginArgumentParser.hasMetadataFlag(request);
        boolean willGenerateNumericEnum = PluginArgumentParser.hasNumericEnumFlag(request);
        Optional<String> serviceConfigPathOpt = PluginArgumentParser.parseJsonConfigPath(request);
        Optional<GapicServiceConfig> serviceConfigOpt = ServiceConfigParser.parse(serviceConfigPathOpt.orElse(null));
        if (serviceConfigOpt.isPresent()) {
            GapicServiceConfig serviceConfig = serviceConfigOpt.get();
            serviceConfig.setLroRetrySettings(lroRetrySettingsOpt);
            serviceConfig.setBatchingSettings(batchingSettingsOpt);
            serviceConfig.setLanguageSettings(languageSettingsOpt);
            serviceConfigOpt = Optional.of(serviceConfig);
        }
        Optional<String> serviceYamlConfigPathOpt = PluginArgumentParser.parseServiceYamlConfigPath(request);
        Optional<Service> serviceYamlProtoOpt = serviceYamlConfigPathOpt.flatMap(ServiceYamlParser::parse);
        HashSet<com.google.api.generator.gapic.model.ResourceReference> outputResourceReferencesSeen = new HashSet<com.google.api.generator.gapic.model.ResourceReference>();
        Map<String, Message> messages = Parser.parseMessages(request, outputResourceReferencesSeen);
        Map<String, ResourceName> resourceNames = Parser.parseResourceNames(request);
        List<com.google.api.generator.gapic.model.Service> services = Parser.parseServices(request, messages = Parser.updateResourceNamesInMessages(messages, resourceNames.values()), resourceNames, outputArgResourceNames = new HashSet<ResourceName>(), serviceYamlProtoOpt, serviceConfigOpt, mixinServices = new ArrayList<com.google.api.generator.gapic.model.Service>(), transport = Transport.parse(transportOpt.orElse(Transport.GRPC.toString())));
        Preconditions.checkState(!services.isEmpty(), "No services found to generate");
        if (services.get(0).protoPakkage().startsWith("google.ads.googleads.v")) {
            Function<ResourceName, String> typeNameFn = r -> r.resourceTypeString().substring(r.resourceTypeString().indexOf(SLASH) + 1);
            Function<Set, Set> typeStringSetFn = sr -> sr.stream().map(typeNameFn).collect(Collectors.toSet());
            Set typeStringSet = typeStringSetFn.apply(outputArgResourceNames);
            outputArgResourceNames.addAll(resourceNames.values().stream().filter(r -> r.hasParentMessageName() && !typeStringSet.contains(typeNameFn.apply((ResourceName)r))).collect(Collectors.toSet()));
            String servicePackage = services.get(0).pakkage();
            Map<String, ResourceName> patternsToResourceNames = ResourceParserHelpers.createPatternResourceNameMap(resourceNames);
            for (com.google.api.generator.gapic.model.ResourceReference resourceReference : outputResourceReferencesSeen) {
                Set interimTypeStringSet = typeStringSetFn.apply(outputArgResourceNames);
                outputArgResourceNames.addAll(ResourceReferenceParser.parseResourceNames(resourceReference, servicePackage, null, resourceNames, patternsToResourceNames).stream().filter(r -> !interimTypeStringSet.contains(typeNameFn.apply((ResourceName)r))).collect(Collectors.toSet()));
            }
        }
        return GapicContext.builder().setServices(services).setMixinServices(mixinServices.stream().map(s2 -> s2.toBuilder().setPakkage(((com.google.api.generator.gapic.model.Service)services.get(0)).pakkage()).build()).collect(Collectors.toList())).setMessages(messages).setResourceNames(resourceNames).setHelperResourceNames(outputArgResourceNames).setServiceConfig(serviceConfigOpt.orElse(null)).setGapicMetadataEnabled(willGenerateMetadata).setServiceYamlProto(serviceYamlProtoOpt.orElse(null)).setTransport(transport).setRestNumericEnumsEnabled(willGenerateNumericEnum).build();
    }

    public static List<com.google.api.generator.gapic.model.Service> parseServices(PluginProtos.CodeGeneratorRequest request, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, Set<ResourceName> outputArgResourceNames, Optional<Service> serviceYamlProtoOpt, Optional<GapicServiceConfig> serviceConfigOpt, List<com.google.api.generator.gapic.model.Service> outputMixinServices, Transport transport) {
        Map<String, Descriptors.FileDescriptor> fileDescriptors = Parser.getFilesToGenerate(request);
        ArrayList<com.google.api.generator.gapic.model.Service> services = new ArrayList<com.google.api.generator.gapic.model.Service>();
        for (String fileToGenerate : request.getFileToGenerateList()) {
            Descriptors.FileDescriptor fileDescriptor = Preconditions.checkNotNull(fileDescriptors.get(fileToGenerate), "Missing file descriptor for [%s]", (Object)fileToGenerate);
            services.addAll(Parser.parseService(fileDescriptor, messageTypes, resourceNames, serviceYamlProtoOpt, serviceConfigOpt, outputArgResourceNames, transport));
        }
        Function<com.google.api.generator.gapic.model.Service, String> serviceFullNameFn = s2 -> String.format("%s.%s", s2.protoPakkage(), s2.name());
        HashSet<com.google.api.generator.gapic.model.Service> blockedCodegenMixinApis = new HashSet<com.google.api.generator.gapic.model.Service>();
        HashSet<com.google.api.generator.gapic.model.Service> definedServices = new HashSet<com.google.api.generator.gapic.model.Service>();
        for (com.google.api.generator.gapic.model.Service s3 : services) {
            if (MIXIN_ALLOWLIST.contains(serviceFullNameFn.apply(s3))) {
                blockedCodegenMixinApis.add(s3);
                continue;
            }
            definedServices.add(s3);
        }
        boolean servicesContainBlocklistedApi = !blockedCodegenMixinApis.isEmpty() && !definedServices.isEmpty();
        Set mixedInApis = !serviceYamlProtoOpt.isPresent() ? Collections.emptySet() : serviceYamlProtoOpt.get().getApisList().stream().filter(a -> MIXIN_ALLOWLIST.contains(a.getName())).map(a -> a.getName()).collect(Collectors.toSet());
        HashMap<String, HttpBindings> mixedInMethodsToHttpRules = new HashMap<String, HttpBindings>();
        HashMap<String, String> mixedInMethodsToDocs = new HashMap<String, String>();
        if (serviceYamlProtoOpt.isPresent()) {
            for (HttpRule httpRule : serviceYamlProtoOpt.get().getHttp().getRulesList()) {
                HttpBindings httpBindings = HttpRuleParser.parseHttpRule(httpRule);
                if (httpBindings == null) continue;
                String[] stringArray = httpRule.getSelector().split(COMMA);
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String rpcFullNameRaw = stringArray[i];
                    String rpcFullName = rpcFullNameRaw.trim();
                    mixedInMethodsToHttpRules.put(rpcFullName, httpBindings);
                }
            }
            for (DocumentationRule docRule : serviceYamlProtoOpt.get().getDocumentation().getRulesList()) {
                for (String rpcFullNameRaw : docRule.getSelector().split(COMMA)) {
                    String rpcFullName = rpcFullNameRaw.trim();
                    mixedInMethodsToDocs.put(rpcFullName, docRule.getDescription());
                }
            }
        }
        List orderedBlockedCodegenMixinApis = blockedCodegenMixinApis.stream().sorted((s1, s2) -> s2.name().compareTo(s1.name())).collect(Collectors.toList());
        HashSet apiDefinedRpcs = new HashSet();
        for (com.google.api.generator.gapic.model.Service service : services) {
            if (orderedBlockedCodegenMixinApis.contains(service)) continue;
            apiDefinedRpcs.addAll(service.methods().stream().map(m4 -> m4.name()).collect(Collectors.toSet()));
        }
        HashSet<com.google.api.generator.gapic.model.Service> hashSet = new HashSet<com.google.api.generator.gapic.model.Service>();
        if (servicesContainBlocklistedApi && !mixedInApis.isEmpty()) {
            for (int i = 0; i < services.size(); ++i) {
                com.google.api.generator.gapic.model.Service originalService = (com.google.api.generator.gapic.model.Service)services.get(i);
                ArrayList<Method> updatedOriginalServiceMethods = new ArrayList<Method>(originalService.methods());
                for (com.google.api.generator.gapic.model.Service mixinService : orderedBlockedCodegenMixinApis) {
                    String mixinServiceFullName = serviceFullNameFn.apply(mixinService);
                    if (!mixedInApis.contains(mixinServiceFullName)) continue;
                    Function<Method, String> methodToFullProtoNameFn = m4 -> String.format("%s.%s", mixinServiceFullName, m4.name());
                    List<Method> updatedMixinMethods = mixinService.methods().stream().filter(m4 -> mixedInMethodsToHttpRules.containsKey(methodToFullProtoNameFn.apply((Method)m4))).map(m4 -> {
                        String fullMethodName = (String)methodToFullProtoNameFn.apply((Method)m4);
                        HttpBindings httpBindings = mixedInMethodsToHttpRules.containsKey(fullMethodName) ? (HttpBindings)mixedInMethodsToHttpRules.get(fullMethodName) : m4.httpBindings();
                        String docs = mixedInMethodsToDocs.containsKey(fullMethodName) ? (String)mixedInMethodsToDocs.get(fullMethodName) : m4.description();
                        return m4.toBuilder().setHttpBindings(httpBindings).setDescription(docs).build();
                    }).collect(Collectors.toList());
                    updatedMixinMethods.stream().filter(m4 -> !apiDefinedRpcs.contains(m4.name())).forEach(m4 -> updatedOriginalServiceMethods.add(m4.toBuilder().setMixedInApiName((String)serviceFullNameFn.apply(mixinService)).build()));
                    updatedMixinMethods = updatedMixinMethods.stream().sorted((m1, m22) -> m22.name().compareTo(m1.name())).collect(Collectors.toList());
                    hashSet.add(mixinService.toBuilder().setMethods(updatedMixinMethods).build());
                }
                services.set(i, originalService.toBuilder().setMethods(updatedOriginalServiceMethods).build());
            }
        }
        if (servicesContainBlocklistedApi) {
            services = services.stream().filter(s2 -> !MIXIN_ALLOWLIST.contains(serviceFullNameFn.apply((com.google.api.generator.gapic.model.Service)s2))).collect(Collectors.toList());
        }
        outputMixinServices.addAll(hashSet.stream().sorted((s1, s2) -> s2.name().compareTo(s1.name())).collect(Collectors.toList()));
        return services;
    }

    @VisibleForTesting
    public static List<com.google.api.generator.gapic.model.Service> parseService(Descriptors.FileDescriptor fileDescriptor, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, Optional<Service> serviceYamlProtoOpt, Set<ResourceName> outputArgResourceNames) {
        return Parser.parseService(fileDescriptor, messageTypes, resourceNames, serviceYamlProtoOpt, Optional.empty(), outputArgResourceNames, Transport.GRPC);
    }

    public static List<com.google.api.generator.gapic.model.Service> parseService(Descriptors.FileDescriptor fileDescriptor, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, Optional<Service> serviceYamlProtoOpt, Optional<GapicServiceConfig> serviceConfigOpt, Set<ResourceName> outputArgResourceNames, Transport transport) {
        return fileDescriptor.getServices().stream().map(s2 -> {
            String pakkage;
            String serviceName;
            SourceCodeInfoLocation protoServiceLocation;
            DescriptorProtos.ServiceOptions serviceOptions = s2.getOptions();
            String defaultHost = null;
            if (serviceOptions.hasExtension(ClientProto.defaultHost)) {
                defaultHost = Parser.sanitizeDefaultHost(serviceOptions.getExtension(ClientProto.defaultHost));
            } else if (serviceYamlProtoOpt.isPresent()) {
                defaultHost = ((Service)serviceYamlProtoOpt.get()).getName();
            }
            Preconditions.checkState(!Strings.isNullOrEmpty(defaultHost), String.format("Default host not found in service YAML config file or annotation for %s", s2.getName()));
            List<String> oauthScopes = Collections.emptyList();
            if (serviceOptions.hasExtension(ClientProto.oauthScopes)) {
                oauthScopes = Arrays.asList(serviceOptions.getExtension(ClientProto.oauthScopes).split(COMMA));
            }
            boolean isDeprecated = false;
            if (serviceOptions.hasDeprecated()) {
                isDeprecated = serviceOptions.getDeprecated();
            }
            Service.Builder serviceBuilder = com.google.api.generator.gapic.model.Service.builder();
            if (fileDescriptor.toProto().hasSourceCodeInfo() && !Objects.isNull(protoServiceLocation = SOURCE_CODE_INFO_PARSER.getLocation((Descriptors.ServiceDescriptor)s2)) && !Strings.isNullOrEmpty(protoServiceLocation.getLeadingComments())) {
                serviceBuilder.setDescription(protoServiceLocation.getLeadingComments());
            }
            if (serviceOptions.hasExtension(ClientProto.apiVersion)) {
                String apiVersion = serviceOptions.getExtension(ClientProto.apiVersion);
                serviceBuilder.setApiVersion(apiVersion);
            }
            String overriddenServiceName = serviceName = s2.getName();
            String originalJavaPackage = pakkage = TypeParser.getPackage(fileDescriptor);
            if (serviceConfigOpt.isPresent() && ((GapicServiceConfig)serviceConfigOpt.get()).getLanguageSettingsOpt().isPresent()) {
                GapicLanguageSettings languageSettings = ((GapicServiceConfig)serviceConfigOpt.get()).getLanguageSettingsOpt().get();
                pakkage = languageSettings.pakkage();
                overriddenServiceName = languageSettings.getJavaServiceName(fileDescriptor.getPackage(), s2.getName());
            }
            return serviceBuilder.setName(serviceName).setOverriddenName(overriddenServiceName).setDefaultHost(defaultHost).setOauthScopes(oauthScopes).setPakkage(pakkage).setOriginalJavaPackage(originalJavaPackage).setProtoPakkage(fileDescriptor.getPackage()).setIsDeprecated(isDeprecated).setMethods(Parser.parseMethods(s2, pakkage, messageTypes, resourceNames, serviceConfigOpt, serviceYamlProtoOpt, outputArgResourceNames, transport)).build();
        }).collect(Collectors.toList());
    }

    public static Map<String, Message> parseMessages(PluginProtos.CodeGeneratorRequest request, Set<com.google.api.generator.gapic.model.ResourceReference> outputResourceReferencesSeen) {
        Map<String, Descriptors.FileDescriptor> fileDescriptors = Parser.getFilesToGenerate(request);
        HashMap<String, Message> messages = new HashMap<String, Message>();
        for (Descriptors.FileDescriptor fileDescriptor : fileDescriptors.values()) {
            messages.putAll(Parser.parseMessages(fileDescriptor, outputResourceReferencesSeen));
        }
        return messages;
    }

    public static Map<String, Message> parseMessages(Descriptors.FileDescriptor fileDescriptor) {
        return Parser.parseMessages(fileDescriptor, new HashSet<com.google.api.generator.gapic.model.ResourceReference>());
    }

    public static Map<String, Message> parseMessages(Descriptors.FileDescriptor fileDescriptor, Set<com.google.api.generator.gapic.model.ResourceReference> outputResourceReferencesSeen) {
        HashMap<String, Message> messages = new HashMap<String, Message>();
        for (Descriptors.Descriptor messageDescriptor : fileDescriptor.getMessageTypes()) {
            messages.putAll(Parser.parseMessages(messageDescriptor, outputResourceReferencesSeen));
        }
        for (Descriptors.EnumDescriptor enumDescriptor : fileDescriptor.getEnumTypes()) {
            String name = enumDescriptor.getName();
            List<Descriptors.EnumValueDescriptor> valueDescriptors = enumDescriptor.getValues();
            TypeNode enumType = TypeParser.parseType(enumDescriptor);
            messages.put(enumType.reference().fullName(), Message.builder().setType(enumType).setName(name).setFullProtoName(enumDescriptor.getFullName()).setEnumValues(valueDescriptors.stream().map(v -> v.getName()).collect(Collectors.toList()), valueDescriptors.stream().map(v -> v.getNumber()).collect(Collectors.toList())).build());
        }
        return messages;
    }

    private static Map<String, Message> parseMessages(Descriptors.Descriptor messageDescriptor, Set<com.google.api.generator.gapic.model.ResourceReference> outputResourceReferencesSeen) {
        return Parser.parseMessages(messageDescriptor, outputResourceReferencesSeen, new ArrayList<String>());
    }

    private static Map<String, Message> parseMessages(Descriptors.Descriptor messageDescriptor, Set<com.google.api.generator.gapic.model.ResourceReference> outputResourceReferencesSeen, List<String> outerNestedTypes) {
        HashMap<String, Message> messages = new HashMap<String, Message>();
        String messageName = messageDescriptor.getName();
        for (Descriptors.Descriptor nestedMessage : messageDescriptor.getNestedTypes()) {
            if (Parser.isMapType(nestedMessage)) continue;
            ArrayList<String> currentNestedTypes = new ArrayList<String>(outerNestedTypes);
            currentNestedTypes.add(messageName);
            messages.putAll(Parser.parseMessages(nestedMessage, outputResourceReferencesSeen, currentNestedTypes));
        }
        TypeNode messageType = TypeParser.parseType(messageDescriptor);
        List<Descriptors.FieldDescriptor> fields = messageDescriptor.getFields();
        HashMap<String, String> operationRequestFields = new HashMap<String, String>();
        HashBiMap<String, String> operationResponseFields = HashBiMap.create();
        OperationResponse.Builder operationResponse = null;
        for (Descriptors.FieldDescriptor fd : fields) {
            String orf;
            if (fd.getOptions().hasExtension(ExtendedOperationsProto.operationRequestField)) {
                orf = fd.getOptions().getExtension(ExtendedOperationsProto.operationRequestField);
                operationRequestFields.put(orf, fd.getName());
            }
            if (fd.getOptions().hasExtension(ExtendedOperationsProto.operationResponseField)) {
                orf = fd.getOptions().getExtension(ExtendedOperationsProto.operationResponseField);
                operationResponseFields.put(orf, fd.getName());
            }
            if (!fd.getOptions().hasExtension(ExtendedOperationsProto.operationField)) continue;
            OperationResponseMapping orm = fd.getOptions().getExtension(ExtendedOperationsProto.operationField);
            if (operationResponse == null) {
                operationResponse = OperationResponse.builder();
            }
            if (orm.equals(OperationResponseMapping.NAME)) {
                operationResponse.setNameFieldName(fd.getName());
                continue;
            }
            if (orm.equals(OperationResponseMapping.STATUS)) {
                operationResponse.setStatusFieldName(fd.getName());
                operationResponse.setStatusFieldTypeName(fd.toProto().getTypeName());
                continue;
            }
            if (orm.equals(OperationResponseMapping.ERROR_CODE)) {
                operationResponse.setErrorCodeFieldName(fd.getName());
                continue;
            }
            if (!orm.equals(OperationResponseMapping.ERROR_MESSAGE)) continue;
            operationResponse.setErrorMessageFieldName(fd.getName());
        }
        List nestedEnums = messageDescriptor.getEnumTypes().stream().map(Descriptors.EnumDescriptor::getName).collect(ImmutableList.toImmutableList());
        messages.put(messageType.reference().fullName(), Message.builder().setNestedEnums(nestedEnums).setType(messageType).setName(messageName).setFullProtoName(messageDescriptor.getFullName()).setFields(Parser.parseFields(messageDescriptor, outputResourceReferencesSeen)).setOuterNestedTypes(outerNestedTypes).setOperationRequestFields(operationRequestFields).setOperationResponseFields(operationResponseFields).setOperationResponse(operationResponse != null ? operationResponse.build() : null).build());
        return messages;
    }

    private static boolean isMapType(Descriptors.Descriptor messageDescriptor) {
        List fieldNames = messageDescriptor.getFields().stream().map(f -> f.getName()).collect(Collectors.toList());
        return messageDescriptor.getName().endsWith("Entry") && fieldNames.size() == 2 && ((String)fieldNames.get(0)).equals("key") && ((String)fieldNames.get(1)).equals("value");
    }

    public static Map<String, Message> updateResourceNamesInMessages(Map<String, Message> messageTypes, Collection<ResourceName> resources) {
        HashMap<String, Message> updatedMessages = new HashMap<String, Message>(messageTypes);
        for (ResourceName resource : resources) {
            if (!resource.hasParentMessageName()) continue;
            String messageKey = resource.parentMessageName();
            Message messageToUpdate = (Message)updatedMessages.get(messageKey);
            updatedMessages.put(messageKey, messageToUpdate.toBuilder().setResource(resource).build());
        }
        return updatedMessages;
    }

    public static Map<String, ResourceName> parseResourceNames(PluginProtos.CodeGeneratorRequest request) {
        String javaPackage = Parser.parseServiceJavaPackage(request);
        Map<String, Descriptors.FileDescriptor> fileDescriptors = Parser.getFilesToGenerate(request);
        HashMap<String, ResourceName> resourceNames = new HashMap<String, ResourceName>();
        for (String fileToGenerate : request.getFileToGenerateList()) {
            Descriptors.FileDescriptor fileDescriptor = Preconditions.checkNotNull(fileDescriptors.get(fileToGenerate), "Missing file descriptor for [%s]", (Object)fileToGenerate);
            resourceNames.putAll(Parser.parseResourceNames(fileDescriptor, javaPackage));
        }
        return resourceNames;
    }

    public static Map<String, ResourceName> parseResourceNames(Descriptors.FileDescriptor fileDescriptor) {
        return Parser.parseResourceNames(fileDescriptor, TypeParser.getPackage(fileDescriptor));
    }

    public static Map<String, ResourceName> parseResourceNames(Descriptors.FileDescriptor fileDescriptor, String javaPackage) {
        return ResourceNameParser.parseResourceNames(fileDescriptor, javaPackage);
    }

    @VisibleForTesting
    static List<Method> parseMethods(Descriptors.ServiceDescriptor serviceDescriptor, String servicePackage, Map<String, Message> messageTypes, Map<String, ResourceName> resourceNames, Optional<GapicServiceConfig> serviceConfigOpt, Optional<Service> serviceYamlProtoOpt, Set<ResourceName> outputArgResourceNames, Transport transport) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Map<String, List<String>> autoPopulatedMethodsWithFields = Parser.parseAutoPopulatedMethodsAndFields(serviceYamlProtoOpt);
        for (Descriptors.MethodDescriptor protoMethod : serviceDescriptor.getMethods()) {
            SourceCodeInfoLocation protoMethodLocation;
            TypeNode inputType = TypeParser.parseType(protoMethod.getInputType());
            Method.Builder methodBuilder = Method.builder();
            if (protoMethod.getFile().toProto().hasSourceCodeInfo() && !Objects.isNull(protoMethodLocation = SOURCE_CODE_INFO_PARSER.getLocation(protoMethod)) && !Strings.isNullOrEmpty(protoMethodLocation.getLeadingComments())) {
                methodBuilder.setDescription(protoMethodLocation.getLeadingComments());
            }
            ArrayList<String> autoPopulatedFields = new ArrayList();
            if (autoPopulatedMethodsWithFields.containsKey(protoMethod.getFullName())) {
                autoPopulatedFields = autoPopulatedMethodsWithFields.get(protoMethod.getFullName());
            }
            boolean isDeprecated = false;
            if (protoMethod.getOptions().hasDeprecated()) {
                isDeprecated = protoMethod.getOptions().getDeprecated();
            }
            Message inputMessage = messageTypes.get(inputType.reference().fullName());
            Preconditions.checkNotNull(inputMessage, String.format("No message found for %s", inputType.reference().fullName()));
            HttpBindings httpBindings = HttpRuleParser.parse(protoMethod, inputMessage, messageTypes);
            boolean isBatching = !serviceConfigOpt.isPresent() ? false : serviceConfigOpt.get().hasBatchingSetting(protoMethod.getFile().getPackage(), serviceDescriptor.getName(), protoMethod.getName());
            boolean operationPollingMethod = protoMethod.getOptions().hasExtension(ExtendedOperationsProto.operationPollingMethod) ? protoMethod.getOptions().getExtension(ExtendedOperationsProto.operationPollingMethod) : false;
            RoutingHeaderRule routingHeaderRule = RoutingRuleParser.parse(protoMethod, inputMessage, messageTypes);
            methods.add(methodBuilder.setName(protoMethod.getName()).setInputType(inputType).setOutputType(TypeParser.parseType(protoMethod.getOutputType())).setStream(Method.toStream(protoMethod.isClientStreaming(), protoMethod.isServerStreaming())).setLro(Parser.parseLro(servicePackage, protoMethod, messageTypes)).setMethodSignatures(MethodSignatureParser.parseMethodSignatures(protoMethod, servicePackage, inputType, messageTypes, resourceNames, outputArgResourceNames)).setHttpBindings(httpBindings).setAutoPopulatedFields(autoPopulatedFields).setRoutingHeaderRule(routingHeaderRule).setIsBatching(isBatching).setPageSizeFieldName(Parser.parsePageSizeFieldName(protoMethod, messageTypes, transport)).setIsDeprecated(isDeprecated).setOperationPollingMethod(operationPollingMethod).build());
            for (Field field : inputMessage.fields()) {
                if (!field.hasResourceReference()) continue;
                String resourceTypeString = field.resourceReference().resourceTypeString();
                ResourceName resourceName = null;
                if (resourceTypeString.indexOf(SLASH) < 0) {
                    Optional<String> actualResourceTypeNameOpt = resourceNames.keySet().stream().filter(k -> k.substring(k.lastIndexOf(SLASH) + 1).equals(resourceTypeString)).findFirst();
                    if (actualResourceTypeNameOpt.isPresent()) {
                        resourceName = resourceNames.get(actualResourceTypeNameOpt.get());
                    }
                } else {
                    resourceName = resourceNames.get(resourceTypeString);
                }
                if ("*".equals(resourceTypeString)) {
                    resourceName = WILDCARD_RESOURCE_NAME;
                } else {
                    Preconditions.checkNotNull(resourceName, String.format("Resource name %s not found; parsing field %s in message %s in method %s", resourceTypeString, field.name(), inputMessage.name(), protoMethod.getName()));
                }
                outputArgResourceNames.add(resourceName);
            }
        }
        return methods;
    }

    private static String fetchTypeFullName(String typeName, Descriptors.MethodDescriptor methodDescriptor) {
        int lastDotIndex = typeName.lastIndexOf(46);
        boolean isResponseTypeNameShortOnly = lastDotIndex < 0;
        String responseTypeShortName = lastDotIndex >= 0 ? typeName.substring(lastDotIndex + 1) : typeName;
        String typeFullName = isResponseTypeNameShortOnly ? methodDescriptor.getFile().getPackage() + DOT + responseTypeShortName : typeName;
        return typeFullName;
    }

    @VisibleForTesting
    static LongrunningOperation parseLro(String servicePackage, Descriptors.MethodDescriptor methodDescriptor, Map<String, Message> messageTypes) {
        DescriptorProtos.MethodOptions methodOptions = methodDescriptor.getOptions();
        TypeNode operationServiceStubType = null;
        String responseTypeName = null;
        String metadataTypeName = null;
        if (methodOptions.hasExtension(OperationsProto.operationInfo)) {
            OperationInfo lroInfo = methodDescriptor.getOptions().getExtension(OperationsProto.operationInfo);
            responseTypeName = lroInfo.getResponseType();
            metadataTypeName = lroInfo.getMetadataType();
        }
        if (methodOptions.hasExtension(ExtendedOperationsProto.operationService)) {
            String opServiceName = methodOptions.getExtension(ExtendedOperationsProto.operationService);
            operationServiceStubType = TypeNode.withReference(VaporReference.builder().setName(opServiceName + "Stub").setPakkage(servicePackage + ".stub").build());
            if (responseTypeName == null) {
                responseTypeName = methodDescriptor.getOutputType().getFullName();
            }
            if (metadataTypeName == null) {
                metadataTypeName = methodDescriptor.getOutputType().getFullName();
            }
        }
        if (responseTypeName == null || metadataTypeName == null) {
            return null;
        }
        Message responseMessage = null;
        Message metadataMessage = null;
        String responseTypeFullName = Parser.fetchTypeFullName(responseTypeName, methodDescriptor);
        String metadataTypeFullName = Parser.fetchTypeFullName(metadataTypeName, methodDescriptor);
        for (Map.Entry<String, Message> messageEntry : messageTypes.entrySet()) {
            Message candidateMessage = messageEntry.getValue();
            if (responseMessage == null && candidateMessage.fullProtoName().equals(responseTypeFullName)) {
                responseMessage = candidateMessage;
            }
            if (metadataMessage != null || !candidateMessage.fullProtoName().equals(metadataTypeFullName)) continue;
            metadataMessage = candidateMessage;
        }
        Preconditions.checkNotNull(responseMessage, String.format("LRO response message %s not found on method %s", responseTypeName, methodDescriptor.getName()));
        Preconditions.checkNotNull(metadataMessage, String.format("LRO metadata message %s not found in method %s", metadataTypeName, methodDescriptor.getName()));
        return LongrunningOperation.builder().setResponseType(responseMessage.type()).setMetadataType(metadataMessage.type()).setOperationServiceStubType(operationServiceStubType).build();
    }

    @VisibleForTesting
    static String parsePageSizeFieldName(Descriptors.MethodDescriptor methodDescriptor, Map<String, Message> messageTypes, Transport transport) {
        TypeNode inputMessageType = TypeParser.parseType(methodDescriptor.getInputType());
        TypeNode outputMessageType = TypeParser.parseType(methodDescriptor.getOutputType());
        Message inputMessage = messageTypes.get(inputMessageType.reference().fullName());
        Message outputMessage = messageTypes.get(outputMessageType.reference().fullName());
        String pagedFieldName = null;
        if (inputMessage != null && inputMessage.fieldMap().containsKey("page_token") && outputMessage != null && outputMessage.fieldMap().containsKey("next_page_token")) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            fieldNames.add("page_size");
            if (transport == Transport.REST) {
                fieldNames.add("max_results");
            }
            for (String fieldName : fieldNames) {
                if (pagedFieldName != null || !inputMessage.fieldMap().containsKey(fieldName)) continue;
                pagedFieldName = fieldName;
            }
        }
        return pagedFieldName;
    }

    @VisibleForTesting
    static String sanitizeDefaultHost(String rawDefaultHost) {
        if (rawDefaultHost.contains(COLON)) {
            return rawDefaultHost;
        }
        return String.format("%s:%s", rawDefaultHost, DEFAULT_PORT);
    }

    private static List<Field> parseFields(Descriptors.Descriptor messageDescriptor, Set<com.google.api.generator.gapic.model.ResourceReference> outputResourceReferencesSeen) {
        ArrayList<Descriptors.FieldDescriptor> fields = new ArrayList<Descriptors.FieldDescriptor>(messageDescriptor.getFields());
        fields.sort((f1, f2) -> f1.getIndex() - f2.getIndex());
        Map<String, Integer> repeatedFieldNamesToNumber = fields.stream().filter(f -> f.isRepeated()).collect(Collectors.toMap(f -> f.getName(), f -> f.getNumber()));
        HashSet<Integer> fieldNumbersWithConflicts = new HashSet<Integer>();
        for (Descriptors.FieldDescriptor field : fields) {
            Set conflictingRepeatedFieldNames = repeatedFieldNamesToNumber.keySet().stream().filter(n -> field.getName().equals(n + "_count") || field.getName().equals(n + "_list")).collect(Collectors.toSet());
            if (conflictingRepeatedFieldNames.isEmpty()) continue;
            fieldNumbersWithConflicts.addAll(conflictingRepeatedFieldNames.stream().map(n -> (Integer)repeatedFieldNamesToNumber.get(n)).collect(Collectors.toSet()));
            fieldNumbersWithConflicts.add(field.getNumber());
        }
        return fields.stream().map(f -> Parser.parseField(f, messageDescriptor, fieldNumbersWithConflicts.contains(f.getNumber()), outputResourceReferencesSeen)).collect(Collectors.toList());
    }

    private static Field parseField(Descriptors.FieldDescriptor fieldDescriptor, Descriptors.Descriptor messageDescriptor, boolean hasFieldNameConflict, Set<com.google.api.generator.gapic.model.ResourceReference> outputResourceReferencesSeen) {
        SourceCodeInfoLocation protoFieldLocation;
        DescriptorProtos.FieldOptions fieldOptions = fieldDescriptor.getOptions();
        DescriptorProtos.MessageOptions messageOptions = messageDescriptor.getOptions();
        com.google.api.generator.gapic.model.ResourceReference resourceReference = null;
        boolean isRequired = false;
        FieldInfo.Format fieldInfoFormat = null;
        if (fieldOptions.hasExtension(ResourceProto.resourceReference)) {
            ResourceReference protoResourceReference = fieldOptions.getExtension(ResourceProto.resourceReference);
            String typeString = protoResourceReference.getType();
            String childTypeString = protoResourceReference.getChildType();
            Preconditions.checkState(!Strings.isNullOrEmpty(typeString) ^ !Strings.isNullOrEmpty(childTypeString), String.format("Exactly one of type or child_type must be set for resource_reference in field %s", fieldDescriptor.getName()));
            boolean isChildType = !Strings.isNullOrEmpty(childTypeString);
            resourceReference = isChildType ? com.google.api.generator.gapic.model.ResourceReference.withChildType(childTypeString) : com.google.api.generator.gapic.model.ResourceReference.withType(typeString);
            outputResourceReferencesSeen.add(resourceReference);
        } else if (messageOptions.hasExtension(ResourceProto.resource)) {
            ResourceDescriptor protoResource = messageOptions.getExtension(ResourceProto.resource);
            String resourceFieldNameValue = "name";
            if (!Strings.isNullOrEmpty(protoResource.getNameField())) {
                resourceFieldNameValue = protoResource.getNameField();
            }
            if (fieldDescriptor.getName().equals(resourceFieldNameValue)) {
                resourceReference = com.google.api.generator.gapic.model.ResourceReference.withType(protoResource.getType());
            }
        }
        if (fieldOptions.hasExtension(FieldInfoProto.fieldInfo)) {
            fieldInfoFormat = fieldOptions.getExtension(FieldInfoProto.fieldInfo).getFormat();
        }
        if (fieldOptions.getExtensionCount(FieldBehaviorProto.fieldBehavior) > 0 && fieldOptions.getExtension(FieldBehaviorProto.fieldBehavior).contains(FieldBehavior.REQUIRED)) {
            isRequired = true;
        }
        Field.Builder fieldBuilder = Field.builder();
        if (fieldDescriptor.getFile().toProto().hasSourceCodeInfo() && !Objects.isNull(protoFieldLocation = SOURCE_CODE_INFO_PARSER.getLocation(fieldDescriptor)) && !Strings.isNullOrEmpty(protoFieldLocation.getLeadingComments())) {
            fieldBuilder.setDescription(protoFieldLocation.getLeadingComments());
        }
        String actualFieldName = hasFieldNameConflict ? fieldDescriptor.getName() + fieldDescriptor.getNumber() : fieldDescriptor.getName();
        return fieldBuilder.setName(actualFieldName).setOriginalName(fieldDescriptor.getName()).setType(TypeParser.parseType(fieldDescriptor)).setIsMessage(fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE).setIsEnum(fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM).setIsContainedInOneof(fieldDescriptor.getRealContainingOneof() != null).setIsProto3Optional(fieldDescriptor.getContainingOneof() != null && fieldDescriptor.getRealContainingOneof() == null).setIsRepeated(fieldDescriptor.isRepeated()).setIsRequired(isRequired).setFieldInfoFormat(fieldInfoFormat).setIsMap(fieldDescriptor.isMapField()).setResourceReference(resourceReference).build();
    }

    private static Map<String, Descriptors.FileDescriptor> getFilesToGenerate(PluginProtos.CodeGeneratorRequest request) {
        HashMap<String, Descriptors.FileDescriptor> fileDescriptors = Maps.newHashMap();
        for (DescriptorProtos.FileDescriptorProto fileDescriptorProto : request.getProtoFileList()) {
            Descriptors.FileDescriptor[] deps = new Descriptors.FileDescriptor[fileDescriptorProto.getDependencyCount()];
            for (int i = 0; i < fileDescriptorProto.getDependencyCount(); ++i) {
                String name = fileDescriptorProto.getDependency(i);
                deps[i] = Preconditions.checkNotNull((Descriptors.FileDescriptor)fileDescriptors.get(name), "Missing file descriptor for [%s]", (Object)name);
            }
            Descriptors.FileDescriptor fileDescriptor = null;
            try {
                fileDescriptor = Descriptors.FileDescriptor.buildFrom(fileDescriptorProto, deps);
            }
            catch (Descriptors.DescriptorValidationException e) {
                throw new GapicParserException(e.getMessage());
            }
            fileDescriptors.put(fileDescriptor.getName(), fileDescriptor);
        }
        return fileDescriptors;
    }

    private static String parseServiceJavaPackage(PluginProtos.CodeGeneratorRequest request) {
        String finalJavaPackage;
        HashMap<String, Integer> javaPackageCount = new HashMap<String, Integer>();
        Map<String, Descriptors.FileDescriptor> fileDescriptors = Parser.getFilesToGenerate(request);
        for (String fileToGenerate : request.getFileToGenerateList()) {
            Descriptors.FileDescriptor fileDescriptor = Preconditions.checkNotNull(fileDescriptors.get(fileToGenerate), "Missing file descriptor for [%s]", (Object)fileToGenerate);
            String javaPackage = fileDescriptor.getOptions().getJavaPackage();
            if (Strings.isNullOrEmpty(javaPackage)) continue;
            if (javaPackageCount.containsKey(javaPackage)) {
                javaPackageCount.put(javaPackage, (Integer)javaPackageCount.get(javaPackage) + 1);
                continue;
            }
            javaPackageCount.put(javaPackage, 1);
        }
        Map<String, Integer> processedJavaPackageCount = javaPackageCount.entrySet().stream().filter(e -> !MIXIN_JAVA_PACKAGE_ALLOWLIST.contains(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Integer)e.getValue()));
        if (processedJavaPackageCount.isEmpty()) {
            processedJavaPackageCount = javaPackageCount;
        }
        Preconditions.checkState(!Strings.isNullOrEmpty(finalJavaPackage = (String)processedJavaPackageCount.entrySet().stream().max(Map.Entry.comparingByValue()).get().getKey()), "No service Java package found");
        return finalJavaPackage;
    }

    @VisibleForTesting
    static String parseNestedProtoTypeName(String fullyQualifiedName) {
        if (!fullyQualifiedName.contains(DOT)) {
            return fullyQualifiedName;
        }
        String[] components = fullyQualifiedName.split("\\.");
        List nestedTypeComponents = IntStream.range(0, components.length).filter(i -> Character.isUpperCase(components[i].charAt(0))).mapToObj(i -> components[i]).collect(Collectors.toList());
        return String.join((CharSequence)DOT, nestedTypeComponents);
    }

    @VisibleForTesting
    static Map<String, List<String>> parseAutoPopulatedMethodsAndFields(Optional<Service> serviceYamlProtoOpt) {
        if (!Parser.hasMethodSettings(serviceYamlProtoOpt)) {
            return ImmutableMap.builder().build();
        }
        return serviceYamlProtoOpt.get().getPublishing().getMethodSettingsList().stream().collect(Collectors.toMap(MethodSettings::getSelector, MethodSettings::getAutoPopulatedFieldsList));
    }

    @VisibleForTesting
    static boolean hasMethodSettings(Optional<Service> serviceYamlProtoOpt) {
        return serviceYamlProtoOpt.isPresent() && serviceYamlProtoOpt.get().hasPublishing();
    }

    static class GapicParserException
    extends RuntimeException {
        public GapicParserException(String errorMessage) {
            super(errorMessage);
        }
    }
}

