/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.IfStatement;
import com.google.api.generator.engine.ast.Statement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;

final class AutoValue_IfStatement
extends IfStatement {
    private final Expr conditionExpr;
    private final ImmutableList<Statement> body;
    private final ImmutableMap<Expr, List<Statement>> elseIfs;
    private final ImmutableList<Statement> elseBody;

    private AutoValue_IfStatement(Expr conditionExpr, ImmutableList<Statement> body, ImmutableMap<Expr, List<Statement>> elseIfs, ImmutableList<Statement> elseBody) {
        this.conditionExpr = conditionExpr;
        this.body = body;
        this.elseIfs = elseIfs;
        this.elseBody = elseBody;
    }

    @Override
    public Expr conditionExpr() {
        return this.conditionExpr;
    }

    @Override
    public ImmutableList<Statement> body() {
        return this.body;
    }

    @Override
    public ImmutableMap<Expr, List<Statement>> elseIfs() {
        return this.elseIfs;
    }

    @Override
    public ImmutableList<Statement> elseBody() {
        return this.elseBody;
    }

    public String toString() {
        return "IfStatement{conditionExpr=" + this.conditionExpr + ", body=" + this.body + ", elseIfs=" + this.elseIfs + ", elseBody=" + this.elseBody + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IfStatement) {
            IfStatement that = (IfStatement)o;
            return this.conditionExpr.equals(that.conditionExpr()) && this.body.equals(that.body()) && this.elseIfs.equals(that.elseIfs()) && this.elseBody.equals(that.elseBody());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.conditionExpr.hashCode();
        h$ *= 1000003;
        h$ ^= this.body.hashCode();
        h$ *= 1000003;
        h$ ^= this.elseIfs.hashCode();
        h$ *= 1000003;
        return h$ ^= this.elseBody.hashCode();
    }

    static final class Builder
    extends IfStatement.Builder {
        private Expr conditionExpr;
        private ImmutableList<Statement> body;
        private ImmutableMap.Builder<Expr, List<Statement>> elseIfsBuilder$;
        private ImmutableMap<Expr, List<Statement>> elseIfs;
        private ImmutableList<Statement> elseBody;

        Builder() {
        }

        @Override
        public IfStatement.Builder setConditionExpr(Expr conditionExpr) {
            if (conditionExpr == null) {
                throw new NullPointerException("Null conditionExpr");
            }
            this.conditionExpr = conditionExpr;
            return this;
        }

        @Override
        public IfStatement.Builder setBody(List<Statement> body) {
            this.body = ImmutableList.copyOf(body);
            return this;
        }

        @Override
        IfStatement.Builder setElseIfs(ImmutableMap<Expr, List<Statement>> elseIfs) {
            if (elseIfs == null) {
                throw new NullPointerException("Null elseIfs");
            }
            if (this.elseIfsBuilder$ != null) {
                throw new IllegalStateException("Cannot set elseIfs after calling elseIfsBuilder()");
            }
            this.elseIfs = elseIfs;
            return this;
        }

        @Override
        ImmutableMap.Builder<Expr, List<Statement>> elseIfsBuilder() {
            if (this.elseIfsBuilder$ == null) {
                if (this.elseIfs == null) {
                    this.elseIfsBuilder$ = ImmutableMap.builder();
                } else {
                    this.elseIfsBuilder$ = ImmutableMap.builder();
                    this.elseIfsBuilder$.putAll(this.elseIfs);
                    this.elseIfs = null;
                }
            }
            return this.elseIfsBuilder$;
        }

        @Override
        public IfStatement.Builder setElseBody(List<Statement> elseBody) {
            this.elseBody = ImmutableList.copyOf(elseBody);
            return this;
        }

        @Override
        IfStatement autoBuild() {
            if (this.elseIfsBuilder$ != null) {
                this.elseIfs = this.elseIfsBuilder$.buildOrThrow();
            } else if (this.elseIfs == null) {
                this.elseIfs = ImmutableMap.of();
            }
            if (this.conditionExpr == null || this.body == null || this.elseBody == null) {
                StringBuilder missing = new StringBuilder();
                if (this.conditionExpr == null) {
                    missing.append(" conditionExpr");
                }
                if (this.body == null) {
                    missing.append(" body");
                }
                if (this.elseBody == null) {
                    missing.append(" elseBody");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_IfStatement(this.conditionExpr, this.body, this.elseIfs, this.elseBody);
        }
    }
}

