/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.xds.FilterChainMatchingProtocolNegotiators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;

final class FilterChainSelectorManager {
    private static final AtomicLong closerId = new AtomicLong();
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector selector;
    @GuardedBy(value="lock")
    private TreeSet<Closer> closers = new TreeSet<Closer>(new CloserComparator());

    FilterChainSelectorManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector register(Closer closer) {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(this.closers.add(closer), "closer already registered");
            return this.selector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(Closer closer) {
        Object object = this.lock;
        synchronized (object) {
            this.closers.remove(closer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector getSelectorToUpdateSelector() {
        Object object = this.lock;
        synchronized (object) {
            return this.selector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelector(FilterChainMatchingProtocolNegotiators.FilterChainMatchingHandler.FilterChainSelector newSelector) {
        TreeSet<Closer> oldClosers;
        Iterator<Closer> iterator2 = this.lock;
        synchronized (iterator2) {
            oldClosers = this.closers;
            this.closers = new TreeSet<Closer>(this.closers.comparator());
            this.selector = newSelector;
        }
        for (Closer closer : oldClosers) {
            closer.closer.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getRegisterCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.closers.size();
        }
    }

    static /* synthetic */ AtomicLong access$200() {
        return closerId;
    }

    private static class CloserComparator
    implements Comparator<Closer> {
        private CloserComparator() {
        }

        @Override
        public int compare(Closer c1, Closer c2) {
            return Long.compare(c1.id, c2.id);
        }
    }

    public static final class Closer {
        private final long id = FilterChainSelectorManager.access$200().getAndIncrement();
        private final Runnable closer;

        public Closer(Runnable closer) {
            this.closer = Preconditions.checkNotNull(closer, "closer");
        }
    }
}

